/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.template.interval;

import de.fhdw.hfp416.spaces.template.interval.IntervalAffiliation;
import de.fhdw.hfp416.spaces.template.interval.IntervalBound;
import de.fhdw.hfp416.spaces.template.interval.IntervalBoundReturnVisitor;
import de.fhdw.hfp416.spaces.template.interval.IntervalBoundVisitor;
import de.fhdw.hfp416.spaces.template.interval.UnlimitedLowerIntervalBound;
import de.fhdw.hfp416.spaces.template.interval.UnlimitedUpperIntervalBound;

public class NumberIntervalBound<N extends Number>
extends IntervalBound<N> {
    private N boundValue;

    public NumberIntervalBound(N boundValue) {
        this.setBoundValue(boundValue);
    }

    public NumberIntervalBound(N boundValue, IntervalAffiliation affiliation) {
        this.setBoundValue(boundValue);
        this.setAffiliation(affiliation);
    }

    public N getBoundValue() {
        return this.boundValue;
    }

    public void setBoundValue(N boundValue) {
        this.boundValue = boundValue;
    }

    @Override
    public boolean isSmallerOrEqual(N value) {
        return ((Number)this.getBoundValue()).doubleValue() <= ((Number)value).doubleValue();
    }

    @Override
    public boolean isSmallerOrEqual(IntervalBound<N> other) {
        return (Boolean)other.accept(new IntervalBoundReturnVisitor<Boolean, N>(){

            @Override
            public Boolean handle(NumberIntervalBound<N> bound) {
                return ((Number)NumberIntervalBound.this.getBoundValue()).doubleValue() <= ((Number)bound.getBoundValue()).doubleValue();
            }

            @Override
            public Boolean handle(UnlimitedUpperIntervalBound<N> bound) {
                return true;
            }

            @Override
            public Boolean handle(UnlimitedLowerIntervalBound<N> bound) {
                return false;
            }
        });
    }

    @Override
    public void accept(IntervalBoundVisitor<N> visitor) {
        visitor.handle(this);
    }

    @Override
    public <T> T accept(IntervalBoundReturnVisitor<T, N> visitor) {
        return visitor.handle(this);
    }

    @Override
    public boolean isGreaterOrEqual(N value) {
        return ((Number)this.getBoundValue()).doubleValue() >= ((Number)value).doubleValue();
    }

    @Override
    public boolean isGreaterOrEqual(IntervalBound<N> other) {
        return (Boolean)other.accept(new IntervalBoundReturnVisitor<Boolean, N>(){

            @Override
            public Boolean handle(NumberIntervalBound<N> bound) {
                return ((Number)NumberIntervalBound.this.getBoundValue()).doubleValue() >= ((Number)bound.getBoundValue()).doubleValue();
            }

            @Override
            public Boolean handle(UnlimitedUpperIntervalBound<N> bound) {
                return false;
            }

            @Override
            public Boolean handle(UnlimitedLowerIntervalBound<N> bound) {
                return true;
            }
        });
    }

    @Override
    public boolean isSmaller(N value) {
        return ((Number)this.getBoundValue()).doubleValue() < ((Number)value).doubleValue();
    }

    @Override
    public boolean isSmaller(IntervalBound<N> other) {
        return (Boolean)other.accept(new IntervalBoundReturnVisitor<Boolean, N>(){

            @Override
            public Boolean handle(NumberIntervalBound<N> bound) {
                return ((Number)NumberIntervalBound.this.getBoundValue()).doubleValue() < ((Number)bound.getBoundValue()).doubleValue();
            }

            @Override
            public Boolean handle(UnlimitedUpperIntervalBound<N> bound) {
                return false;
            }

            @Override
            public Boolean handle(UnlimitedLowerIntervalBound<N> bound) {
                return true;
            }
        });
    }

    @Override
    public boolean isGreater(N value) {
        return ((Number)this.getBoundValue()).doubleValue() > ((Number)value).doubleValue();
    }

    @Override
    public boolean isGreater(IntervalBound<N> other) {
        return (Boolean)other.accept(new IntervalBoundReturnVisitor<Boolean, N>(){

            @Override
            public Boolean handle(NumberIntervalBound<N> bound) {
                return ((Number)NumberIntervalBound.this.getBoundValue()).doubleValue() > ((Number)bound.getBoundValue()).doubleValue();
            }

            @Override
            public Boolean handle(UnlimitedUpperIntervalBound<N> bound) {
                return false;
            }

            @Override
            public Boolean handle(UnlimitedLowerIntervalBound<N> bound) {
                return true;
            }
        });
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.boundValue == null ? 0 : this.boundValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberIntervalBound other = (NumberIntervalBound)obj;
        return !(this.boundValue == null ? other.boundValue != null : !this.boundValue.equals(other.boundValue));
    }

    public String toString() {
        return this.boundValue.toString();
    }
}

