/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces;

import de.fhdw.hfp416.spaces.EntryId;
import de.fhdw.hfp416.spaces.ISpace;
import de.fhdw.hfp416.spaces.SpaceService;
import de.fhdw.hfp416.spaces.accessrequest.AccessRequest;
import de.fhdw.hfp416.spaces.accessrequest.GetMetaInfoAccessRequest;
import de.fhdw.hfp416.spaces.accessrequest.ReadAccessRequest;
import de.fhdw.hfp416.spaces.accessrequest.TakeAccessRequest;
import de.fhdw.hfp416.spaces.accessrequest.TemplateAccessRequest;
import de.fhdw.hfp416.spaces.accessrequest.WriteAccessRequest;
import de.fhdw.hfp416.spaces.entry.Entry;
import de.fhdw.hfp416.spaces.exception.DuplicateAttributeNameException;
import de.fhdw.hfp416.spaces.exception.NoMetaInfoFoundException;
import de.fhdw.hfp416.spaces.exception.deserialization.DeserializationException;
import de.fhdw.hfp416.spaces.remoteentry.EntryMetaInfo;
import de.fhdw.hfp416.spaces.remoteentry.RemoteEntry;
import de.fhdw.hfp416.spaces.serialization.ISpaceSerializer;
import de.fhdw.hfp416.spaces.serialization.SpaceSerializer;
import de.fhdw.hfp416.spaces.template.Template;
import de.fhdw.hfp416.spaces.time.timespan.Timespan;
import de.fhdw.hfp416.spaces.util.future.Future;
import de.fhdw.hfp416.spaces.util.future.FutureReturnrequestAbortedException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class Space
implements ISpace {
    private final ISpaceSerializer serializer;
    private final BlockingQueue<AccessRequest<?>> requests = new LinkedBlockingQueue();

    public Space(ISpaceSerializer serializer) {
        this.serializer = serializer;
        SpaceService spaceService = new SpaceService(this.requests);
        spaceService.start();
    }

    public Space() {
        this(new SpaceSerializer());
    }

    @Override
    public RemoteEntry write(Object object, Timespan timespan) throws FutureReturnrequestAbortedException, DuplicateAttributeNameException {
        Entry entry = this.serializer.serialize(object);
        Future<EntryId> returnValue = new Future<EntryId>();
        Future<EntryMetaInfo> futureMetaInfo = new Future<EntryMetaInfo>();
        WriteAccessRequest request = new WriteAccessRequest(returnValue, futureMetaInfo, timespan, entry);
        this.requests.add(request);
        return new RemoteEntry(this, returnValue.get(), futureMetaInfo);
    }

    @Override
    public Object read(Template template, Timespan timespan) throws DeserializationException, FutureReturnrequestAbortedException {
        Future<Entry> futureEntry = new Future<Entry>();
        ReadAccessRequest request = new ReadAccessRequest(futureEntry, timespan, template);
        return this.readOrTake(request, futureEntry);
    }

    @Override
    public Object take(Template template, Timespan timeout) throws DeserializationException, FutureReturnrequestAbortedException {
        Future<Entry> futureEntry = new Future<Entry>();
        TakeAccessRequest request = new TakeAccessRequest(futureEntry, timeout, template);
        return this.readOrTake(request, futureEntry);
    }

    private Object readOrTake(TemplateAccessRequest request, Future<Entry> futureEntry) throws DeserializationException, FutureReturnrequestAbortedException {
        this.requests.add(request);
        return this.serializer.deserialize(futureEntry.get());
    }

    public EntryMetaInfo getEntryMetaInfo(EntryId entryId) throws NoMetaInfoFoundException {
        Future<EntryMetaInfo> returnFuture = new Future<EntryMetaInfo>();
        GetMetaInfoAccessRequest request = new GetMetaInfoAccessRequest(returnFuture, entryId);
        this.requests.add(request);
        try {
            return returnFuture.get();
        }
        catch (FutureReturnrequestAbortedException ex) {
            throw new NoMetaInfoFoundException(entryId);
        }
    }
}

