/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.serialization;

import de.fhdw.hfp416.spaces.serialization.SpaceSerializerReflectionHelper;
import de.fhdw.hfp416.spaces.serialization.visitor.ObjectReturnExceptionVisitor;
import de.fhdw.hfp416.spaces.template.FalseTemplate;
import de.fhdw.hfp416.spaces.template.MapTemplate;
import de.fhdw.hfp416.spaces.template.NullTemplate;
import de.fhdw.hfp416.spaces.template.NumberInterval;
import de.fhdw.hfp416.spaces.template.ObjectTemplate;
import de.fhdw.hfp416.spaces.template.OrTemplate;
import de.fhdw.hfp416.spaces.template.ReferenceTemplate;
import de.fhdw.hfp416.spaces.template.RegularExpressionTemplate;
import de.fhdw.hfp416.spaces.template.Template;
import de.fhdw.hfp416.spaces.template.TrueTemplate;
import de.fhdw.hfp416.spaces.template.interval.Inclusive;
import de.fhdw.hfp416.spaces.template.interval.NumberIntervalBound;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.lang.model.type.NullType;

public class TemplateFactory {
    public Template createTemplate(Object object) throws SecurityException {
        return (Template)new SpaceTemplateResolver().handle(object);
    }

    private static class SpaceTemplateResolver
    extends ObjectReturnExceptionVisitor<Template, SecurityException> {
        private final Map<String, LinkedList<FutureTemplateInformation>> templatesMappedByName = new HashMap<String, LinkedList<FutureTemplateInformation>>();

        private SpaceTemplateResolver() {
        }

        @Override
        public Template handle(NullType object) {
            return new NullTemplate();
        }

        @Override
        public Template handle(Byte object) {
            return this.createNumberInterval(object, Byte.class);
        }

        @Override
        public Template handle(Short object) {
            return this.createNumberInterval(object, Short.class);
        }

        @Override
        public Template handle(Integer object) {
            return this.createNumberInterval(object, Integer.class);
        }

        @Override
        public Template handle(Long object) {
            return this.createNumberInterval(object, Long.class);
        }

        @Override
        public Template handle(Float object) {
            return this.createNumberInterval(object, Float.class);
        }

        @Override
        public Template handle(Double object) {
            return this.createNumberInterval(object, Double.class);
        }

        @Override
        public Template handle(Boolean object) {
            if (object.booleanValue()) {
                return new TrueTemplate();
            }
            return new FalseTemplate();
        }

        @Override
        public Template handle(Character object) {
            return this.handle(String.valueOf(object));
        }

        @Override
        public Template handle(String object) {
            return new RegularExpressionTemplate(object);
        }

        @Override
        public Template handle(Collection<?> object) {
            OrTemplate result = new OrTemplate();
            for (Object item : object) {
                result.add((Template)this.handle(item));
            }
            return result;
        }

        @Override
        public Template handle(Object[] object) throws SecurityException {
            OrTemplate result = new OrTemplate();
            for (Object item : object) {
                result.add((Template)this.handle(item));
            }
            return result;
        }

        @Override
        public Template handle(Map<?, ?> object) {
            Class<?> objectClass = object.getClass();
            String namespace = objectClass.getPackage().getName();
            String fullName = objectClass.getName();
            String name = fullName.substring(namespace.length() + 1);
            HashMap<Template, Template> map = new HashMap<Template, Template>();
            for (Map.Entry<?, ?> item : object.entrySet()) {
                map.put((Template)this.handle(item.getKey()), (Template)this.handle(item.getValue()));
            }
            return new MapTemplate(name, namespace, map);
        }

        @Override
        public Template elseHandle(Object object) throws SecurityException {
            return this.constructObjectTemplateOrReferenceTemplate(object);
        }

        private <V extends Number> NumberInterval<V> createNumberInterval(V value, Class<V> clazz) {
            NumberIntervalBound<V> bound = new NumberIntervalBound<V>(value, new Inclusive());
            return new NumberInterval<V>(bound, bound, clazz);
        }

        private Template constructObjectTemplateOrReferenceTemplate(Object object) throws SecurityException {
            Class<?> objectClass = object.getClass();
            String namespace = objectClass.getPackage().getName();
            String fullName = objectClass.getName();
            String name = fullName.substring(namespace.length() + 1);
            if (!this.templatesMappedByName.containsKey(fullName)) {
                this.templatesMappedByName.put(fullName, new LinkedList());
            }
            LinkedList<FutureTemplateInformation> templatesForName = this.templatesMappedByName.get(fullName);
            for (FutureTemplateInformation templateUnderConstruction : templatesForName) {
                if (templateUnderConstruction.object != object) continue;
                ReferenceTemplate referenceTemplate = new ReferenceTemplate(templateUnderConstruction.constructedTemplate);
                return referenceTemplate;
            }
            ObjectTemplate template = new ObjectTemplate(name, namespace);
            templatesForName.add(new FutureTemplateInformation(object, template));
            for (Field field : SpaceSerializerReflectionHelper.getAllNecessaryFields(objectClass)) {
                template.addTemplate(field.getName(), (Template)this.handle(SpaceSerializerReflectionHelper.getFieldValue(field, object)));
            }
            return new ReferenceTemplate(template);
        }

        private static class FutureTemplateInformation {
            private final Object object;
            private final ObjectTemplate constructedTemplate;

            private FutureTemplateInformation(Object object, ObjectTemplate constructedTemplate) {
                this.object = object;
                this.constructedTemplate = constructedTemplate;
            }
        }
    }
}

