/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.template;

import de.fhdw.hfp416.spaces.entry.Entry;
import java.util.HashMap;
import java.util.Map;

public abstract class Template {
    private String name;
    private String namespace;

    protected Template() {
    }

    protected Template(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public boolean match(Entry entry) {
        return this.matchInternal(entry, new HashMap<Template, Entry>());
    }

    protected final boolean matchInternal(Entry entry, Map<Template, Entry> alreadyCheckedEntries) {
        return this.matchNameAndNamespace(entry) && this.matchAttributes(entry, alreadyCheckedEntries);
    }

    protected boolean matchNameAndNamespace(Entry entry) {
        return this.getName().equals(entry.getName()) && this.getNamespace().equals(entry.getNamespace());
    }

    protected abstract boolean matchAttributes(Entry var1, Map<Template, Entry> var2);

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Template other = (Template)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getNamespace() == null ? other.getNamespace() != null : !this.getNamespace().equals(other.getNamespace()));
    }
}

