/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces;

import de.fhdw.hfp416.spaces.EntryId;
import de.fhdw.hfp416.spaces.access.ReadAccess;
import de.fhdw.hfp416.spaces.access.TakeAccess;
import de.fhdw.hfp416.spaces.access.TemplateAccess;
import de.fhdw.hfp416.spaces.access.TemplateAccessReturnVisitor;
import de.fhdw.hfp416.spaces.access.TemplateAccessVisitor;
import de.fhdw.hfp416.spaces.access.WriteAccess;
import de.fhdw.hfp416.spaces.access.match.MatchResultVisitor;
import de.fhdw.hfp416.spaces.access.match.MatchedMatchResult;
import de.fhdw.hfp416.spaces.access.match.NoMatchMatchResult;
import de.fhdw.hfp416.spaces.access.match.NotMatchBcExpiredMatchResult;
import de.fhdw.hfp416.spaces.exception.NoMetaInfoFoundException;
import de.fhdw.hfp416.spaces.remoteentry.EntryMetaInfo;
import de.fhdw.hfp416.spaces.remoteentry.info.DeadBcTakenEntryInfo;
import de.fhdw.hfp416.spaces.remoteentry.info.DeadBcTimeoutEntryInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class SpaceStore {
    private final Collection<WriteAccess> writeAccesses = new LinkedList<WriteAccess>();
    private final Collection<TemplateAccess> readOrTakeAccesses = new LinkedList<TemplateAccess>();
    private final Map<EntryId, EntryMetaInfo> entryMetaInfos = new HashMap<EntryId, EntryMetaInfo>();

    public void write(final WriteAccess access) {
        final EntryMetaInfo metaInfo = new EntryMetaInfo(access.getEntry());
        final Iterator<TemplateAccess> iReadOrTake = this.readOrTakeAccesses.iterator();
        while (iReadOrTake.hasNext()) {
            final TemplateAccess current = iReadOrTake.next();
            if (current.isExpired()) {
                current.abort();
                iReadOrTake.remove();
                continue;
            }
            if (!current.match(access).accept(new MatchResultVisitor<Boolean>(){

                @Override
                public Boolean handle(MatchedMatchResult result) {
                    metaInfo.incrementReadCount();
                    current.setEntry(access.getEntry());
                    iReadOrTake.remove();
                    return current.accept(new TemplateAccessReturnVisitor<Boolean>(){

                        @Override
                        public Boolean handle(ReadAccess access) {
                            return false;
                        }

                        @Override
                        public Boolean handle(TakeAccess takeAccess) {
                            access.receiveMetaInfo(metaInfo, new DeadBcTakenEntryInfo());
                            return true;
                        }
                    });
                }

                @Override
                public Boolean handle(NotMatchBcExpiredMatchResult result) {
                    access.receiveMetaInfo(metaInfo, new DeadBcTimeoutEntryInfo());
                    return true;
                }

                @Override
                public Boolean handle(NoMatchMatchResult result) {
                    return false;
                }
            }).booleanValue()) continue;
            return;
        }
        this.writeAccesses.add(access);
        this.entryMetaInfos.put(access.getEntryId(), metaInfo);
    }

    public void readOrTake(final TemplateAccess readOrTakeAccess) {
        final Iterator<WriteAccess> iWrites = this.writeAccesses.iterator();
        while (iWrites.hasNext()) {
            final WriteAccess current = iWrites.next();
            if (!readOrTakeAccess.match(current).accept(new MatchResultVisitor<Boolean>(){

                @Override
                public Boolean handle(MatchedMatchResult result) {
                    ((EntryMetaInfo)SpaceStore.this.entryMetaInfos.get(current.getEntryId())).incrementReadCount();
                    readOrTakeAccess.setEntry(current.getEntry());
                    readOrTakeAccess.accept(new TemplateAccessVisitor(){

                        @Override
                        public void handle(ReadAccess readAccess) {
                        }

                        @Override
                        public void handle(TakeAccess takeAccess) {
                            EntryMetaInfo metaInfo = (EntryMetaInfo)SpaceStore.this.entryMetaInfos.remove(current.getEntryId());
                            current.receiveMetaInfo(metaInfo, new DeadBcTakenEntryInfo());
                            iWrites.remove();
                        }
                    });
                    return true;
                }

                @Override
                public Boolean handle(NotMatchBcExpiredMatchResult result) {
                    EntryMetaInfo metaInfo = (EntryMetaInfo)SpaceStore.this.entryMetaInfos.remove(current.getEntryId());
                    current.receiveMetaInfo(metaInfo, new DeadBcTimeoutEntryInfo());
                    return false;
                }

                @Override
                public Boolean handle(NoMatchMatchResult result) {
                    return false;
                }
            }).booleanValue()) continue;
            return;
        }
        this.readOrTakeAccesses.add(readOrTakeAccess);
    }

    public EntryMetaInfo getEntryMetaInfo(EntryId entryId) throws NoMetaInfoFoundException {
        EntryMetaInfo metaInfo = this.entryMetaInfos.get(entryId);
        if (metaInfo == null) {
            throw new NoMetaInfoFoundException(entryId);
        }
        return metaInfo;
    }
}

