/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.access;

import de.fhdw.hfp416.spaces.access.Access;
import de.fhdw.hfp416.spaces.access.AccessVisitor;
import de.fhdw.hfp416.spaces.access.TemplateAccessReturnVisitor;
import de.fhdw.hfp416.spaces.access.TemplateAccessVisitor;
import de.fhdw.hfp416.spaces.access.WriteAccess;
import de.fhdw.hfp416.spaces.access.match.MatchResult;
import de.fhdw.hfp416.spaces.access.match.NotMatchBcExpiredMatchResult;
import de.fhdw.hfp416.spaces.entry.Entry;
import de.fhdw.hfp416.spaces.template.Template;
import de.fhdw.hfp416.spaces.time.timepoint.Timepoint;
import de.fhdw.hfp416.spaces.util.future.Future;

public abstract class TemplateAccess
extends Access {
    private final Template template;
    private final Future<Entry> futureEntry;

    public TemplateAccess(Timepoint timepoint, Template template, Future<Entry> futureEntry) {
        super(timepoint);
        this.template = template;
        this.futureEntry = futureEntry;
    }

    public MatchResult match(WriteAccess writeAccess) {
        if (writeAccess.isExpired()) {
            return new NotMatchBcExpiredMatchResult();
        }
        return MatchResult.create(this.getTemplate().match(writeAccess.getEntry()));
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setEntry(Entry entry) {
        this.futureEntry.set(entry);
    }

    public void abort() {
        this.futureEntry.abort();
    }

    public abstract void accept(TemplateAccessVisitor var1);

    public abstract <R> R accept(TemplateAccessReturnVisitor<R> var1);

    @Override
    public void accept(AccessVisitor visitor) {
        visitor.handle(this);
    }
}

