/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.serialization;

import de.fhdw.hfp416.spaces.entry.CollectionEntry;
import de.fhdw.hfp416.spaces.entry.Entry;
import de.fhdw.hfp416.spaces.entry.MapEntry;
import de.fhdw.hfp416.spaces.entry.ObjectEntry;
import de.fhdw.hfp416.spaces.entry.ReferenceEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.PrimitiveEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.visitor.PrimitiveEntryReturnExceptionDefaultVisitor;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryReturnExceptionVisitor;
import de.fhdw.hfp416.spaces.exception.deserialization.ClassNotFoundException;
import de.fhdw.hfp416.spaces.exception.deserialization.DeserializationException;
import de.fhdw.hfp416.spaces.exception.deserialization.NoSuchFieldsException;
import de.fhdw.hfp416.spaces.serialization.SpaceSerializerReflectionHelper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

class SpaceDeserializationResolver
extends PrimitiveEntryReturnExceptionDefaultVisitor<Object, DeserializationException>
implements IEntryReturnExceptionVisitor<Object, DeserializationException> {
    private final Map<String, Class<?>> clazzesMappedByFullname = new HashMap();
    private final Map<String, LinkedList<FutureObjectInformation>> objectsMappedByName = new HashMap<String, LinkedList<FutureObjectInformation>>();

    SpaceDeserializationResolver() {
    }

    @Override
    protected Object defaultHandle(PrimitiveEntry<?> entry) throws DeserializationException {
        return entry.getValue();
    }

    @Override
    public Object handle(CollectionEntry entry) throws DeserializationException {
        String fullName = entry.getFullQualifiedName();
        Class<?> clazz = this.loadClass(fullName);
        Boolean isArray = clazz.isArray();
        Collection result = isArray != false ? new LinkedList() : (Collection)SpaceSerializerReflectionHelper.createObject(clazz);
        for (Entry item : entry.getCollection()) {
            result.add(this.handle(item));
        }
        if (isArray.booleanValue()) {
            return SpaceSerializerReflectionHelper.castArray(clazz, result.toArray());
        }
        return result;
    }

    @Override
    public Object handle(MapEntry entry) throws DeserializationException {
        String fullName = entry.getFullQualifiedName();
        Class<?> clazz = this.loadClass(fullName);
        Map result = (Map)SpaceSerializerReflectionHelper.createObject(clazz);
        for (Map.Entry<Entry, Entry> item : entry.getMap().entrySet()) {
            result.put(this.handle(item.getKey()), this.handle(item.getValue()));
        }
        return result;
    }

    @Override
    public Object handle(ReferenceEntry entry) throws DeserializationException {
        return this.handle(entry.getReference());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object handle(ObjectEntry entry) throws DeserializationException {
        void var5_8;
        LinkedList<Object> objectsForName;
        String fullName = entry.getFullQualifiedName();
        if (!this.objectsMappedByName.containsKey(fullName)) {
            objectsForName = new LinkedList();
            this.objectsMappedByName.put(fullName, objectsForName);
        } else {
            objectsForName = this.objectsMappedByName.get(fullName);
            for (FutureObjectInformation futureObjectInformation : objectsForName) {
                if (futureObjectInformation.entry != entry) continue;
                return futureObjectInformation.objectUnderConstruction;
            }
        }
        Class<?> clazz = this.loadClass(fullName);
        if (clazz.isEnum()) {
            String enumValue = (String)this.handle(entry.getAttributes().get("name"));
            Object obj = Enum.valueOf(clazz, enumValue);
        } else {
            Object obj = SpaceSerializerReflectionHelper.createObject(clazz);
        }
        objectsForName.add(new FutureObjectInformation(entry, var5_8));
        Collection<Field> allSerializableFieldsOfObject = SpaceSerializerReflectionHelper.getAllNecessaryFields(clazz);
        HashMap<String, Entry> unhandeldAttributesOfEntryMap = new HashMap<String, Entry>(entry.getAttributes());
        for (Field field : allSerializableFieldsOfObject) {
            String fieldName = field.getName();
            if (!unhandeldAttributesOfEntryMap.containsKey(fieldName)) continue;
            Object value = this.handle((Entry)unhandeldAttributesOfEntryMap.get(fieldName));
            SpaceSerializerReflectionHelper.setFieldValue(field, var5_8, value);
            unhandeldAttributesOfEntryMap.remove(fieldName);
        }
        Set unhandeldAttributes = unhandeldAttributesOfEntryMap.keySet();
        if (!unhandeldAttributes.isEmpty()) {
            throw new NoSuchFieldsException(String.format("Die folgenden Felder des Objects der Klasse (%s) wurden nicht gem\u00e4\u00df dem Entry gesetzt: (%s)", clazz.getName(), String.join((CharSequence)", ", unhandeldAttributes)), unhandeldAttributesOfEntryMap, var5_8);
        }
        return var5_8;
    }

    Object handle(Entry entry) throws DeserializationException {
        return entry.accept(this);
    }

    private Class<?> loadClass(String fullname) throws ClassNotFoundException {
        Class<?> clazz = this.clazzesMappedByFullname.get(fullname);
        if (clazz == null) {
            clazz = SpaceSerializerReflectionHelper.loadClass(fullname);
            this.clazzesMappedByFullname.put(fullname, clazz);
        }
        return clazz;
    }

    private static class FutureObjectInformation {
        private final ObjectEntry entry;
        private final Object objectUnderConstruction;

        private FutureObjectInformation(ObjectEntry entry, Object object) {
            this.entry = entry;
            this.objectUnderConstruction = object;
        }
    }
}

