package de.fhdw.wtf.context.exception;

/**
 * A class to represent an exception, which occurred because a domain constraint was invalidated. The domain programmer
 * can subclass this class to define his own exceptions.
 * 
 */
public abstract class UserException extends FrameworkException {
	
	/**
	 * The exception's serial ID.
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * Creates a new Exception with a a message describing the error.
	 * 
	 * @param message
	 *            The exception message.
	 */
	protected UserException(final String message) {
		super(message);
	}
	
	@Override
	public boolean isUserException() {
		return true;
	}
	
	/**
	 * The visitor accept method for this exception hierarchy. You must implement this method in your exception classes.
	 * 
	 * @param visitor
	 *            An interface for the exception visitor.
	 */
	public abstract void accept(UserExceptionVisitor visitor);
	
}
