package de.fhdw.wtf.context.core;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;

import de.fhdw.wtf.context.exception.ManipulationDuringRevisionException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.exception.RuntimePersistenceException;
import de.fhdw.wtf.persistence.facade.ObjectFacade;
import de.fhdw.wtf.persistence.facade.TypeManager;
import de.fhdw.wtf.persistence.meta.Link;
import de.fhdw.wtf.persistence.meta.MapLink;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.UnidirectionalLink;
import de.fhdw.wtf.persistence.meta.UserObject;
import de.fhdw.wtf.persistence.utils.Tuple;

/**
 * A class to represent the Context for a Revision Access. It only supports querying the Persistence Layer.
 * Manipulations of data is prohibited in this context.
 * 
 */
public class RevisionContext extends ContextWithDatabaseAccess {
	
	/**
	 * This exception will be thrown if somebody tries to manipulate the data.
	 */
	private final ManipulationDuringRevisionException exception;
	
	/**
	 * The timestamp to which thie Revision is made.
	 */
	private final Date date;
	
	/**
	 * Creates a new Revision Context.
	 * 
	 * @param objectFacade
	 *            A reference to the object facade to access the persistence layer.
	 * @param date
	 *            The timestamp of the revision.
	 */
	public RevisionContext(final ObjectFacade objectFacade, final Date date) {
		super(objectFacade);
		this.date = new Date(date.getTime());
		this.exception = new ManipulationDuringRevisionException();
	}
	
	@Override
	public Collection<UserObject> find(final String associationName, final String value) {
		try {
			return this.objectFacade.find(
					this.typeManager.getUnidirectionalAssociationForName(associationName),
					value,
					this.date);
		} catch (final PersistenceException e) {
			Logger.getInstance().log(e);
			throw new RuntimePersistenceException();
		}
	}
	
	@Override
	public Collection<UserObject> find(final String associationName, final BigInteger value) {
		try {
			return this.objectFacade.find(
					this.typeManager.getUnidirectionalAssociationForName(associationName),
					value,
					this.date);
		} catch (final PersistenceException e) {
			Logger.getInstance().log(e);
			throw new RuntimePersistenceException();
		}
	}
	
	@Override
	public Collection<Tuple<UnidirectionalLink, UserObject>> inverseGet(final String associationName,
			final UserObject object) {
		try {
			return this.objectFacade.inverseGet(
					object,
					this.typeManager.getUnidirectionalAssociationForName(associationName),
					this.date);
		} catch (final PersistenceException e) {
			Logger.getInstance().log(e);
			throw new RuntimePersistenceException();
		}
	}
	
	@Override
	public Collection<Tuple<UnidirectionalLink, Object>> get(final UserObject object, final String associationName) {
		try {
			return this.objectFacade.get(
					object,
					this.typeManager.getUnidirectionalAssociationForName(associationName),
					this.date);
		} catch (final PersistenceException e) {
			Logger.getInstance().log(e);
			throw new RuntimePersistenceException();
		}
	}
	
	@Override
	public Collection<Tuple<MapLink, Object>> get(final UserObject object,
			final String associationName,
			final String key) {
		// TODO: the database interface is wrong
		throw new RuntimePersistenceException();
		/*
		 * try { return objectFacade.get(object, typeManager.getMapAssociationForName(associationName), key, date); }
		 * catch (PersistenceException e) { Logger.getInstance().log(e); throw new RuntimePersistenceException(); }
		 */
	}
	
	@Override
	public Collection<Tuple<MapLink, Object>> get(final UserObject object,
			final String associationName,
			final BigInteger key) {
		// TODO: the database interface is wrong
		throw new RuntimePersistenceException();
		/*
		 * try { return objectFacade.get(object, typeManager.getMapAssociationForName(associationName), key, date); }
		 * catch (PersistenceException e) { Logger.getInstance().log(e); throw new RuntimePersistenceException(); }
		 */
	}
	
	@Override
	public Collection<Tuple<MapLink, Object>> get(final UserObject object,
			final String associationName,
			final UserObject key) {
		// TODO: the database interface is wrong
		throw new RuntimePersistenceException();
		/*
		 * try { return objectFacade.get(object, typeManager.getMapAssociationForName(associationName), key, date); }
		 * catch (PersistenceException e) { Logger.getInstance().log(e); throw new RuntimePersistenceException(); }
		 */
	}
	
	@Override
	public UserObject create(final String typeName) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public UnidirectionalLink set(final UserObject object, final String associationName, final String val) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public UnidirectionalLink set(final UserObject object, final String associationName, final BigInteger val) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public UnidirectionalLink set(final UserObject object, final String associationName, final UserObject target) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final UserObject target, final String key) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final BigInteger target, final String key) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final String target, final String key) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public MapLink put(final UserObject owner,
			final String associationName,
			final UserObject target,
			final BigInteger key) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public MapLink put(final UserObject owner,
			final String associationName,
			final BigInteger target,
			final BigInteger key) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final String target, final BigInteger key) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public MapLink put(final UserObject owner,
			final String associationName,
			final UserObject target,
			final UserObject key) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public MapLink put(final UserObject owner,
			final String associationName,
			final BigInteger target,
			final UserObject key) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final String target, final UserObject key) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public void commit() {
		// nothing to do
	}
	
	@Override
	public void rollback() {
		// nothing to do
	}
	
	@Override
	public void savePoint() {
		// nothing to do
	}
	
	@Override
	public void rollbackToSavePoint() {
		// nothing to do
	}
	
	@Override
	public void unset(final Link toUnset) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public TypeManager getTypeManager() {
		return this.objectFacade.getTypeManager();
	}
	
	@Override
	public Collection<UserObject> getObjectsByType(final String typeName) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
	@Override
	public UserObject checkout(final long object) {
		Logger.getInstance().logError(this.exception.getMessage());
		throw this.exception;
	}
	
}
