package de.fhdw.wtf.context.model.collections;

import de.fhdw.wtf.context.model.AnyType;
import de.fhdw.wtf.context.model.UserObjectFactory;

/**
 * Creates PersistentList objects.
 */
public class PersistentListFactory extends UserObjectFactory {
	
	/**
	 * The singleton instance of this factory class.
	 */
	private static PersistentListFactory instance = null;
	
	/**
	 * Returns the singleton instance of this factory class.
	 * 
	 * @return The singleton instance of this factory class.
	 */
	public static synchronized PersistentListFactory create() {
		if (instance == null) {
			instance = new PersistentListFactory();
		}
		return instance;
	}
	
	@Override
	protected AnyType createSpecificUserType() {
		return new PersistentList<>();
	}
}
