/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.model.collections;

import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.collections.Collection;
import de.fhdw.wtf.context.model.collections.ImmutableCollection;
import de.fhdw.wtf.context.model.collections.ImmutableList;
import de.fhdw.wtf.context.model.collections.PersistenceIteratorWithObject;
import de.fhdw.wtf.context.model.collections.functors.EquivalenceRelation;
import de.fhdw.wtf.context.model.collections.functors.Function;
import de.fhdw.wtf.context.model.collections.functors.Operator;
import de.fhdw.wtf.context.model.collections.functors.Predicate;
import de.fhdw.wtf.persistence.meta.UserObject;
import java.util.Iterator;
import java.util.Vector;

public class PersistentListWithUserObject<T extends Anything>
implements ImmutableCollection<T>,
Iterable<T> {
    private final java.util.Collection<UserObject> objects;

    public PersistentListWithUserObject(java.util.Collection<UserObject> objects) {
        this.objects = objects;
    }

    @Override
    public Collection<T> union(Collection<? extends T> otherCollection) {
        return this.toList().union(otherCollection);
    }

    @Override
    public boolean contains(T element) {
        return this.toList().contains(element);
    }

    @Override
    public ImmutableCollection<T> add(T element) {
        return this.toList().add(element);
    }

    @Override
    public T front() {
        return this.toList().front();
    }

    @Override
    public ImmutableCollection<T> tail() {
        return this.toList().tail();
    }

    @Override
    public ImmutableCollection<T> reverse() {
        return this.toList().reverse();
    }

    @Override
    public <U extends Anything> ImmutableCollection<U> map(Function<T, U> function) {
        return this.toList().map(function);
    }

    @Override
    public <U extends Anything> U reduce(Operator<T, U> aggregation) {
        return this.toList().reduce(aggregation);
    }

    @Override
    public <U extends Anything> ImmutableCollection<U> reduceEquivalent(EquivalenceRelation<T> equi, Operator<T, U> aggregation) {
        return this.toList().reduceEquivalent(equi, aggregation);
    }

    @Override
    public ImmutableCollection<T> filter(Predicate<T> predicate) {
        return this.toList().filter(predicate);
    }

    @Override
    public T find(Predicate<T> predicate) {
        return this.toList().find(predicate);
    }

    private ImmutableCollection<T> toList() {
        ImmutableCollection<Anything> result = new ImmutableList<Anything>();
        for (Anything current : this) {
            result = result.add(current);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new PersistenceIteratorWithObject(this.objects.iterator());
    }

    public String toString() {
        Vector<Anything> result = new Vector<Anything>();
        for (Anything current : this) {
            result.add(current);
        }
        return result.toString();
    }
}

