package de.fhdw.wtf.context.core;

import de.fhdw.wtf.context.exception.FrameworkException;
import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.Int;
import de.fhdw.wtf.persistence.meta.IntegerValue;
import de.fhdw.wtf.persistence.meta.Object;

/**
 * An implementation of an ObjectFactory which creates Int objects.
 */
public class IntegerFactory extends ObjectFactory {
	
	/**
	 * The singleton instance of this class.
	 */
	private static IntegerFactory instance = null;
	
	@Override
	public Anything createObject(final Object object) {
		if (object instanceof IntegerValue) {
			final Int result = new Int((IntegerValue) object);
			return result;
		} else {
			throw new FrameworkException("IntegerFactory.createObject() called on object of type "
					+ object.getClass().getName());
		}
	}
	
	/**
	 * Returns the singleton instance of this class.
	 * 
	 * @return The singleton instance of this class.
	 */
	public static synchronized IntegerFactory create() {
		if (instance == null) {
			instance = new IntegerFactory();
		}
		return instance;
	}
	
}
