/*
 * Decompiled with CFR 0.152.
 */
package test.integration;

import de.fhdw.wtf.context.core.ApplicationContainer;
import de.fhdw.wtf.context.core.ApplicationStarter;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.facade.ClassFacade;
import de.fhdw.wtf.persistence.facade.DatabaseManager;
import de.fhdw.wtf.persistence.facade.IDManager;
import de.fhdw.wtf.persistence.facade.ObjectFacade;
import de.fhdw.wtf.persistence.facade.OracleDataBasePreparator;
import de.fhdw.wtf.persistence.facade.OracleDatabaseManager;
import de.fhdw.wtf.persistence.facade.OracleObjectFacadeImplementation;
import de.fhdw.wtf.persistence.meta.IntegerType;
import de.fhdw.wtf.persistence.meta.MapAssociation;
import de.fhdw.wtf.persistence.meta.StringType;
import de.fhdw.wtf.persistence.meta.Type;
import de.fhdw.wtf.persistence.meta.UnidirectionalAssociation;
import de.fhdw.wtf.persistence.meta.UserType;
import de.fhdw.wtf.persistence.utils.PropertiesReaderFactory;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Statement;
import org.junit.After;
import org.junit.Before;
import test.integration.TestBase;

public class TestBaseWithDB
extends TestBase {
    private ClassFacade classFacade;
    private ObjectFacade objectFacade;
    private UserType personService;
    private UserType hausService;
    private UserType anyType;
    private UserType mutableList;
    private UserType mutableMap;
    private UserType persistentList;
    private UserType persistentMap;
    private UserType account;
    private UserType accountNumber;
    private UserType bankidentifier;
    private UserType city;
    private UserType country;
    private UserType globalTelefonbuch;
    private UserType ibanFinder;
    private UserType kommunikationskanal;
    private UserType natuerlichePerson;
    private UserType personGroups;
    private UserType postfach;
    private UserType telefon;
    private UserType telefonbuch;
    private UserType telefonbuchMitPersonAlsKey;
    private UserType telefonbuecher;
    private UserType haus;
    private UnidirectionalAssociation mutableSetLinks;
    private MapAssociation mutableMapLinks;
    private UnidirectionalAssociation accountNumberId;
    private UnidirectionalAssociation bankidentifierId;
    private UnidirectionalAssociation cityName;
    private UnidirectionalAssociation countryName;
    private UnidirectionalAssociation globalTelefonbuchTelefonbuchMapsPerCity;
    private UnidirectionalAssociation ibanFinderAccountTree;
    private UnidirectionalAssociation natuerlichePersonName;
    private UnidirectionalAssociation natuerlichePersonKanal;
    private UnidirectionalAssociation personGroupsPersonGroups;
    private UnidirectionalAssociation postfachStadt;
    private UnidirectionalAssociation postfachNr;
    private UnidirectionalAssociation telefonNr;
    private UnidirectionalAssociation telefonbuchEintraege;
    private UnidirectionalAssociation telefonbuchMitPersonAlsKeyEintraege;
    private UnidirectionalAssociation telefonbuecherEintraege;
    private UnidirectionalAssociation wohnhaft;
    private UnidirectionalAssociation hausNummer;

    public ClassFacade getClassFacade() {
        return this.classFacade;
    }

    public ObjectFacade getObjectFacade() {
        return this.objectFacade;
    }

    protected void initializeTypesAndSpecializationAndAssociations() throws PersistenceException {
        this.personService = this.classFacade.createUserType("generated.model.de>fhdw>partner>service>PersonService", false, true);
        this.hausService = this.classFacade.createUserType("generated.model.de>fhdw>partner>service>HausService", false, true);
        this.anyType = this.classFacade.createUserType("AnyType", true, false);
        this.account = this.classFacade.createUserType("generated.model.de>fhdw>partner>Account", false, false);
        this.accountNumber = this.classFacade.createUserType("generated.model.de>fhdw>partner>AccountNumber", false, false);
        this.bankidentifier = this.classFacade.createUserType("generated.model.de>fhdw>partner>Bankidentifier", false, false);
        this.city = this.classFacade.createUserType("generated.model.de>fhdw>partner>City", false, false);
        this.country = this.classFacade.createUserType("generated.model.de>fhdw>partner>Country", false, false);
        this.globalTelefonbuch = this.classFacade.createUserType("generated.model.de>fhdw>partner>GlobalTelefonbuch", false, false);
        this.ibanFinder = this.classFacade.createUserType("generated.model.de>fhdw>partner>IBAN_Finder", false, false);
        this.kommunikationskanal = this.classFacade.createUserType("generated.model.de.fhdw.partner.Kommunikationskanal", true, false);
        this.natuerlichePerson = this.classFacade.createUserType("generated.model.de>fhdw>partner>NatuerlichePerson", false, false);
        this.personGroups = this.classFacade.createUserType("generated.model.de>fhdw>partner>PersonGroups", false, false);
        this.postfach = this.classFacade.createUserType("generated.model.de>fhdw>partner>Postfach", false, false);
        this.telefon = this.classFacade.createUserType("generated.model.de>fhdw>partner>Telefon", false, false);
        this.telefonbuch = this.classFacade.createUserType("generated.model.de>fhdw>partner>Telefonbuch", false, false);
        this.telefonbuchMitPersonAlsKey = this.classFacade.createUserType("generated.model.de>fhdw>partner>TelefonbuchMitPersonAlsKey", false, false);
        this.telefonbuecher = this.classFacade.createUserType("generated.model.de>fhdw>partner>Telefonbuecher", false, false);
        this.haus = this.classFacade.createUserType("generated.model.de>fhdw>partner>Haus", false, false);
        this.mutableList = this.classFacade.createUserType("de.fhdw.wtf.context.model.collections.MutableList", true, false);
        this.persistentList = this.classFacade.createUserType("de.fhdw.wtf.context.model.collections.PersistentList", false, false);
        this.mutableMap = this.classFacade.createUserType("de.fhdw.wtf.context.model.collections.MutableMap", true, false);
        this.persistentMap = this.classFacade.createUserType("de.fhdw.wtf.context.model.collections.PersistentMap", false, false);
        this.classFacade.createSpecializationBetween(this.kommunikationskanal, (Type)this.postfach);
        this.classFacade.createSpecializationBetween(this.kommunikationskanal, (Type)this.telefon);
        this.classFacade.createSpecializationBetween(this.mutableList, (Type)this.persistentList);
        this.classFacade.createSpecializationBetween(this.mutableMap, (Type)this.persistentMap);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.mutableList);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.mutableMap);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.account);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.accountNumber);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.bankidentifier);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.city);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.country);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.globalTelefonbuch);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.ibanFinder);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.kommunikationskanal);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.natuerlichePerson);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.personGroups);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.telefonbuch);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.telefonbuchMitPersonAlsKey);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.telefonbuecher);
        this.classFacade.createSpecializationBetween(this.anyType, (Type)this.haus);
        this.mutableSetLinks = this.classFacade.createUnidirectionalAssociation("links", false, false, this.persistentList, (Type)this.anyType);
        this.mutableMapLinks = this.classFacade.createMapAssociation("links", false, this.persistentMap, (Type)this.anyType, (Type)this.anyType);
        this.accountNumberId = this.classFacade.createUnidirectionalAssociation("id", true, true, this.accountNumber, (Type)IntegerType.getInstance());
        this.bankidentifierId = this.classFacade.createUnidirectionalAssociation("id", true, true, this.bankidentifier, (Type)IntegerType.getInstance());
        this.cityName = this.classFacade.createUnidirectionalAssociation("name", true, true, this.city, (Type)StringType.getInstance());
        this.countryName = this.classFacade.createUnidirectionalAssociation("name", true, true, this.country, (Type)StringType.getInstance());
        this.globalTelefonbuchTelefonbuchMapsPerCity = this.classFacade.createUnidirectionalAssociation("telefonbuchMapsPerCity", false, true, this.globalTelefonbuch, (Type)this.mutableMap);
        this.ibanFinderAccountTree = this.classFacade.createUnidirectionalAssociation("accountTree", false, true, this.ibanFinder, (Type)this.mutableMap);
        this.natuerlichePersonKanal = this.classFacade.createUnidirectionalAssociation("kanal", false, true, this.natuerlichePerson, (Type)this.mutableList);
        this.natuerlichePersonName = this.classFacade.createUnidirectionalAssociation("name", true, true, this.natuerlichePerson, (Type)StringType.getInstance());
        this.personGroupsPersonGroups = this.classFacade.createUnidirectionalAssociation("personGroups", false, true, this.personGroups, (Type)this.mutableList);
        this.postfachStadt = this.classFacade.createUnidirectionalAssociation("stadt", true, true, this.postfach, (Type)StringType.getInstance());
        this.postfachNr = this.classFacade.createUnidirectionalAssociation("nr", true, true, this.postfach, (Type)IntegerType.getInstance());
        this.telefonNr = this.classFacade.createUnidirectionalAssociation("nr", true, true, this.telefon, (Type)IntegerType.getInstance());
        this.telefonbuchEintraege = this.classFacade.createUnidirectionalAssociation("eintraege", false, true, this.telefonbuch, (Type)this.mutableMap);
        this.telefonbuchMitPersonAlsKeyEintraege = this.classFacade.createUnidirectionalAssociation("eintraege", false, true, this.telefonbuchMitPersonAlsKey, (Type)this.mutableMap);
        this.telefonbuecherEintraege = this.classFacade.createUnidirectionalAssociation("eintraege", false, true, this.telefonbuecher, (Type)this.mutableList);
        this.wohnhaft = this.classFacade.createUnidirectionalAssociation("wohnhaft", false, true, this.natuerlichePerson, (Type)this.haus);
        this.hausNummer = this.classFacade.createUnidirectionalAssociation("hausNummer", false, true, this.haus, (Type)StringType.getInstance());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        OracleDatabaseManager manager = OracleDatabaseManager.getInstance();
        manager.setConnectionConstantsFromFile(PropertiesReaderFactory.getInstance().getPropertiesReaderOracle());
        manager.connect();
        this.resetDatabase((DatabaseManager)manager);
        this.resetIDManager();
        this.classFacade = manager.getClassFacade();
        this.classFacade.initialize();
        this.initializeTypesAndSpecializationAndAssociations();
        this.classFacade.finalizeSpecialization();
        manager.disconnect();
        ApplicationStarter starter = this.getApplicationStarter();
        starter.startStandalone();
        this.objectFacade = ApplicationContainer.getInstance().getDatabaseManager().getObjectFacade();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        Connection connection = OracleDatabaseManager.getInstance().getConnection();
        Statement statement = connection.createStatement();
        statement.addBatch("delete from Accessed");
        statement.addBatch("delete from String_Value");
        statement.addBatch("delete from Integer_value");
        statement.addBatch("delete from maplink");
        statement.addBatch("delete from link");
        statement.addBatch("delete from user_object");
        statement.addBatch("delete from object");
        statement.addBatch("delete from short_transaction");
        statement.addBatch("delete from long_transaction");
        statement.executeBatch();
        statement.close();
        this.classFacade.clear();
        OracleDatabaseManager.getInstance().disconnect();
    }

    private void resetDatabase(DatabaseManager database) throws PersistenceException, IOException {
        OracleDataBasePreparator prep = new OracleDataBasePreparator();
        boolean tableStructureValid = prep.isTableStructureValid();
        if (tableStructureValid) {
            this.clearTables(database);
        } else {
            prep.dropWholeSchema();
            prep.createWholeSchema();
        }
        boolean areProceduresCreated = prep.areProceduresCreated();
        if (!areProceduresCreated) {
            prep.createProcedures();
        }
    }

    private void resetIDManager() {
        File filePersistAsoc = new File("associations.properties");
        File filePersistType = new File("types.properties");
        if (filePersistAsoc.exists()) {
            filePersistAsoc.delete();
        }
        if (filePersistType.exists()) {
            filePersistType.delete();
        }
        IDManager.instance().clearInformation();
    }

    private void clearTables(DatabaseManager database) throws PersistenceException {
        new OracleObjectFacadeImplementation((OracleDatabaseManager)database, null).clear();
        database.getClassFacade().clear();
    }
}

