package de.fhdw.wtf.context.model.collections;

import de.fhdw.wtf.context.model.Anything;

/**
 * An interface to represent the abstraction over all WTF-specific Collection classes and interfaces.
 * 
 * @param <T>
 *            All collections can contain any Type T which is a subtype to Anything.
 */
public interface Collection<T extends Anything> {
	
	/**
	 * Performs a union of this Collection with another Collection. The decision whether a new collection is created or
	 * union is performed in place is made by the implementing subclass.
	 * 
	 * @param otherCollection
	 *            An other Collection.
	 * @return Provides either a new collection which is the union of this and the other collection or provides this
	 *         Collection with the elements of the other Collection added.
	 */
	Collection<T> union(Collection<? extends T> otherCollection);
	
	/**
	 * A Method to check if an Element is part of this collection.
	 * 
	 * @param element
	 *            An element of type T which is a subtype of Anything.
	 * @return Provides true if the given element is part of this collection.
	 */
	boolean contains(T element);
	
	/**
	 * This method checks if the collection is empty.
	 * 
	 * @return Provides true if this collection is empty.
	 */
	boolean isEmpty();
}
