package de.fhdw.wtf.context.model.collections;

import de.fhdw.wtf.context.model.AnyType;
import de.fhdw.wtf.context.model.UserObjectFactory;

/**
 * Creates PersistentMap objects.
 */
public class PersistentMapFactory extends UserObjectFactory {
	
	/**
	 * The singleton instance of this factory class.
	 */
	private static PersistentMapFactory instance = null;
	
	/**
	 * Returns the singleton instance of this factory class.
	 * 
	 * @return The singleton instance of this factory class.
	 */
	public static synchronized PersistentMapFactory create() {
		if (instance == null) {
			instance = new PersistentMapFactory();
		}
		return instance;
	}
	
	@Override
	protected AnyType createSpecificUserType() {
		return new PersistentMap<>();
	}
}
