package de.fhdw.wtf.context.model;

import java.util.Collection;
import java.util.Vector;

import de.fhdw.wtf.context.core.ObjectFactoryProvider;
import de.fhdw.wtf.context.core.TransactionManager;
import de.fhdw.wtf.persistence.meta.UnidirectionalLink;
import de.fhdw.wtf.persistence.meta.UserObject;
import de.fhdw.wtf.persistence.utils.Tuple;

public abstract class SymmetricRelationAccess {
	
	protected <T extends AnyType> T inverseGet(final AnyType anyType, final String association) {
		final Collection<T> result = this.inverseGetCollection(anyType, association);
		if (result.isEmpty()) {
			return null;
		} else {
			return result.iterator().next();
		}
	}
	
	protected <T extends AnyType> Collection<T> inverseGetCollection(final AnyType anyType, final String association) {
		final Vector<T> resultVector = new Vector<>();
		final Collection<Tuple<UnidirectionalLink, UserObject>> databaseResults =
				TransactionManager.getContext().inverseGet(association, anyType.getObject());
		for (final Tuple<UnidirectionalLink, UserObject> databaseResult : databaseResults) {
			final UserObject object = databaseResult.getSecond();
			@SuppressWarnings("unchecked")
			final T result = (T) ObjectFactoryProvider.instance().createObject(object);
			resultVector.add(result);
		}
		return resultVector;
	}
}
