/*
 * Decompiled with CFR 0.152.
 */
package test.integration;

import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.Int;
import de.fhdw.wtf.context.model.Str;
import de.fhdw.wtf.context.model.collections.ImmutableCollection;
import de.fhdw.wtf.context.model.collections.MutableList;
import de.fhdw.wtf.context.model.collections.MutableMap;
import de.fhdw.wtf.context.model.collections.functors.Operator;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import generated.model.de.fhdw.partner.Account;
import generated.model.de.fhdw.partner.AccountNumber;
import generated.model.de.fhdw.partner.Bankidentifier;
import generated.model.de.fhdw.partner.City;
import generated.model.de.fhdw.partner.Country;
import generated.model.de.fhdw.partner.GlobalTelefonbuch;
import generated.model.de.fhdw.partner.IBAN_Finder;
import generated.model.de.fhdw.partner.NatuerlichePerson;
import generated.model.de.fhdw.partner.PersonGroups;
import generated.model.de.fhdw.partner.Telefon;
import generated.model.de.fhdw.partner.Telefonbuch;
import generated.model.de.fhdw.partner.TelefonbuchMitPersonAlsKey;
import generated.model.de.fhdw.partner.Telefonbuecher;
import generated.model.de.fhdw.partner.service.PersonService;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import test.integration.IntegrationTestSuperClass;

public abstract class TestPersonModel
extends IntegrationTestSuperClass {
    final Str jonass = new Str("Jonas Tangermann");
    final Str patricks = new Str("Patrick S\u00f6ren St\u00fcnkel");
    final Str alexs = new Str("Alexander Sebastian Clau\u00df");
    final Str chriss = new Str("Christian Probst");
    final Int i12345 = new Int(12345L);
    final Int i23456 = new Int(23456L);
    final Int i34567 = new Int(34567L);
    final Int i45678 = new Int(45678L);

    protected abstract PersonService getPersonService() throws PersistenceException;

    @Ignore
    public void findPersonTest() throws PersistenceException {
        PersonService service = this.getPersonService();
        service.publish();
        ImmutableCollection<NatuerlichePerson> persons = service.findePersonen(new Str("Probst"));
        Assert.assertEquals((Object)this.chriss, (Object)((NatuerlichePerson)persons.front()).getName());
    }

    @Ignore
    public void deleteKanalTest() throws PersistenceException {
        PersonService service = this.getPersonService();
        service.publish();
        ImmutableCollection<NatuerlichePerson> persons = service.findePersonen(new Str("Tangermann"));
        Iterator kanalI = ((NatuerlichePerson)persons.front()).getKanal().iterator();
        while (kanalI.hasNext()) {
            Telefon t = (Telefon)((Object)kanalI.next());
            Assert.assertEquals((Object)this.i12345, (Object)t.getNr());
            kanalI.remove();
        }
        ImmutableCollection<NatuerlichePerson> personsAfterdel = service.findePersonen(new Str("Tangermann"));
        Iterator kanalIA = ((NatuerlichePerson)personsAfterdel.front()).getKanal().iterator();
        while (kanalIA.hasNext()) {
            Assert.fail();
        }
    }

    @Ignore
    public void traversalTest() throws PersistenceException {
        PersonService service = this.getPersonService();
        service.publish();
        ImmutableCollection<NatuerlichePerson> persons = service.findePersonen(new Str("Clau\u00df"));
        for (Telefon t : ((NatuerlichePerson)persons.front()).getKanal()) {
            Assert.assertEquals((Object)this.i12345, (Object)t.getNr());
        }
    }

    @Ignore
    public void valueChange() throws PersistenceException {
        PersonService service = this.getPersonService();
        service.publish();
        ImmutableCollection<NatuerlichePerson> persons = service.findePersonen(new Str("St\u00fcnkel"));
        NatuerlichePerson current = (NatuerlichePerson)persons.front();
        Assert.assertEquals((Object)this.patricks, (Object)current.getName());
        current.setName(current.getName().concat(new Str("us")));
        ImmutableCollection<NatuerlichePerson> personsAfterValueChange = service.findePersonen(new Str("St\u00fcnkel%"));
        Assert.assertEquals((Object)new Str("Patrick S\u00f6ren St\u00fcnkelus"), (Object)((NatuerlichePerson)personsAfterValueChange.front()).getName());
    }

    @Ignore
    public void testAggregation() throws Exception {
        PersonService service = this.getPersonService();
        service.publish();
        ImmutableCollection<NatuerlichePerson> persons = service.findePersonen(new Str("St\u00fcnkel"));
        Assert.assertEquals((Object)new Int(1L), (Object)persons.reduce((Operator)new Operator<NatuerlichePerson, Int>(){

            public Int n() {
                return new Int(0L);
            }

            public Int add(Int first, NatuerlichePerson second) {
                return first.add(new Int(1L));
            }
        }));
    }

    @Test
    public void testMapGetValue() throws Exception {
        PersonService service = this.getPersonService();
        service.publish();
        NatuerlichePerson alex = service.createPerson(this.alexs);
        Telefon talex = service.createTelefon(this.i12345);
        Telefonbuch telefonbuch = service.createTelefonbuch();
        service.addTelefonbuchEintrag(telefonbuch, talex, alex);
        NatuerlichePerson inhaber = service.findeInhaberEinesTelefons(telefonbuch, talex);
        Assert.assertEquals((Object)((Object)alex), (Object)((Object)inhaber));
    }

    @Test
    public void testMapRemove() throws Exception {
        PersonService service = this.getPersonService();
        service.publish();
        NatuerlichePerson alex = service.createPerson(this.alexs);
        Telefon talex = service.createTelefon(this.i12345);
        Telefonbuch telefonbuch = service.createTelefonbuch();
        service.addTelefonbuchEintrag(telefonbuch, talex, alex);
        NatuerlichePerson inhaber = service.entferneInhaberEinesTelefons(telefonbuch, talex);
        Assert.assertEquals((Object)((Object)alex), (Object)((Object)inhaber));
        NatuerlichePerson geloeschterInhaber = service.findeInhaberEinesTelefons(telefonbuch, talex);
        Assert.assertNull((Object)((Object)geloeschterInhaber));
    }

    @Test
    public void testMapMapMap() throws Exception {
        PersonService service = this.getPersonService();
        service.publish();
        IBAN_Finder finder = service.createIban_Finder();
        Country country = service.createCountry(new Str("DE"));
        Bankidentifier blz = service.createBankidentifier(new Int(500100L));
        AccountNumber number = service.createAccountNumber(new Int(12321312L));
        Account account = service.createAccount();
        service.addAccount(finder, country, blz, number, account);
        Account foundaccount = service.findAccount(finder, country, blz, number);
        Assert.assertEquals((Object)((Object)account), (Object)((Object)foundaccount));
    }

    @Test
    public void testSetSet() throws Exception {
        PersonService service = this.getPersonService();
        service.publish();
        PersonGroups groups = service.createPersonGroups();
        NatuerlichePerson p1 = service.createPerson(this.alexs);
        NatuerlichePerson p2 = service.createPerson(this.chriss);
        NatuerlichePerson p3 = service.createPerson(this.jonass);
        NatuerlichePerson p4 = service.createPerson(this.patricks);
        MutableList set1 = new MutableList();
        set1.insert((Anything)p1);
        set1.insert((Anything)p2);
        MutableList set2 = new MutableList();
        set2.insert((Anything)p3);
        set2.insert((Anything)p4);
        service.addPersonGroup(groups, (MutableList<NatuerlichePerson>)set1);
        service.addPersonGroup(groups, (MutableList<NatuerlichePerson>)set2);
        HashSet expected = new HashSet();
        HashSet<NatuerlichePerson> g1 = new HashSet<NatuerlichePerson>();
        g1.add(p1);
        g1.add(p2);
        HashSet<NatuerlichePerson> g2 = new HashSet<NatuerlichePerson>();
        g2.add(p3);
        g2.add(p4);
        expected.add(g1);
        expected.add(g2);
        HashSet actual = new HashSet();
        for (MutableList personSet : groups.getPersonGroups()) {
            Iterator personIterator = personSet.iterator();
            HashSet<NatuerlichePerson> innerSet = new HashSet<NatuerlichePerson>();
            while (personIterator.hasNext()) {
                NatuerlichePerson person = (NatuerlichePerson)((Object)personIterator.next());
                innerSet.add(person);
            }
            actual.add(innerSet);
        }
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testSetMapSet() throws Exception {
        PersonService service = this.getPersonService();
        service.publish();
        TelefonbuchMitPersonAlsKey telefonbuch1 = service.createTelefonbuchMitPersonAlsKey();
        TelefonbuchMitPersonAlsKey telefonbuch2 = service.createTelefonbuchMitPersonAlsKey();
        Telefonbuecher telefonbuecher = service.createTelefonbuecher();
        NatuerlichePerson p1 = service.createPerson(this.alexs);
        Telefon telefonAlex1 = service.createTelefon(this.i12345);
        Telefon telefonAlex2 = service.createTelefon(this.i23456);
        MutableList telefonAlex = new MutableList();
        telefonAlex.insert((Anything)telefonAlex1);
        telefonAlex.insert((Anything)telefonAlex2);
        NatuerlichePerson p2 = service.createPerson(this.chriss);
        Telefon telefonChris1 = service.createTelefon(this.i34567);
        Telefon telefonChris2 = service.createTelefon(this.i45678);
        MutableList telefonChris = new MutableList();
        telefonChris.insert((Anything)telefonChris1);
        telefonChris.insert((Anything)telefonChris2);
        service.addTelefonnummernZuPerson(telefonbuch1, p1, (MutableList<Telefon>)telefonAlex);
        service.addTelefonnummernZuPerson(telefonbuch2, p2, (MutableList<Telefon>)telefonChris);
        telefonbuecher.addTelefonbuch(telefonbuch1.getEintraege());
        telefonbuecher.addTelefonbuch(telefonbuch2.getEintraege());
        HashSet expected = new HashSet();
        HashSet<Telefon> telefonAlexHashSet = new HashSet<Telefon>();
        telefonAlexHashSet.add(telefonAlex1);
        telefonAlexHashSet.add(telefonAlex2);
        HashSet<Telefon> telefonChrisHashSet = new HashSet<Telefon>();
        telefonChrisHashSet.add(telefonChris1);
        telefonChrisHashSet.add(telefonChris2);
        ConcurrentHashMap<NatuerlichePerson, HashSet<Telefon>> telefonbuchMitAlex = new ConcurrentHashMap<NatuerlichePerson, HashSet<Telefon>>();
        telefonbuchMitAlex.put(p1, telefonAlexHashSet);
        ConcurrentHashMap<NatuerlichePerson, HashSet<Telefon>> telefonbuchMitChris = new ConcurrentHashMap<NatuerlichePerson, HashSet<Telefon>>();
        telefonbuchMitChris.put(p2, telefonChrisHashSet);
        expected.add(telefonbuchMitAlex);
        expected.add(telefonbuchMitChris);
        HashSet actual = new HashSet();
        Iterator iterator = telefonbuecher.getTelefonbuecher().iterator();
        while (iterator.hasNext()) {
            ConcurrentHashMap telefonbuchToFill = new ConcurrentHashMap();
            MutableMap telefonbuch = (MutableMap)iterator.next();
            NatuerlichePerson person = p1;
            MutableList innerSet = (MutableList)telefonbuch.get((Anything)p1);
            if (innerSet == null) {
                innerSet = (MutableList)telefonbuch.get((Anything)p2);
                person = p2;
            }
            Iterator innerIterator = innerSet.iterator();
            HashSet<Telefon> setToFill = new HashSet<Telefon>();
            while (innerIterator.hasNext()) {
                setToFill.add((Telefon)((Object)innerIterator.next()));
            }
            telefonbuchToFill.put(person, setToFill);
            actual.add(telefonbuchToFill);
        }
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testMapSetMap() throws Exception {
        PersonService service = this.getPersonService();
        service.publish();
        Telefonbuch telefonbuch1 = service.createTelefonbuch();
        Telefonbuch telefonbuch2 = service.createTelefonbuch();
        GlobalTelefonbuch globalTelefonbuch = service.createGlobalTelefonbuch();
        City hannover = service.createCity(new Str("Hannover"));
        NatuerlichePerson alex = service.createPerson(this.alexs);
        Telefon telefonAlex1 = service.createTelefon(this.i12345);
        service.addTelefonbuchEintrag(telefonbuch1, telefonAlex1, alex);
        City dortmund = service.createCity(new Str("Dortmund"));
        NatuerlichePerson chris = service.createPerson(this.chriss);
        Telefon telefonChris1 = service.createTelefon(this.i34567);
        service.addTelefonbuchEintrag(telefonbuch2, telefonChris1, chris);
        globalTelefonbuch.addTelefonbuchToCity(hannover, telefonbuch1);
        globalTelefonbuch.addTelefonbuchToCity(dortmund, telefonbuch2);
        ConcurrentHashMap expected = new ConcurrentHashMap();
        ConcurrentHashMap<Telefon, NatuerlichePerson> telefonbuch1ex = new ConcurrentHashMap<Telefon, NatuerlichePerson>();
        telefonbuch1ex.put(telefonAlex1, alex);
        HashSet<ConcurrentHashMap<Telefon, NatuerlichePerson>> firstSet = new HashSet<ConcurrentHashMap<Telefon, NatuerlichePerson>>();
        firstSet.add(telefonbuch1ex);
        ConcurrentHashMap<Telefon, NatuerlichePerson> telefonbuch2ex = new ConcurrentHashMap<Telefon, NatuerlichePerson>();
        telefonbuch2ex.put(telefonChris1, chris);
        HashSet<ConcurrentHashMap<Telefon, NatuerlichePerson>> secondSet = new HashSet<ConcurrentHashMap<Telefon, NatuerlichePerson>>();
        secondSet.add(telefonbuch2ex);
        expected.put(hannover, firstSet);
        expected.put(dortmund, secondSet);
        ConcurrentHashMap actual = new ConcurrentHashMap();
        HashSet actualHannoverSet = new HashSet();
        MutableList hannoverSet = (MutableList)globalTelefonbuch.getTelefonbuchMapsPerCity().get((Anything)hannover);
        for (MutableMap telefonbuchHannover : hannoverSet) {
            NatuerlichePerson personHannover = (NatuerlichePerson)telefonbuchHannover.get((Anything)telefonAlex1);
            ConcurrentHashMap<Telefon, NatuerlichePerson> actualHannoverMap = new ConcurrentHashMap<Telefon, NatuerlichePerson>();
            actualHannoverMap.put(telefonAlex1, personHannover);
            actualHannoverSet.add(actualHannoverMap);
        }
        actual.put(hannover, actualHannoverSet);
        HashSet actualDortmundSet = new HashSet();
        MutableList dortmundSet = (MutableList)globalTelefonbuch.getTelefonbuchMapsPerCity().get((Anything)dortmund);
        for (MutableMap telefonbuchdortmund : dortmundSet) {
            NatuerlichePerson personDortmund = (NatuerlichePerson)telefonbuchdortmund.get((Anything)telefonChris1);
            ConcurrentHashMap<Telefon, NatuerlichePerson> actualDortmundMap = new ConcurrentHashMap<Telefon, NatuerlichePerson>();
            actualDortmundMap.put(telefonChris1, personDortmund);
            actualDortmundSet.add(actualDortmundMap);
        }
        actual.put(dortmund, actualDortmundSet);
        Assert.assertEquals(expected, actual);
    }
}

