package de.fhdw.wtf.context.exception;

/**
 * This class represents a Framework Exception which occurs, when the application could not be started because of a
 * serious incident.
 * 
 */
public class NotStartableException extends FrameworkException {
	
	/**
	 * Exception message.
	 */
	private static final String MESSAGE = "Could not initialize Application because of :";
	/**
	 * Exception cause.
	 */
	private final Exception cause;
	
	/**
	 * Creates a NotStartableException.
	 * 
	 * @param cause
	 *            The original exception.
	 */
	public NotStartableException(final Exception cause) {
		super(MESSAGE + cause.getMessage());
		this.cause = cause;
	}
	
	@Override
	public void printStackTrace() {
		this.cause.printStackTrace();
	}
	
	/**
	 * The exception's serial ID.
	 */
	private static final long serialVersionUID = 1L;
	
}
