/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.model;

import de.fhdw.wtf.context.core.ApplicationContainer;
import de.fhdw.wtf.context.core.Logger;
import de.fhdw.wtf.context.core.Observer;
import de.fhdw.wtf.context.core.ObserverEvent;
import de.fhdw.wtf.context.core.PersistenceContext;
import de.fhdw.wtf.context.core.TransactionManager;
import de.fhdw.wtf.context.core.UserAccess;
import de.fhdw.wtf.persistence.exception.ClassFacadeUninitializedException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.exception.RuntimePersistenceException;
import de.fhdw.wtf.persistence.meta.Transaction;
import de.fhdw.wtf.persistence.meta.UserObject;
import de.fhdw.wtf.persistence.meta.UserTransaction;
import java.util.Collection;
import java.util.Vector;

public abstract class Service
extends UserAccess {
    private final Collection<Observer> observers = new Vector<Observer>();
    private UserTransaction transaction;

    UserObject getObject() {
        return this.transaction;
    }

    void setTransaction(UserTransaction transaction) {
        this.transaction = transaction;
    }

    public void commit() {
        TransactionManager.commit();
    }

    public void rollback() {
        TransactionManager.rollback();
    }

    @Override
    public void publish() {
        try {
            TransactionManager.setContext(new PersistenceContext(ApplicationContainer.getInstance().getDatabaseManager().getObjectFacade(), (Transaction)this.transaction));
        }
        catch (ClassFacadeUninitializedException e) {
            Logger.getInstance().log((PersistenceException)e);
            throw new RuntimePersistenceException((Throwable)e);
        }
    }

    public String getId() {
        return String.valueOf(this.getObject().getId());
    }

    public void registerObserver(Observer o) {
        this.observers.add(o);
    }

    public void deregisterObserver(Observer o) {
        this.observers.remove(o);
    }

    public void notifyObservers(ObserverEvent event) {
        for (Observer current : this.observers) {
            current.update(event);
        }
    }
}

