/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.model.collections;

import de.fhdw.wtf.context.core.TransactionManager;
import de.fhdw.wtf.context.exception.FrameworkException;
import de.fhdw.wtf.context.model.AnyType;
import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.Int;
import de.fhdw.wtf.context.model.Str;
import de.fhdw.wtf.context.model.collections.Collection;
import de.fhdw.wtf.context.model.collections.ImmutableCollection;
import de.fhdw.wtf.context.model.collections.ImmutableList;
import de.fhdw.wtf.context.model.collections.MutableCollection;
import de.fhdw.wtf.context.model.collections.PersistenceIteratorWithLink;
import de.fhdw.wtf.context.model.collections.functors.Predicate;
import de.fhdw.wtf.context.model.collections.functors.Procedure;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.UnidirectionalLink;
import de.fhdw.wtf.persistence.meta.UserObject;
import de.fhdw.wtf.persistence.utils.Tuple;
import java.util.Iterator;
import java.util.Vector;

public class PersistentListWithLinks<T extends Anything>
implements MutableCollection<T> {
    private final java.util.Collection<Tuple<UnidirectionalLink, Object>> unidirectionalLinks;
    private final String associationName;
    private final UserObject owner;

    public PersistentListWithLinks(java.util.Collection<Tuple<UnidirectionalLink, Object>> unidirectionalLinks, String associationName, UserObject owner) {
        this.unidirectionalLinks = unidirectionalLinks;
        this.associationName = associationName;
        this.owner = owner;
    }

    @Override
    public Collection<T> union(Collection<? extends T> otherCollection) {
        if (otherCollection instanceof ImmutableCollection) {
            this.addImmutableCollection((ImmutableCollection)otherCollection);
        } else if (otherCollection instanceof MutableCollection) {
            this.addMutableCollection((MutableCollection)otherCollection);
        } else {
            throw new FrameworkException("Collection is not supported");
        }
        return this;
    }

    private void addMutableCollection(MutableCollection<? extends T> otherCollection) {
        for (Anything current : otherCollection) {
            this.insert(current);
        }
    }

    private void addImmutableCollection(ImmutableCollection<? extends T> otherCollection) {
        if (!otherCollection.isEmpty()) {
            this.insert(otherCollection.front());
            this.addImmutableCollection(otherCollection.tail());
        }
    }

    @Override
    public boolean contains(T element) {
        for (Anything current : this) {
            if (!element.equals(current)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void insert(T element) {
        if (element instanceof AnyType) {
            AnyType toAdd = (AnyType)element;
            UnidirectionalLink nw = TransactionManager.getContext().set(this.owner, this.associationName, toAdd.getObject());
            this.unidirectionalLinks.add((Tuple<UnidirectionalLink, Object>)new Tuple((java.lang.Object)nw, (java.lang.Object)nw.getTarget()));
        } else if (element instanceof Int) {
            Int toAdd = (Int)element;
            UnidirectionalLink nw = TransactionManager.getContext().set(this.owner, this.associationName, toAdd.getVal());
            this.unidirectionalLinks.add((Tuple<UnidirectionalLink, Object>)new Tuple((java.lang.Object)nw, (java.lang.Object)nw.getTarget()));
        } else if (element instanceof Str) {
            Str toAdd = (Str)element;
            UnidirectionalLink nw = TransactionManager.getContext().set(this.owner, this.associationName, toAdd.toString());
            this.unidirectionalLinks.add((Tuple<UnidirectionalLink, Object>)new Tuple((java.lang.Object)nw, (java.lang.Object)nw.getTarget()));
        } else {
            throw new FrameworkException("Type to insert is not known");
        }
    }

    @Override
    public void apply(Procedure<T> procedure) {
        for (Anything current : this) {
            procedure.op(current);
        }
    }

    @Override
    public void remove(Predicate<T> predicate) {
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            Anything current = (Anything)iterator.next();
            if (!predicate.p(current)) continue;
            iterator.remove();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new PersistenceIteratorWithLink(this.unidirectionalLinks);
    }

    @Override
    public boolean isEmpty() {
        return this.unidirectionalLinks.isEmpty();
    }

    @Override
    public ImmutableCollection<T> copy() {
        ImmutableCollection<Anything> result = new ImmutableList<Anything>();
        for (Anything current : this) {
            result = result.add(current);
        }
        return result;
    }

    public String toString() {
        Vector<Anything> result = new Vector<Anything>();
        for (Anything current : this) {
            result.add(current);
        }
        return result.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(java.lang.Object obj) {
        if (!(obj instanceof MutableCollection)) {
            return false;
        }
        try {
            MutableCollection other = (MutableCollection)obj;
            for (Anything current : this) {
                if (other.contains(current)) continue;
                return false;
            }
            for (Anything current : other) {
                if (this.contains(current)) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.copy().hashCode();
    }
}

