package de.fhdw.wtf.context.model.collections;

import java.util.Iterator;

import de.fhdw.wtf.context.core.ObjectFactoryProvider;
import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.persistence.exception.RuntimePersistenceException;
import de.fhdw.wtf.persistence.meta.UserObject;

/**
 * This class provides an Iterator for Persistent* with Objects.
 * 
 * @param <T>
 *            The underlying element type.
 */
public class PersistenceIteratorWithObject<T extends Anything> implements Iterator<T> {
	
	/**
	 * An iterator over the underlying objects.
	 */
	private final Iterator<UserObject> objects;
	
	/**
	 * Creates a PersistenceIteratorWithLink.
	 * 
	 * @param objects
	 *            A collection of the underlying objects.
	 */
	public PersistenceIteratorWithObject(final Iterator<UserObject> objects) {
		super();
		this.objects = objects;
	}
	
	@Override
	public boolean hasNext() {
		return this.objects.hasNext();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public T next() {
		final UserObject object = this.objects.next();
		return (T) ObjectFactoryProvider.instance().createObject(object);
	}
	
	@Override
	public void remove() {
		throw new RuntimePersistenceException();
	}
	
}
