package de.fhdw.wtf.context.core;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

import de.fhdw.wtf.context.model.IAnyType;

/**
 * This cache contains objects inside a context.
 */
public class IAnyTypeCache {
	/**
	 * The underlying object cache.
	 */
	private final Map<Long, WeakReference<IAnyType>> objectCache = new HashMap<>();
	
	/**
	 * Adds the specified object to the cache.
	 * 
	 * @param object
	 *            the object to be cached
	 * @param id
	 *            the id of the object.
	 */
	public void put(final long id, final IAnyType object) {
		this.objectCache.put(id, new WeakReference<>(object));
	}
	
	/**
	 * Returns the object to which the specified id is mapped, or {@code null} if this cache contains no mapping for the
	 * id.
	 * 
	 * @param id
	 *            the id whose associated object is to be returned
	 * @return the object to which the specified id is mapped, or {@code null} if this cache contains no mapping for the
	 *         id
	 */
	public IAnyType get(final long id) {
		final WeakReference<IAnyType> weakObject = this.objectCache.get(id);
		if (weakObject == null) {
			return null;
		}
		return weakObject.get();
	}
}
