/*
 * Decompiled with CFR 0.152.
 */
package test.integration;

import de.fhdw.wtf.context.core.Context;
import de.fhdw.wtf.context.core.PersistenceContext;
import de.fhdw.wtf.context.core.TransactionManager;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.exception.TypeOrAssociationNotFoundException;
import de.fhdw.wtf.persistence.meta.MapAssociation;
import de.fhdw.wtf.persistence.meta.MapLink;
import de.fhdw.wtf.persistence.meta.Type;
import de.fhdw.wtf.persistence.meta.UnidirectionalAssociation;
import de.fhdw.wtf.persistence.meta.UserObject;
import de.fhdw.wtf.persistence.meta.UserType;
import de.fhdw.wtf.persistence.utils.Tuple;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.integration.IntegrationTestSuperClass;
import test.integration.TestBase;
import test.integration.TestBaseWithDB;

public class TestAssociation3WithDB
extends IntegrationTestSuperClass {
    private UserType anyType;
    private UserType someUserType;
    private UserType anotherUserType;
    private UserType persistentMap;
    private MapAssociation mapLinks;
    private UserObject someUserObject;
    private UserObject anotherUserObject;

    @Override
    protected TestBase genTestBase() {
        return new TestBaseWithDB();
    }

    @Override
    protected TestBaseWithDB getTestBase() {
        return (TestBaseWithDB)super.getTestBase();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.initializeTypesAndSpecializationAndAssociations();
        TransactionManager.setContext((Context)new PersistenceContext(this.getTestBase().getObjectFacade(), this.getTestBase().getObjectFacade().provideAdhocTransaction()));
        this.someUserObject = TransactionManager.getContext().create("SomeUserType");
        this.anotherUserObject = TransactionManager.getContext().create("AnotherUserType");
    }

    protected void initializeTypesAndSpecializationAndAssociations() throws PersistenceException {
        this.anyType = this.getTestBase().getClassFacade().createUserType("AnyType", false, false);
        this.someUserType = this.getTestBase().getClassFacade().createUserType("SomeUserType", false, false);
        this.anotherUserType = this.getTestBase().getClassFacade().createUserType("AnotherUserType", false, false);
        this.persistentMap = this.getTestBase().getClassFacade().createUserType("de.fhdw.wtf.context.model.collections.PersistentMap", false, false);
        this.mapLinks = this.getTestBase().getClassFacade().createMapAssociation("links", false, this.persistentMap, (Type)this.anyType, (Type)this.anyType);
        this.getTestBase().getClassFacade().createSpecializationBetween(this.anyType, (Type)this.someUserType);
        this.getTestBase().getClassFacade().createSpecializationBetween(this.anyType, (Type)this.anotherUserType);
        this.getTestBase().getClassFacade().finalizeSpecialization();
        this.persistentMap = this.getTestBase().getClassFacade().createUserType("de.fhdw.wtf.context.model.collections.PersistentList", false, false);
        this.getTestBase().getClassFacade().createUserType("generated.model.de.fhdw.partner.Haus", false, false);
        this.getTestBase().getClassFacade().createUserType("generated.model.de.fhdw.partner.NatuerlichePerson", false, false);
        this.getTestBase().getClassFacade().createUserType("generated.model.de.fhdw.partner.Postfach", false, false);
        this.getTestBase().getClassFacade().createUserType("generated.model.de.fhdw.partner.Telefon", false, false);
        this.getTestBase().getClassFacade().createUserType("generated.model.de.fhdw.partner.Telefonbuch", false, false);
    }

    @Test
    public void testAssociation3Type() throws TypeOrAssociationNotFoundException {
        MapAssociation association = this.getTestBase().getObjectFacade().getTypeManager().getMapAssociationForName("de.fhdw.wtf.context.model.collections.PersistentMap.links");
        if (association instanceof MapAssociation) {
            return;
        }
        if (association instanceof UnidirectionalAssociation) {
            System.out.println("association is of type UnidirectionalAssociation (and not MapAssociation)");
            Assert.fail();
        }
        Assert.fail();
    }

    @Test
    public void testCreateLink3() throws PersistenceException {
        UserObject owner = TransactionManager.getContext().create("de.fhdw.wtf.context.model.collections.PersistentMap");
        TransactionManager.getContext().put(owner, "de.fhdw.wtf.context.model.collections.PersistentMap.links", this.someUserObject, this.anotherUserObject);
        Collection dbValue = TransactionManager.getContext().get(owner, "de.fhdw.wtf.context.model.collections.PersistentMap.links", this.anotherUserObject);
        Assert.assertEquals((long)dbValue.size(), (long)1L);
        Assert.assertTrue((boolean)this.someUserObject.isTheSameAs(((Tuple)dbValue.iterator().next()).getSecond()));
        Assert.assertTrue((boolean)this.anotherUserObject.isTheSameAs((Object)((MapLink)((Tuple)dbValue.iterator().next()).getFirst()).getKey()));
        Assert.assertTrue((boolean)owner.isTheSameAs((Object)((MapLink)((Tuple)dbValue.iterator().next()).getFirst()).getOwner()));
    }
}

