/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.core;

import de.fhdw.wtf.context.core.ContextWithDatabaseAccess;
import de.fhdw.wtf.context.core.Logger;
import de.fhdw.wtf.context.exception.ManipulationDuringRevisionException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.exception.RuntimePersistenceException;
import de.fhdw.wtf.persistence.facade.ObjectFacade;
import de.fhdw.wtf.persistence.facade.TypeManager;
import de.fhdw.wtf.persistence.meta.Association;
import de.fhdw.wtf.persistence.meta.Link;
import de.fhdw.wtf.persistence.meta.MapLink;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.UnidirectionalLink;
import de.fhdw.wtf.persistence.meta.UserObject;
import de.fhdw.wtf.persistence.utils.Tuple;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;

public class RevisionContext
extends ContextWithDatabaseAccess {
    private final ManipulationDuringRevisionException exception;
    private final Date date;

    public RevisionContext(ObjectFacade objectFacade, Date date) {
        super(objectFacade);
        this.date = new Date(date.getTime());
        this.exception = new ManipulationDuringRevisionException();
    }

    @Override
    public Collection<UserObject> find(String associationName, String value) {
        try {
            return this.objectFacade.find((Association)this.typeManager.getUnidirectionalAssociationForName(associationName), value, this.date);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public Collection<UserObject> find(String associationName, BigInteger value) {
        try {
            return this.objectFacade.find((Association)this.typeManager.getUnidirectionalAssociationForName(associationName), value, this.date);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public Collection<Tuple<UnidirectionalLink, UserObject>> inverseGet(String associationName, UserObject object) {
        try {
            return this.objectFacade.inverseGet(object, this.typeManager.getUnidirectionalAssociationForName(associationName), this.date);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public Collection<Tuple<UnidirectionalLink, Object>> get(UserObject object, String associationName) {
        try {
            return this.objectFacade.get(object, this.typeManager.getUnidirectionalAssociationForName(associationName), this.date);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public Collection<Tuple<MapLink, Object>> get(UserObject object, String associationName, String key) {
        throw new RuntimePersistenceException();
    }

    @Override
    public Collection<Tuple<MapLink, Object>> get(UserObject object, String associationName, BigInteger key) {
        throw new RuntimePersistenceException();
    }

    @Override
    public Collection<Tuple<MapLink, Object>> get(UserObject object, String associationName, UserObject key) {
        throw new RuntimePersistenceException();
    }

    @Override
    public UserObject create(String typeName) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public UnidirectionalLink set(UserObject object, String associationName, String val) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public UnidirectionalLink set(UserObject object, String associationName, BigInteger val) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public UnidirectionalLink set(UserObject object, String associationName, UserObject target) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public MapLink put(UserObject owner, String associationName, UserObject target, String key) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public MapLink put(UserObject owner, String associationName, BigInteger target, String key) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public MapLink put(UserObject owner, String associationName, String target, String key) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public MapLink put(UserObject owner, String associationName, UserObject target, BigInteger key) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public MapLink put(UserObject owner, String associationName, BigInteger target, BigInteger key) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public MapLink put(UserObject owner, String associationName, String target, BigInteger key) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public MapLink put(UserObject owner, String associationName, UserObject target, UserObject key) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public MapLink put(UserObject owner, String associationName, BigInteger target, UserObject key) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public MapLink put(UserObject owner, String associationName, String target, UserObject key) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }

    @Override
    public void savePoint() {
    }

    @Override
    public void rollbackToSavePoint() {
    }

    @Override
    public void unset(Link toUnset) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public TypeManager getTypeManager() {
        return this.objectFacade.getTypeManager();
    }

    @Override
    public Collection<UserObject> getObjectsByType(String typeName) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }

    @Override
    public UserObject checkout(long object) {
        Logger.getInstance().logError(this.exception.getMessage());
        throw this.exception;
    }
}

