package de.fhdw.wtf.context.core;

/**
 * An interface to represent the supertype to all types, which are able to observer other object.
 * 
 */
public interface Observer {
	
	/**
	 * An update method which is invoked, when subjects change their state to notify observer about their changes.
	 * 
	 * @param event
	 *            It is possible to provide an event object to precisely notify the observer about his changes.
	 */
	void update(ObserverEvent event);
	
}
