package de.fhdw.wtf.context.model;

import de.fhdw.wtf.context.core.ObjectFactory;
import de.fhdw.wtf.context.exception.FrameworkException;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.UserObject;

/**
 * This class represents the abstract superclass to all factories for user defined types.
 * 
 */
public abstract class UserObjectFactory extends ObjectFactory {
	
	@Override
	public Anything createObject(final Object object) {
		if (object instanceof UserObject) {
			final AnyType result = this.createSpecificUserType();
			result.setObject((UserObject) object);
			return result;
		} else {
			throw new FrameworkException("UserObjectFactory.createObject() called on object of type "
					+ object.getClass().getName());
		}
	}
	
	/**
	 * The method creates a new instance of a User Type.
	 * 
	 * @return A user type which is a subtype of AnyType.
	 */
	protected abstract AnyType createSpecificUserType();
	
}
