package de.fhdw.wtf.context.model;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;

import org.aspectj.lang.annotation.SuppressAjWarnings;
import org.aspectj.lang.reflect.FieldSignature;

import de.fhdw.wtf.context.core.FieldChangeEvent;
import de.fhdw.wtf.context.core.ObjectFactoryProvider;
import de.fhdw.wtf.context.core.TransactionManager;
import de.fhdw.wtf.context.exception.FrameworkException;
import de.fhdw.wtf.context.model.collections.MutableList;
import de.fhdw.wtf.context.model.collections.MutableMap;
import de.fhdw.wtf.context.model.collections.PersistentList;
import de.fhdw.wtf.context.model.collections.PersistentMap;
import de.fhdw.wtf.persistence.meta.IntegerValue;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.StringValue;
import de.fhdw.wtf.persistence.meta.UnidirectionalLink;
import de.fhdw.wtf.persistence.meta.UserObject;
import de.fhdw.wtf.persistence.utils.Tuple;
	
/**
 * 	This Aspect extends all subclasses of AnyType so they can be used in 
 * 	persistence Context.
 *
 */
public aspect AnyTypeDbAspect {
	
	//additional variables
	/**
	 * Contains names of fields which have valid values (i.e. which have either
	 * been written or which have been read from the database).
	 */
	private final transient HashSet<String> AnyType.valid = new HashSet<String>();
	//end additional variables
	
	//pointcuts
	pointcut factoryInit() : execution(AnyType de.fhdw.wtf.context.model.UserObjectFactory+.createSpecificUserType());
	
	pointcut executingNewAnyType(): execution(AnyType.new());
	pointcut callNewMutableList(): call(MutableList.new());
	pointcut callNewMutableMap(): call(MutableMap.new());
	
	pointcut setAnything(AnyType owner, Anything target): set( Anything+ AnyType+.*) && target(owner) && args(target);
	
	pointcut getStr(AnyType owner): get(!transient Str AnyType+.*) && target(owner);
	pointcut getInt(AnyType owner): get(!transient Int AnyType+.*) && target(owner);
	pointcut getAnyType(AnyType owner): get(!transient Anything+ AnyType+.*) && target(owner)
			&& !get(de.fhdw.wtf.context.model.Str AnyType+.*)
			&& !get(de.fhdw.wtf.context.model.Int AnyType+.*)
			&& !get(de.fhdw.wtf.context.model.collections.MutableList+ AnyType+.*)
			&& !get(de.fhdw.wtf.context.model.collections.MutableMap+ AnyType+.*);
	pointcut getMutableList(AnyType owner): get(!transient de.fhdw.wtf.context.model.collections.MutableList+ AnyType+.*) && target(owner);
	pointcut getMutableMap(AnyType owner): get(!transient de.fhdw.wtf.context.model.collections.MutableMap+ AnyType+.*) && target(owner);
	
	pointcut setStr(AnyType owner, Str value): set(!transient Str AnyType+.*) && target(owner) && args(value);
	pointcut setInt(AnyType owner, Int value): set(!transient Int AnyType+.*) && target(owner) && args(value);
	pointcut setAnyType(AnyType owner, AnyType value): set(!transient Anything+ AnyType+.*) && target(owner) && args(value);
	//end pointcuts
	
	
	after() returning(): executingNewAnyType() && !cflow(factoryInit()) {
		final AnyType result = (AnyType)thisJoinPoint.getThis();
		final UserObject object = TransactionManager.getContext().create(result.getClass().getName());
		result.setObject(object);
	}
	
	@SuppressAjWarnings({"adviceDidNotMatch"})
	@SuppressWarnings("rawtypes")
	MutableMap around(): callNewMutableMap() {
		return new PersistentMap<>();
	}

	@SuppressAjWarnings({"adviceDidNotMatch"})
	@SuppressWarnings("rawtypes")
	MutableList around(): callNewMutableList() {
		return new PersistentList<>();
	}
	
	@SuppressAjWarnings({"adviceDidNotMatch"})
	after(final AnyType owner, final Anything target) : setAnything(owner,target) && !cflow(factoryInit()) {
		owner.notifyObservers(new FieldChangeEvent(this.stripSignature(thisJoinPointStaticPart.getSignature().toString()), target));
	}
	
	
	@SuppressAjWarnings({"adviceDidNotMatch"})
	java.lang.Object around(final AnyType owner) : getAnyType(owner) {
		final FieldSignature signatur = (FieldSignature)thisJoinPointStaticPart.getSignature();
		final String signatureString = this.stripSignature(signatur.toString());
		if (owner.valid.contains(signatureString)) {
			return proceed(owner);
		}
		final Collection<Tuple<UnidirectionalLink, Object>> databaseResults = TransactionManager.getContext().get(owner.getObject(), signatureString);
		owner.valid.add(signatureString);
		if (databaseResults.isEmpty()) {
				return null;
		}
		final UserObject object = (UserObject) databaseResults.iterator().next().getSecond();
		//ask cache
		AnyType result = TransactionManager.getContext().getCache().get(object.getId());
		if(result == null){
			result = (AnyType) ObjectFactoryProvider.instance().createObject(object);
			TransactionManager.getContext().getCache().put(object.getId(),result);
		}
		final Field field = signatur.getField();
		field.setAccessible(true);
		try {
			field.set(owner, result);
			owner.valid.add(signatureString);
		}
		catch (final IllegalAccessException e) {
			throw new FrameworkException("Field access error : "+e.getMessage());
		}
		return result;
	}

	@SuppressAjWarnings({"adviceDidNotMatch"})
	@SuppressWarnings("rawtypes")
	de.fhdw.wtf.context.model.collections.MutableMap around(final AnyType owner) : getMutableMap(owner){
		final FieldSignature signatur = (FieldSignature)thisJoinPointStaticPart.getSignature();
		final String signatureString = this.stripSignature(signatur.toString());
		if (owner.valid.contains(signatureString)) {
			return proceed(owner);
		}

		Collection<Tuple<UnidirectionalLink, Object>> databaseResults = TransactionManager.getContext().get(owner.getObject(),signatureString);
		owner.valid.add(signatureString);
		if (databaseResults.isEmpty()) {
			final PersistentMap<Anything,Anything> newMap = new PersistentMap<Anything,Anything>();
			//create UnidirectionalLink to map-container, which makes the result persistent (in getObject())
			TransactionManager.getContext().set(owner.getObject(), signatureString, newMap.getObject());

			databaseResults = TransactionManager.getContext().get(owner.getObject(),signatureString);
		}
		final UserObject object = (UserObject) databaseResults.iterator().next().getSecond();
		//ask cache
		MutableMap result = (MutableMap) TransactionManager.getContext().getCache().get(object.getId());
		if(result == null){
			result = (MutableMap) ObjectFactoryProvider.instance().createObject(object);
			TransactionManager.getContext().getCache().put(object.getId(),result);
		}
		result.setObject(object);
				
		final Field field = signatur.getField();
		field.setAccessible(true);
		try {
			field.set(owner, result);
			owner.valid.add(signatureString);
		}
		catch (final IllegalAccessException e) {
			throw new FrameworkException("Field access error : "+e.getMessage());
		}
		return result;
		//TODO zweite methode die im factoryInit Dummy liefert?
	}
	
	@SuppressAjWarnings({"adviceDidNotMatch"})
	@SuppressWarnings("rawtypes")
	de.fhdw.wtf.context.model.collections.MutableList around(final AnyType owner) : getMutableList(owner){
		final FieldSignature signatur = (FieldSignature)thisJoinPointStaticPart.getSignature();
		final String signatureString = this.stripSignature(signatur.toString());
		if (owner.valid.contains(signatureString)) {
			return proceed(owner);
		}
		Collection<Tuple<UnidirectionalLink, Object>> databaseResults = TransactionManager.getContext().get(owner.getObject(),signatureString);
		owner.valid.add(signatureString);
		if (databaseResults.isEmpty()) {
			final PersistentList<Anything> newSet = new PersistentList<Anything>();
			//create UnidirectionalLink to set-container, which makes the result persistent (in getObject())
			TransactionManager.getContext().set(owner.getObject(), signatureString, newSet.getObject());

			databaseResults = TransactionManager.getContext().get(owner.getObject(),signatureString);
		}
		final UserObject object = (UserObject) databaseResults.iterator().next().getSecond();
		//ask cache
		MutableList result = (MutableList) TransactionManager.getContext().getCache().get(object.getId());
		if(result == null){
			result = (MutableList) ObjectFactoryProvider.instance().createObject(object);
			TransactionManager.getContext().getCache().put(object.getId(),result);
		}
		result.setObject(object);
		
		final Field field = signatur.getField();
		field.setAccessible(true);
		try {
			field.set(owner, result);
			owner.valid.add(signatureString);
		}
		catch (final IllegalAccessException e) {
			throw new FrameworkException("Field access error : "+e.getMessage());
		}
		return result;
		//TODO zweite methode die im factoryInit Dummy liefert?
	}
	
	@SuppressAjWarnings({"adviceDidNotMatch"})
	Str around(final AnyType owner) : getStr(owner) {
		final FieldSignature signatur = (FieldSignature)thisJoinPointStaticPart.getSignature();
		final String signatureString = this.stripSignature(signatur.toString());
		if (owner.valid.contains(signatureString)) {
			return proceed(owner);
		}
		final Str result =  new Str((StringValue)TransactionManager.getContext().get(owner.getObject(), signatureString).iterator().next().getSecond());
		owner.valid.add(signatureString);
		final Field field = signatur.getField();
		field.setAccessible(true);
		try {
			field.set(owner, result);
			owner.valid.add(signatureString);
		}
		catch (final IllegalAccessException e) {
			throw new FrameworkException("Field access error : "+e.getMessage());
		}
		return result;
	}
	
	@SuppressAjWarnings({"adviceDidNotMatch"})
	Int around(final AnyType owner) : getInt(owner) {
		final FieldSignature signatur = (FieldSignature)thisJoinPointStaticPart.getSignature();
		final String signatureString = this.stripSignature(signatur.toString());
		if (owner.valid.contains(signatureString)) {
			return proceed(owner);
		}
		final Int result =  new Int((IntegerValue)TransactionManager.getContext().get(owner.getObject(), signatureString).iterator().next().getSecond());
		owner.valid.add(signatureString);
		final Field field = signatur.getField();
		field.setAccessible(true);
		try {
			field.set(owner, result);
			owner.valid.add(signatureString);
		}
		catch (final IllegalAccessException e) {
			throw new FrameworkException("Field access error : "+e.getMessage());
		}
		return result;
	}
	
	@SuppressAjWarnings({"adviceDidNotMatch"})
	after(final AnyType owner, final Str value) : setStr(owner,value) && !cflow(factoryInit()) {
		final String signatur = this.stripSignature(thisJoinPointStaticPart.toString());
		owner.valid.add(signatur);
		TransactionManager.getContext().set(owner.getObject(), signatur, value.toString());
	}
	
	@SuppressAjWarnings({"adviceDidNotMatch"})
	after(final AnyType owner, final Int value) : setInt(owner,value) && !cflow(factoryInit()) {
		final String signatur = this.stripSignature(thisJoinPointStaticPart.toString());
		owner.valid.add(signatur);
		TransactionManager.getContext().set(owner.getObject(), signatur, value.getVal());
	}
	
	@SuppressAjWarnings({"adviceDidNotMatch"})
	after(final AnyType owner, final AnyType target) : setAnyType(owner,target) && !cflow(factoryInit()) {
		final String signatur = this.stripSignature(thisJoinPointStaticPart.toString());
		owner.valid.add(signatur);
		TransactionManager.getContext().set(owner.getObject(), signatur, target.getObject());
	}
	
	private String stripSignature(final String sig) {
		String result = sig.substring(sig.indexOf(' ')+1);
		if (result.charAt(result.length()-1) == ')') {
			result = result.substring(0,result.length()-1);
		}
		return result;
	}

}
