package de.fhdw.wtf.context.model.collections;

import java.util.Iterator;

import de.fhdw.wtf.context.model.AnyType;
import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.collections.functors.Predicate;
import de.fhdw.wtf.context.model.collections.functors.Procedure;
import de.fhdw.wtf.persistence.meta.UserObject;

/**
 * An interface to represent MutableLists in WTF. The implementation will be injected with
 * {@link de.fhdw.wtf.context.model.collections.TransientList} or
 * {@link de.fhdw.wtf.context.model.collections.PersistentList} while compiling.
 * 
 * @param <T>
 */
public class MutableList<T extends Anything> extends AnyType implements MutableCollection<T> {
	
	/**
	 * This class will be replaced (using an aspect) by PersistentList or TransientList.
	 */
	public MutableList() {
	}
	
	/**
	 * Loads object from database.
	 * 
	 * @param userObject
	 *            The underlying user object.
	 */
	public MutableList(final UserObject userObject) {
		super(userObject);
	}
	
	@Override
	public Collection<T> union(final Collection<? extends T> otherCollection) {
		return null;
	}
	
	@Override
	public boolean contains(final T element) {
		return false;
	}
	
	@Override
	public boolean isEmpty() {
		return true;
	}
	
	@Override
	public Iterator<T> iterator() {
		return null;
	}
	
	@Override
	public void insert(final T element) {
		// nothing to do
	}
	
	@Override
	public void apply(final Procedure<T> procedure) {
		// nothing to do
	}
	
	@Override
	public void remove(final Predicate<T> predicate) {
		// nothing to do
	}
	
	@Override
	public ImmutableCollection<T> copy() {
		return null;
	}
	
}
