package de.fhdw.wtf.context.model.collections.functors;

import de.fhdw.wtf.context.model.Anything;

/**
 * An interface which represents an equivalence relation over T.
 * 
 * @param <T>
 *            The Type of the relation, must be a subclass of Anything.
 */
public interface EquivalenceRelation<T extends Anything> {
	
	/**
	 * This method represents the equivalence relation.
	 * 
	 * @param a
	 *            An element of T.
	 * @param b
	 *            Another element of T.
	 * @return Provides true if a and b are equivalent under this relation.
	 */
	boolean equivalent(T a, T b);
	
}
