package de.fhdw.wtf.context.model.collections;

import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.collections.functors.Predicate;
import de.fhdw.wtf.context.model.collections.functors.Procedure;

/**
 * An interface to represent a mutable collection. A mutable Collection offers methods to change this collection in
 * place.
 * 
 * @param <T>
 *            Type of all the elements in this collection, must be a subtype of Anything.
 */
public interface MutableCollection<T extends Anything> extends Collection<T>, Iterable<T> {
	
	/**
	 * Inserts a new element to this collection without changing the object of this collection.
	 * 
	 * @param element
	 *            A new Element of Type T which is added to this collection.
	 */
	void insert(T element);
	
	/**
	 * This method applies a procedure to all elements of this collection. Because a procedure has no return type, the
	 * procedure will have side effects and it will possible change the state of the objects in this collection.
	 * 
	 * @param procedure
	 *            A Function p: T -> () which applies a method with side effects to the elements of the collection.
	 */
	void apply(Procedure<T> procedure);
	
	/**
	 * This method will remove elements from this collection if they suffice the predicate. This means if the predicate
	 * returns true for a given element of Type t, it will remove this element from the collection.
	 * 
	 * @param predicate
	 *            A Predicate which is used to filter this collection, A predicate is a function p: T -> Bool.
	 */
	void remove(Predicate<T> predicate);
	
	/**
	 * This method returns an immutable copy of this collection. This makes it possible to perform arbitrary
	 * computations with the elements of this collection without changes them.
	 * 
	 * @return Provides an immutable copy of itself.
	 */
	ImmutableCollection<T> copy();
	
}
