package de.fhdw.wtf.context.model;

/**
 * Manager for providing IDs in a NoDatabase-environment.
 */
public final class TransientIdManager {
	
	/**
	 * The singleton instance of this class.
	 */
	private static TransientIdManager instance = null;
	/**
	 * The last ID used.
	 */
	private long lastId;
	
	/**
	 * Returns the singleton instance of this class.
	 * 
	 * @return The singleton instance of this class.
	 */
	protected static synchronized TransientIdManager getInstance() {
		if (instance == null) {
			instance = new TransientIdManager();
		}
		return instance;
	}
	
	/**
	 * Default constructor.
	 */
	private TransientIdManager() {
		this.lastId = 0;
	}
	
	/**
	 * Returns a new unused ID.
	 * 
	 * @return A new unused ID.
	 */
	protected synchronized long getNewId() {
		this.lastId++;
		return this.lastId;
	}
}
