package de.fhdw.wtf.context.model.collections.functors;

import de.fhdw.wtf.context.model.Anything;

/**
 * An interface to represent a Predicate over T.
 * 
 * @param <T>
 *            A given Type must be a subclass of T.
 */
public interface Predicate<T extends Anything> {
	
	/**
	 * A method to implement the Predicate.
	 * 
	 * @param t
	 *            An element of T.
	 * @return Provides true if t suffices the Predicate.
	 */
	boolean p(T t);
	
}
