package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenericTypeStateVisitor;
import de.fhdw.wtf.generator.java.visitor.GenericTypeStateVisitorReturn;

public final class GenHasGenericType extends GenericTypeState {
	
	private final GenType type;
	
	private GenHasGenericType(final GenType type) {
		this.type = type;
	}
	
	public static GenHasGenericType create(final GenType type) {
		return new GenHasGenericType(type);
	}
	
	/**
	 * Projections.
	 * 
	 * @return type
	 */
	public GenType getType() {
		return this.type;
	}
	
	@Override
	public void accept(final GenericTypeStateVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenericTypeStateVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
}
