package de.fhdw.wtf.generator.java.generatorModel;

import java.util.ArrayList;
import java.util.List;

import de.fhdw.wtf.generator.java.visitor.GenOperationVisitorReturn;

/**
 * This class describes operations and constructors with their arguments.
 */
public abstract class GenOperation extends GenClassMember {
	
	private GenOperationState state;
	private final List<GenParameter> parameters;
	private final ArrayList<Generic> generics;
	
	protected GenOperation(final String name, final List<GenParameter> parameters, final GenOperationState state) {
		super(name);
		this.parameters = parameters;
		this.generics = new ArrayList<>();
		this.state = state;
	}
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <X>
	 *            The returntype of the handle and the accept method.
	 * @return Returns the result of type <X> that is returned by the handle method.
	 */
	public abstract <X> X accept(GenOperationVisitorReturn<X> visitor);
	
	public void setState(final GenOperationState state) {
		this.state = state;
	}
	
	public GenOperationState getState() {
		return this.state;
	}
	
	public List<GenParameter> getParameters() {
		return this.parameters;
	}
	
	public ArrayList<Generic> getGenerics() {
		return this.generics;
	}
	
}
