package de.fhdw.wtf.generator.transformer.clipper;

import java.util.Iterator;

import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitorReturnException;
import de.fhdw.wtf.generator.java.walker.SimpleGeneratorModelWalkerTask;
import de.fhdw.wtf.generator.transformer.exception.NoMatchingMethodException;

/**
 * Java syntax tree operations have to states (SimpleOperationState, FullParsedOperationState). This class offers
 * operations for converting unparsed (simple) operations to full parsed ones.
 * 
 * Attention: This class is currently unused, because our java syntax tree does not support all java features (generics
 * in operation signatures, attributes with default implementation, several attribute and parameter modifier).
 * 
 */
public class ConvertSimpleOperationsToFullParsedTask extends SimpleGeneratorModelWalkerTask {
	
	/**
	 * @param taskmanager
	 * @param javaGeneratorModel
	 */
	public ConvertSimpleOperationsToFullParsedTask(final TaskExecutor taskmanager,
			final GeneratorModel javaGeneratorModel) {
		super(taskmanager, javaGeneratorModel);
	}
	
	@Override
	public void handleOperation(final GenOperation o) throws TaskException {
		// nothing to do
	}
	
	@Override
	public void finalizeTask() throws TaskException {
		// nothing to do
	}
	
	@Override
	public void handleClassClass(final GenClassClass cc) throws TaskException {
		this.convert(cc);
	}
	
	@Override
	public void handleInterfaceClass(final GenInterfaceClass ic) throws TaskException {
		this.convert(ic);
	}
	
	// @Override
	// public void handleInterfaceWithImplClassClass(final GenInterfaceWithImplClassClass iwic) throws TaskException {
	// this.convert(iwic);
	// }
	
	private void convert(final de.fhdw.wtf.generator.java.generatorModel.GenClass t) throws TaskException {
		final Iterator<GenJavaOperation> i = t.getOperations().iterator();
		while (i.hasNext()) {
			final GenJavaOperation current = i.next();
			try {
				final GenFullParsedOperationState newState = this.convertOperation(current);
				current.setState(newState);
			} catch (final NoMatchingMethodException e) {
				// no need to replace
			}
		}
	}
	
	/**
	 * Converts the state of the given operation to a FullParsedState - it analyzes the source code in a
	 * SimpleOperationState and returns the merged state.
	 * 
	 * @param op
	 * @return merged state of the operation
	 * @throws TaskException
	 */
	private GenFullParsedOperationState convertOperation(final GenOperation op) throws TaskException {
		return op.getState().accept(
				new GenOperationStateVisitorReturnException<GenFullParsedOperationState, TaskException>() {
					@Override
					public GenFullParsedOperationState handle(final GenFullParsedOperationState s)
							throws NoMatchingMethodException {
						// nothing to do
						throw new NoMatchingMethodException(op.getName());
					}
					
					@Override
					public GenFullParsedOperationState handle(final GenSimpleOperationState o) throws TaskException {
						final GenOperation modelOperation = o.getOverwrittenOperation();
						final GenFullParsedOperationState clippedOperation =
								ClipperUtils.parseOperation(
										o.getFullOperationWithPossibleImplementation(),
										op.getName());
						return this.mergeOp(this.expectFullParsed(modelOperation.getState()), clippedOperation);
					}
					
					/**
					 * Merges the model and clipped operation. Has side effects on modelOperation!
					 * 
					 * @param modelOperation
					 * @param clippedOperation
					 * @return
					 */
					@SuppressWarnings("javadoc")
					private GenFullParsedOperationState mergeOp(final GenFullParsedOperationState modelOperation,
							final GenFullParsedOperationState clippedOperation) {
						modelOperation.setVisibility(modelOperation.getVisibility().min(
								clippedOperation.getVisibility()));
						modelOperation.setMethodBody(clippedOperation.getMethodBody());
						modelOperation.setComment(clippedOperation.getComment());
						modelOperation.getModifiers().addAll(clippedOperation.getModifiers());
						return clippedOperation;
					}
					
					private GenFullParsedOperationState expectFullParsed(final GenOperationState state)
							throws TaskException {
						return state
								.accept(new GenOperationStateVisitorReturnException<GenFullParsedOperationState, TaskException>() {
									
									@Override
									public GenFullParsedOperationState handle(final GenSimpleOperationState s)
											throws TaskException {
										throw new TaskException("Overridden Model operation must be full parsed.");
									}
									
									@Override
									public GenFullParsedOperationState handle(final GenFullParsedOperationState s)
											throws TaskException {
										return s;
									}
								});
					}
				});
	}
}
