/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import de.fhdw.wtf.common.ast.Attribute;
import de.fhdw.wtf.common.ast.Constructor;
import de.fhdw.wtf.common.ast.ConstructorByReferenceState;
import de.fhdw.wtf.common.ast.ConstructorByTypeAndSignatureState;
import de.fhdw.wtf.common.ast.ConstructorInvalidState;
import de.fhdw.wtf.common.ast.ConstructorOrOperation;
import de.fhdw.wtf.common.ast.ConstructorReference;
import de.fhdw.wtf.common.ast.Group;
import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.type.AtomicType;
import de.fhdw.wtf.common.ast.type.BaseType;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.ast.type.CompositeType;
import de.fhdw.wtf.common.ast.type.ProductElementType;
import de.fhdw.wtf.common.ast.type.ProductType;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.ast.type.TypeProxy;
import de.fhdw.wtf.common.ast.visitor.AtomicTypeVisitorReturnException;
import de.fhdw.wtf.common.ast.visitor.ConstructorReferenceStateVisitorReturnException;
import de.fhdw.wtf.common.ast.visitor.TypeVisitorReturnException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.common.token.DummyToken;
import de.fhdw.wtf.common.token.Token;
import de.fhdw.wtf.generator.java.generatorModel.GenAnyType;
import de.fhdw.wtf.generator.java.generatorModel.GenAttributeModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenHasNoGenericType;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenMutableMap;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenStringType;
import de.fhdw.wtf.generator.java.generatorModel.GenType;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReferenceByName;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReferenceByReference;
import de.fhdw.wtf.generator.java.generatorModel.GenUnqualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.java.generatorModel.GenVoidType;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.generatorModel.Generic;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.transformer.exception.GenTypeNotReferencedException;
import de.fhdw.wtf.walker.walker.SimpleWalkerTask;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ConstructorCallGenerationTask
extends SimpleWalkerTask {
    private final GeneratorModel generatorModel;
    private final Map<Type, List<Type>> callOrder;
    private final Map<Integer, GenUserClass> genericTuplesToGenerate;

    public ConstructorCallGenerationTask(Model m, TaskExecutor taskmanager, GeneratorModel generatorModel) {
        super(m, taskmanager);
        this.callOrder = m.getConstructorCallDependencies();
        this.generatorModel = generatorModel;
        this.genericTuplesToGenerate = new HashMap<Integer, GenUserClass>();
    }

    public void handleClass(final ClassType c) throws TaskException {
        GenClass genClass = this.generatorModel.getClassMapping().get(c);
        genClass.accept(new GenClassVisitorException<TaskException>(){

            @Override
            public void handle(GenClassClass classClass) throws TaskException {
            }

            @Override
            public void handle(GenInterfaceClass interfaceClass) throws TaskException {
                interfaceClass.accept(new GenInterfaceClassVisitorException<TaskException>(){

                    @Override
                    public void handle(GenSimpleInterfaceClass simpleInterface) throws TaskException {
                    }

                    @Override
                    public void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) throws TaskException {
                        ConstructorCallGenerationTask.this.handleGenInterfaceWithClassImplClass(c, interfaceWithImplClass);
                    }

                    @Override
                    public void handle(GenExternalInterfaceClass iface) throws TaskException {
                    }
                });
            }

            @Override
            public void handle(GenPrimitiveClass primitiveClass) {
            }
        });
    }

    private void handleGenInterfaceWithClassImplClass(ClassType c, GenInterfaceWithClassImplClass interfaceClass) throws TaskException {
        GenUserClass genClassClass = interfaceClass.getClassRepresentation();
        LinkedList<Type> typesToInstantiate = this.callOrder.containsKey(c) ? this.callOrder.get(c) : new LinkedList<Type>();
        int superMethodNumber = 0;
        Collection constructors = c.getConstructors();
        for (Constructor constructor : constructors) {
            this.generateConstructorAndSuper(genClassClass, interfaceClass, constructor.getParameters(), constructor.getSuperConstructors(), typesToInstantiate, ++superMethodNumber);
        }
        this.generateSetThis(genClassClass, interfaceClass, typesToInstantiate);
    }

    private void generateSetThis(GenClassClass genClassClass, GenInterfaceWithClassImplClass interfaceClass, List<Type> typesToInstantiate) throws GenTypeNotReferencedException {
        StringBuilder setThisMethodBuilder = new StringBuilder("this.This=This;");
        for (Type superType : typesToInstantiate) {
            GenType genType = this.generatorModel.getGenTypeForType(superType);
            String typeName = genType.getFullyQualifiedTypeName();
            String typeNameImpl = typeName + "$Impl";
            String typeNameImplShort = typeNameImpl.substring(typeNameImpl.lastIndexOf(46) + 1);
            String innerPackage = typeName + "_InnerPackage." + typeNameImplShort;
            setThisMethodBuilder.append("\n\t\t");
            setThisMethodBuilder.append("((");
            setThisMethodBuilder.append(innerPackage);
            setThisMethodBuilder.append(")");
            setThisMethodBuilder.append("$generatedObjects.get(new de.fhdw.wtf.context.model.Str(\"");
            setThisMethodBuilder.append(innerPackage);
            setThisMethodBuilder.append("\"))).setThis(this);");
        }
        Vector<GenParameter> setThisParams = new Vector<GenParameter>();
        setThisParams.add(GenParameter.create("This", GenTypeReferenceByName.create(interfaceClass.getFullyQualifiedTypeName())));
        GenJavaOperation setThisOperation = GenJavaOperation.create("setThis", setThisParams, GenFullParsedOperationState.create(GenComment.create("/**\n\t * Sets This.\n\t **/"), new Vector<GenException>(), GenTypeReferenceByName.create(GenVoidType.getInstance().getFullyQualifiedTypeName()), new Vector<GenOperationModifier>(), GenVisibility.PUBLIC, setThisMethodBuilder.toString()));
        genClassClass.addOperation(setThisOperation);
    }

    private void generateConstructorAndSuper(GenClassClass genClassClass, GenInterfaceClass interfaceClass, ProductType parameters, Collection<ConstructorReference> superConstructors, List<Type> typesToInstantiate, int superMethodNumber) throws TaskException {
        GenParameter generatedObjects = GenParameter.create("$generatedObjects", GenMutableMap.create(GenStringType.getInstance(), GenAnyType.getInstance()));
        List<GenParameter> genParameters = this.createGenParameters(parameters);
        LinkedList<GenParameter> genParametersWithMap = new LinkedList<GenParameter>();
        genParametersWithMap.add(generatedObjects);
        genParametersWithMap.addAll(genParameters);
        String prefix = genParameters.isEmpty() ? "" : ", ";
        this.generateConstructor(genClassClass, genParameters, "this(new de.fhdw.wtf.context.model.collections.MutableMap<de.fhdw.wtf.context.model.Str,de.fhdw.wtf.context.model.AnyType>()" + this.generateParameterString(prefix, genParameters) + ";", GenVisibility.PUBLIC);
        this.generateConstructor(genClassClass, genParametersWithMap, this.generateSuperCall(genParametersWithMap), GenVisibility.PUBLIC);
        this.generateSuper(genClassClass, interfaceClass, genParametersWithMap, genParameters, superConstructors, typesToInstantiate, superMethodNumber);
    }

    private void generateSuper(GenClassClass genClassClass, GenInterfaceClass interfaceClass, List<GenParameter> genParametersWithMap, List<GenParameter> genParametersWithoutMap, Collection<ConstructorReference> superConstructors, List<Type> typesToInstantiate, int superMethodNumber) throws TaskException {
        StringBuilder superMethodBuilder = new StringBuilder();
        int superTypeNumber = 0;
        Iterator<Type> superTypes = typesToInstantiate.iterator();
        while (superTypes.hasNext()) {
            ++superTypeNumber;
            Type superType = superTypes.next();
            GenType genType = this.generatorModel.getGenTypeForType(superType);
            Constructor constructorToCall = this.getConstructorForType(superType, superConstructors);
            List<GenParameter> constructorParametersWithoutMap = this.createGenParameters(constructorToCall.getParameters());
            String typeName = genType.getFullyQualifiedTypeName();
            String tupleName = "tuple_" + superMethodNumber + "_" + superTypeNumber;
            String typeNameImpl = typeName + "$Impl";
            String typeNameImplShort = typeNameImpl.substring(typeNameImpl.lastIndexOf(46) + 1);
            String innerPackage = typeName + "_InnerPackage." + typeNameImplShort;
            superMethodBuilder.append("if ($generatedObjects.get(new de.fhdw.wtf.context.model.Str(\"");
            superMethodBuilder.append(innerPackage);
            superMethodBuilder.append("\"))==null){\n\t\t\t\t");
            if (!constructorParametersWithoutMap.isEmpty()) {
                superMethodBuilder.append(this.generateTupleInstantiationStringAndTupleClassAndTupleGetter(genClassClass, tupleName, typeName, constructorParametersWithoutMap, genParametersWithoutMap, superMethodNumber, superTypeNumber));
                superMethodBuilder.append("\n\t\t\t\t");
            }
            superMethodBuilder.append("this.$generatedObjects.put(new de.fhdw.wtf.context.model.Str(\"");
            superMethodBuilder.append(innerPackage);
            superMethodBuilder.append("\")");
            superMethodBuilder.append(", ");
            superMethodBuilder.append("new ");
            superMethodBuilder.append(innerPackage);
            superMethodBuilder.append("(");
            superMethodBuilder.append("$generatedObjects");
            if (!constructorParametersWithoutMap.isEmpty()) {
                superMethodBuilder.append(", ");
                superMethodBuilder.append(this.generateTupleGetterAndCallString(tupleName, constructorParametersWithoutMap));
            } else {
                superMethodBuilder.append(")");
            }
            superMethodBuilder.append(");");
            superMethodBuilder.append("\n\t\t\t}\n\t\t");
            superMethodBuilder.append("else{\n\t\t\t\t");
            superMethodBuilder.append("this.$generatedObjects.put(new de.fhdw.wtf.context.model.Str(\"");
            superMethodBuilder.append(innerPackage);
            superMethodBuilder.append("\")");
            superMethodBuilder.append(", ");
            superMethodBuilder.append("$generatedObjects.get(new de.fhdw.wtf.context.model.Str(\"");
            superMethodBuilder.append(innerPackage);
            superMethodBuilder.append("\")));\n\t\t\t}\n\t\t");
        }
        superMethodBuilder.append("this.$generatedObjects.put(new de.fhdw.wtf.context.model.Str(\"");
        superMethodBuilder.append(genClassClass.getFullyQualifiedTypeName());
        superMethodBuilder.append("\"),this);");
        superMethodBuilder.append("\n\t\t");
        superMethodBuilder.append("$generatedObjects.put(new de.fhdw.wtf.context.model.Str(\"");
        superMethodBuilder.append(genClassClass.getFullyQualifiedTypeName());
        superMethodBuilder.append("\"),this);");
        superMethodBuilder.append("\n\t\t");
        superMethodBuilder.append("this.setThis(this);");
        GenJavaOperation superOperation = GenJavaOperation.create("$super", GenVisibility.PRIVATE, genParametersWithMap, new LinkedList<GenException>(), superMethodBuilder.toString(), GenVoidType.getInstance(), new LinkedList<GenOperationModifier>(), GenComment.create("/**\n\t * Instantiates objects for the super types of this class.\n\t **/"));
        genClassClass.addOperation(superOperation);
    }

    private String generateTupleInstantiationStringAndTupleClassAndTupleGetter(GenClassClass genClassClass, String tupleName, String superTypeName, List<GenParameter> constructorParametersWithoutMap, List<GenParameter> genParametersWithoutMap, int superMethodNumber, int superTypeNumber) {
        StringBuilder resultStringBuilder = new StringBuilder();
        StringBuilder genericListStringBuilder = new StringBuilder();
        Iterator<GenParameter> parameters = constructorParametersWithoutMap.iterator();
        while (parameters.hasNext()) {
            GenParameter current = parameters.next();
            genericListStringBuilder.append(current.getTyp().getFullyQualifiedNameWithGenericArguments());
            if (!parameters.hasNext()) continue;
            genericListStringBuilder.append(", ");
        }
        int genericCount = constructorParametersWithoutMap.size();
        String superParameterString = this.generateParameterString("", genParametersWithoutMap);
        String genericString = "<" + genericListStringBuilder.toString() + "> ";
        String tupleTypePrefix = "generated.Tuple" + genericCount;
        String tupleTypeString = tupleTypePrefix + genericString;
        String getterName = "getTuple_" + superMethodNumber + "_" + superTypeNumber;
        resultStringBuilder.append(tupleTypeString);
        resultStringBuilder.append(tupleName);
        resultStringBuilder.append(" = ");
        resultStringBuilder.append("this.");
        resultStringBuilder.append(getterName);
        resultStringBuilder.append("(");
        resultStringBuilder.append(superParameterString);
        resultStringBuilder.append(";");
        GenUserClass tuple = this.generateTupleClass(genericCount);
        this.generateTupleGetterMethod(genClassClass, getterName, genParametersWithoutMap, constructorParametersWithoutMap, tupleTypeString, tupleTypePrefix, genericString, tuple, superTypeName);
        return resultStringBuilder.toString();
    }

    private GenUserClass generateTupleClass(int genericCount) {
        if (this.genericTuplesToGenerate.containsKey(genericCount)) {
            return this.genericTuplesToGenerate.get(genericCount);
        }
        Vector<Generic> generics = new Vector<Generic>();
        Vector<GenJavaOperation> operations = new Vector<GenJavaOperation>();
        Vector<GenJavaAttribute> attributes = new Vector<GenJavaAttribute>();
        Vector<GenParameter> constructorParameters = new Vector<GenParameter>();
        StringBuilder constructorMethodBuilder = new StringBuilder();
        for (int i = 1; i <= genericCount; ++i) {
            String genericTypeName = "ValueType" + i;
            String genericAttributeNameSuffix = "alue" + i;
            String genericAttributeName = "v" + genericAttributeNameSuffix;
            String genericOperationNameSuffix = "V" + genericAttributeNameSuffix;
            Generic generic = Generic.create(genericTypeName, GenHasNoGenericType.create());
            generics.add(generic);
            GenJavaOperation operation = GenJavaOperation.create("get" + genericOperationNameSuffix, new Vector<GenParameter>(), GenFullParsedOperationState.create(GenComment.create("/**\n\t * Returns the value of type " + genericTypeName + ".\n\t **/"), new Vector<GenException>(), GenTypeReferenceByReference.create(generic), new Vector<GenOperationModifier>(), GenVisibility.PUBLIC, "return this." + genericAttributeName + ";"));
            operations.add(operation);
            GenJavaAttribute attribute = GenJavaAttribute.create(genericAttributeName, GenVisibility.PRIVATE, generic, new Vector<GenAttributeModifier>());
            attributes.add(attribute);
            GenParameter parameter = GenParameter.create(genericAttributeName, generic);
            constructorParameters.add(parameter);
            constructorMethodBuilder.append("this." + genericAttributeName + " = " + genericAttributeName + ";\n\t\t\t");
        }
        GenUserClass tuple = GenUserClass.create("Tuple" + genericCount, operations, new Vector<GenInterfaceClass>(), attributes, new Vector<GenClassModifier>(), new Vector<GenJavaOperation>(), null, GenUnqualifiedPackage.create("generated"), GenComment.create("/**\n* A tuple with " + genericCount + " generic fields.\n**/"), "");
        tuple.getGenerics().addAll(generics);
        GenJavaOperation constructor = GenJavaOperation.create("", constructorParameters, GenFullParsedOperationState.create(GenComment.create("/**\n\t * Creates a new Tuple" + genericCount + ".\n\t **/"), new Vector<GenException>(), GenTypeReferenceByReference.create(tuple), new Vector<GenOperationModifier>(), GenVisibility.PUBLIC, constructorMethodBuilder.toString()));
        tuple.getConstructors().add(constructor);
        this.generatorModel.addNonAstClass(tuple);
        this.genericTuplesToGenerate.put(genericCount, tuple);
        return tuple;
    }

    private void generateTupleGetterMethod(GenClassClass genClassClass, String getterName, List<GenParameter> genParametersWithoutMap, List<GenParameter> constructorParametersWithoutMap, String tupleTypeString, String tupleTypePrefix, String genericString, GenType returnType, String superTypeName) {
        StringBuilder methodStringBuilder = new StringBuilder("//TODO replace the following null values with your desired values for the constructor of the super type " + superTypeName);
        methodStringBuilder.append("\n\t\t");
        methodStringBuilder.append(tupleTypeString);
        methodStringBuilder.append(" tuple ");
        methodStringBuilder.append("= new ");
        methodStringBuilder.append(tupleTypePrefix);
        methodStringBuilder.append("<>(" + this.generateNullStringWithCasts(constructorParametersWithoutMap) + ");");
        methodStringBuilder.append("\n\t\treturn tuple;");
        GenJavaOperation tupleGetterMethod = GenJavaOperation.create(genericString + " " + getterName, genParametersWithoutMap, GenFullParsedOperationState.create(GenComment.create("/**\n\t * Returns a tuple with the parameters for a super constructor.\n\t * The name of this operation describes the signature of said constructor.\n\t **/"), new Vector<GenException>(), GenTypeReferenceByReference.create(returnType), new Vector<GenOperationModifier>(), GenVisibility.PRIVATE, methodStringBuilder.toString()));
        genClassClass.addOperation(tupleGetterMethod);
    }

    private String generateNullStringWithCasts(List<GenParameter> constructorParametersWithoutMap) {
        StringBuilder resultBuilder = new StringBuilder();
        Iterator<GenParameter> parameters = constructorParametersWithoutMap.iterator();
        while (parameters.hasNext()) {
            resultBuilder.append("(");
            resultBuilder.append(parameters.next().getTyp().getFullyQualifiedNameWithGenericArguments());
            resultBuilder.append(") null");
            if (!parameters.hasNext()) continue;
            resultBuilder.append(",");
        }
        return resultBuilder.toString();
    }

    private Constructor getConstructorForType(Type superType, Collection<ConstructorReference> superConstructors) throws TaskException {
        if (superConstructors.isEmpty()) {
            return Constructor.create((ProductType)ProductType.create((Token)DummyToken.getInstance()), (ClassType)this.getTypeAsClassType(superType), new LinkedList(), (Token)DummyToken.getInstance(), (Token)DummyToken.getInstance());
        }
        Iterator<ConstructorReference> constructorReferences = superConstructors.iterator();
        boolean found = false;
        Constructor constructor = null;
        while (!found && constructorReferences.hasNext()) {
            constructor = this.getConstructorFromConstructorReference(constructorReferences.next());
            found = constructor.getReturnType().equals((Object)superType);
        }
        if (!found) {
            throw new TaskException("ConstructorCallGenerationTask: No constructor found while trying to generate code snipped for: " + superType + " in $super!");
        }
        return constructor;
    }

    private ClassType getTypeAsClassType(Type superType) throws TaskException {
        return (ClassType)superType.accept((TypeVisitorReturnException)new ClassTypeFinder());
    }

    private Constructor getConstructorFromConstructorReference(ConstructorReference reference) throws TaskException {
        String exceptionMessage = "ConstructorCallGenerationTask: ConstructorReference needs to be in ConstructorByReferenceState at this point. Current state: ";
        return (Constructor)reference.getState().accept((ConstructorReferenceStateVisitorReturnException)new ConstructorReferenceStateVisitorReturnException<Constructor, TaskException>(){

            public Constructor handle(ConstructorByTypeAndSignatureState byName) throws TaskException {
                throw new TaskException("ConstructorCallGenerationTask: ConstructorReference needs to be in ConstructorByReferenceState at this point. Current state: " + byName);
            }

            public Constructor handle(ConstructorInvalidState invalid) throws TaskException {
                throw new TaskException("ConstructorCallGenerationTask: ConstructorReference needs to be in ConstructorByReferenceState at this point. Current state: " + invalid);
            }

            public Constructor handle(ConstructorByReferenceState byReference) {
                return byReference.getTarget();
            }
        });
    }

    private List<GenParameter> createGenParameters(ProductType parameters) throws GenTypeNotReferencedException {
        List elements = parameters.getElements();
        LinkedList<GenParameter> result = new LinkedList<GenParameter>();
        for (ProductElementType productElement : elements) {
            GenType paramType = this.generatorModel.getGenTypeForType(productElement.getType());
            result.add(GenParameter.create(productElement.getName(), paramType));
        }
        return result;
    }

    private void generateConstructor(GenClassClass genClassClass, List<GenParameter> genParameters, String methodBody, GenVisibility visibility) {
        GenComment comment = GenComment.create("/** \n\t * Creates an instance of type " + genClassClass.getName() + "\n\t **/");
        GenJavaOperation constructorWithMap = GenJavaOperation.create("", visibility, genParameters, new Vector<GenException>(), methodBody, genClassClass, new Vector<GenOperationModifier>(), comment);
        genClassClass.addConstructor(constructorWithMap);
    }

    private String generateSuperCall(List<GenParameter> genParameters) {
        return "this.$super(" + this.generateParameterString("", genParameters) + ";";
    }

    private String generateParameterString(String prefix, List<GenParameter> genParameters) {
        StringBuilder superCall = new StringBuilder(prefix);
        Iterator<GenParameter> parameterIterator = genParameters.iterator();
        while (parameterIterator.hasNext()) {
            GenParameter parameter = parameterIterator.next();
            superCall.append(parameter.getName());
            if (!parameterIterator.hasNext()) continue;
            superCall.append(", ");
        }
        superCall.append(")");
        return superCall.toString();
    }

    private String generateTupleGetterAndCallString(String tupleName, List<GenParameter> constructorParametersWithoutMap) {
        StringBuilder call = new StringBuilder();
        int genericFieldCount = 0;
        Iterator<GenParameter> parameters = constructorParametersWithoutMap.iterator();
        while (parameters.hasNext()) {
            ++genericFieldCount;
            GenParameter current = parameters.next();
            call.append(tupleName);
            call.append(".<");
            call.append(current.getTyp().getFullyQualifiedNameWithGenericArguments());
            call.append(">getValue");
            call.append(genericFieldCount);
            call.append("(");
            call.append(")");
            if (!parameters.hasNext()) continue;
            call.append(", ");
        }
        call.append(")");
        return call.toString();
    }

    public void handleGroup(Group g) throws TaskException {
    }

    public void handleAttribute(Attribute a, ClassType owner) throws TaskException {
    }

    public void handleConstructorOrOperation(ConstructorOrOperation coo, ClassType owner) throws TaskException {
    }

    public void finalizeTask() throws TaskException {
    }

    public void beginTask() throws TaskException {
    }

    private static class ClassTypeFinder
    implements TypeVisitorReturnException<ClassType, TaskException> {
        private ClassTypeFinder() {
        }

        public ClassType handle(AtomicType atomicType) throws TaskException {
            return (ClassType)atomicType.accept((AtomicTypeVisitorReturnException)new AtomicTypeVisitorReturnException<ClassType, TaskException>(){

                public ClassType handle(BaseType baseType) throws TaskException {
                    throw new TaskException("ConstructorCallGenerationTask: No BaseType allowed here!");
                }

                public ClassType handle(ClassType clazz) throws TaskException {
                    return clazz;
                }
            });
        }

        public ClassType handle(CompositeType compositeType) throws TaskException {
            throw new TaskException("ConstructorCallGenerationTask: No SumType allowed here!");
        }

        public ClassType handle(TypeProxy typeProxy) throws TaskException {
            return (ClassType)typeProxy.getTarget().accept((TypeVisitorReturnException)this);
        }
    }
}

