package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import de.fhdw.wtf.common.ast.Attribute;
import de.fhdw.wtf.common.ast.ConstructorOrOperation;
import de.fhdw.wtf.common.ast.Group;
import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReference;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitor;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitorReturn;
import de.fhdw.wtf.generator.transformer.exception.GenTypeNotReferencedException;
import de.fhdw.wtf.walker.walker.SimpleWalkerTask;

/**
 * Transformer who realizes the delegation pattern for the generated model.
 * 
 * @author hfw413sc
 *
 */
public class DelegationTransformer extends SimpleWalkerTask {
	
	/**
	 * The referenced generator model.
	 */
	private final GeneratorModel generatorModel;
	
	/**
	 * The list of root types of the model.
	 */
	private final List<ClassType> rootTypeList = new Vector<>();
	
	/**
	 * Creates a DelegationTransformer.
	 * 
	 * @param m
	 *            the model
	 * @param taskmanager
	 *            the taskmanager
	 * @param generatorModel
	 *            the generator model
	 */
	public DelegationTransformer(final Model m, final TaskExecutor taskmanager, final GeneratorModel generatorModel) {
		super(m, taskmanager);
		this.generatorModel = generatorModel;
	}
	
	@Override
	public void handleClass(final ClassType c) throws TaskException {
		final GenClass clazz = this.generatorModel.getJavaClassForWTFClass(c);
		clazz.accept(new GenClassVisitorException<GenTypeNotReferencedException>() {
			
			@Override
			public void handle(final GenClassClass classClass) throws GenTypeNotReferencedException {
				// nothing to do
				
			}
			
			@Override
			public void handle(final GenInterfaceClass interfaceClass) throws GenTypeNotReferencedException {
				interfaceClass.accept(new GenInterfaceClassVisitorException<GenTypeNotReferencedException>() {
					
					@Override
					public void handle(final GenSimpleInterfaceClass simpleInterface)
							throws GenTypeNotReferencedException {
						// nothing to do
					}
					
					@Override
					public void handle(final GenInterfaceWithClassImplClass interfaceWithImplClass)
							throws GenTypeNotReferencedException {
						if (DelegationTransformer.this.isInterfaceInheritanceRoot(interfaceWithImplClass)) {
							DelegationTransformer.this.addToRootTypeList(c);
						}
						
					}
					
					@Override
					public void handle(final GenExternalInterfaceClass iface) throws GenTypeNotReferencedException {
						// nothing to do
					}
				});
				
			}
			
			@Override
			public void handle(final GenPrimitiveClass primitiveClass) throws GenTypeNotReferencedException {
				// nothing to do
			}
		});
	}
	
	/**
	 * Adds the type rootType to rootTypeList.
	 * 
	 * @param rootType
	 *            type to be added
	 */
	private void addToRootTypeList(final ClassType rootType) {
		this.rootTypeList.add(rootType);
	}
	
	/**
	 * Returns true if checkInterface is directly extending Anything.
	 * 
	 * @param checkInterface
	 *            Interface to be checked
	 * @return true if checkInterface is a root of the inheritance
	 * @throws GenTypeNotReferencedException
	 *             possible exception
	 */
	private boolean isInterfaceInheritanceRoot(final GenInterfaceWithClassImplClass checkInterface)
			throws GenTypeNotReferencedException {
		return checkInterface.getImplement().contains(
				this.generatorModel.getGenTypeForType(this.getModel().getAnything()));
	}
	
	@Override
	public void handleGroup(final Group g) throws TaskException {
		// nothing to do
		
	}
	
	@Override
	public void handleAttribute(final Attribute a, final ClassType owner) throws TaskException {
		// nothing to do
		
	}
	
	@Override
	public void handleConstructorOrOperation(final ConstructorOrOperation coo, final ClassType owner)
			throws TaskException {
		// nothing to do
		
	}
	
	@Override
	public void finalizeTask() throws TaskException {
		this.generateDelegationPatternForInheritanceTree();
		
	}
	
	/**
	 * Generates the whole delegation code for the inheritance tree based on the private list rootTypeList.
	 */
	private void generateDelegationPatternForInheritanceTree() {
		for (final ClassType type : this.rootTypeList) {
			this.delegateOperationsInImplementingClasses(type);
		}
		
	}
	
	/**
	 * Generates the whole delegation code in all implementing classes of type.
	 * 
	 * @param type
	 *            super type for delegation code generation
	 */
	private void delegateOperationsInImplementingClasses(final ClassType type) {
		final GenClassVisitorReturn<GenInterfaceWithClassImplClass> genInterfaceWithClassImplClassReturnVisitor =
				new GenClassVisitorReturn<GenInterfaceWithClassImplClass>() {
					
					@Override
					public GenInterfaceWithClassImplClass handle(final GenClassClass classClass) {
						return null;
					}
					
					@Override
					public GenInterfaceWithClassImplClass handle(final GenInterfaceClass interfaceClass) {
						return interfaceClass
								.accept(new GenInterfaceClassVisitorReturn<GenInterfaceWithClassImplClass>() {
									
									@Override
									public GenInterfaceWithClassImplClass handle(final GenSimpleInterfaceClass simpleInterface) {
										return null;
									}
									
									@Override
									public GenInterfaceWithClassImplClass handle(final GenInterfaceWithClassImplClass interfaceWithImplClass) {
										return interfaceWithImplClass;
									}
									
									@Override
									public GenInterfaceWithClassImplClass handle(final GenExternalInterfaceClass iface) {
										return null;
									}
								});
					}
					
					@Override
					public GenInterfaceWithClassImplClass handle(final GenPrimitiveClass primitiveClass) {
						return null;
					}
				};
		final GenInterfaceWithClassImplClass superInterface =
				this.generatorModel.getJavaClassForWTFClass(type).accept(genInterfaceWithClassImplClassReturnVisitor);
		for (final ClassType sub : type.getSubTypes()) {
			final GenInterfaceWithClassImplClass subInterface =
					this.generatorModel.getJavaClassForWTFClass(sub)
							.accept(genInterfaceWithClassImplClassReturnVisitor);
			
			DelegationTransformer.this.delegateFromSuperToSub(
					superInterface.getClassRepresentation(),
					subInterface.getClassRepresentation());
			
			DelegationTransformer.this.delegateOperationsInImplementingClasses(sub);
		}
	}
	
	/**
	 * Adds everything necessary for inheritance delegation to the classes and the model for the inheritance between
	 * genSubClassClass and genSuperClassClass.
	 * 
	 * 
	 * @param superClass
	 *            superClass
	 * @param sub
	 *            subClass
	 * 
	 */
	private void delegateFromSuperToSub(final GenClassClass superClass, final GenClassClass sub) {
		
		final Iterator<GenJavaOperation> i = superClass.getOperations().iterator();
		while (i.hasNext()) {
			final GenJavaOperation genJavaOperation = i.next();
			
			boolean sameNameFound = false;
			
			final Iterator<GenJavaOperation> i2 = sub.getOperations().iterator();
			while (!sameNameFound && i2.hasNext()) {
				final GenJavaOperation genJavaOperation2 = i2.next();
				if (genJavaOperation.getName().equals("accept")) {
					sameNameFound = genJavaOperation2.toString().equals(genJavaOperation.toString());
				} else {
					sameNameFound = genJavaOperation2.getName().equals(genJavaOperation.getName());
				}
				
			}
			if (!sameNameFound) {
				
				genJavaOperation.getState().accept(new GenOperationStateVisitor() {
					
					@Override
					public void handle(final GenSimpleOperationState s) {
						// nothing to do
					}
					
					@Override
					public void handle(final GenFullParsedOperationState s) {
						if (s.getModifiers().contains(GenOperationModifier.ABSTRACT)) {
							DelegationTransformer.this.handleAbstractOperation(genJavaOperation, sub, superClass);
						} else {
							final GenJavaOperation operationWithDelegationMethod =
									DelegationTransformer.this.cloneAndChangeToDelegation(genJavaOperation, superClass);
							sub.addOperation(operationWithDelegationMethod);
						}
					}
				});
				
			}
		}
		
	}
	
	/**
	 * Handles abstract operation in subclass and superclass.
	 * 
	 * @param genJavaOperation
	 *            operation handled
	 * @param sub
	 *            subclass
	 * @param superClass
	 *            superclass
	 */
	private void handleAbstractOperation(final GenJavaOperation genJavaOperation,
			final GenClassClass sub,
			final GenClassClass superClass) {
		final String name = genJavaOperation.getName();
		final List<GenParameter> parameters = genJavaOperation.getParameters();
		final GenComment comment = genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<GenComment>() {
			
			@Override
			public GenComment handle(final GenSimpleOperationState s) {
				return null;
			}
			
			@Override
			public GenComment handle(final GenFullParsedOperationState s) {
				return s.getComment();
			}
		});
		final Collection<GenException> exceptions =
				genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<Collection<GenException>>() {
					
					@Override
					public Collection<GenException> handle(final GenSimpleOperationState s) {
						return null;
					}
					
					@Override
					public Collection<GenException> handle(final GenFullParsedOperationState s) {
						return s.getExceptions();
					}
				});
		final GenTypeReference returntyp =
				genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<GenTypeReference>() {
					
					@Override
					public GenTypeReference handle(final GenSimpleOperationState s) {
						return null;
					}
					
					@Override
					public GenTypeReference handle(final GenFullParsedOperationState s) {
						return s.getReturntyp();
					}
				});
		final Collection<GenOperationModifier> modifiers =
				genJavaOperation.getState().accept(
						new GenOperationStateVisitorReturn<Collection<GenOperationModifier>>() {
							
							@Override
							public Collection<GenOperationModifier> handle(final GenSimpleOperationState s) {
								return null;
							}
							
							@Override
							public Collection<GenOperationModifier> handle(final GenFullParsedOperationState s) {
								return s.getModifiers();
							}
						});
		final GenVisibility visibility =
				genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<GenVisibility>() {
					
					@Override
					public GenVisibility handle(final GenSimpleOperationState s) {
						return null;
					}
					
					@Override
					public GenVisibility handle(final GenFullParsedOperationState s) {
						return s.getVisibility();
					}
				});
		
		final String methodbodyForSub =
				"//TODO implement operation " + name
						+ (returntyp.getFullyQualifiedName().equals("void") ? "" : "\n\t\treturn null;");
		final GenFullParsedOperationState stateForSub =
				GenFullParsedOperationState.create(
						comment,
						exceptions,
						returntyp,
						modifiers,
						visibility,
						methodbodyForSub);
		final GenJavaOperation operationForSub = GenJavaOperation.create(name, parameters, stateForSub);
		sub.addOperation(operationForSub);
		
		final String methodbodyForSuper =
				(returntyp.getFullyQualifiedName().equals("void") ? "" : "return ") + "this.getThis()." + name + "();";
		final GenFullParsedOperationState stateForSuper =
				GenFullParsedOperationState.create(
						comment,
						exceptions,
						returntyp,
						modifiers,
						visibility,
						methodbodyForSuper);
		final GenJavaOperation operationForSuper = GenJavaOperation.create(name, parameters, stateForSuper);
		superClass.overrideExistingOperation(operationForSuper);
		
	}
	
	/**
	 * Copies the operation genJavaOperation and change method to delegation.
	 * 
	 * @param genJavaOperation
	 *            operation from superClass
	 * @param owner
	 *            needed for references
	 * @return operation with delegation method
	 */
	private GenJavaOperation cloneAndChangeToDelegation(final GenJavaOperation genJavaOperation,
			final GenClassClass owner) {
		final Collection<GenOperationModifier> modifiers = new Vector<>();
		modifiers.addAll(genJavaOperation.getState().accept(
				new GenOperationStateVisitorReturn<Collection<GenOperationModifier>>() {
					
					@Override
					public Collection<GenOperationModifier> handle(final GenSimpleOperationState s) {
						return null;
					}
					
					@Override
					public Collection<GenOperationModifier> handle(final GenFullParsedOperationState s) {
						return s.getModifiers();
					}
				}));
		final GenTypeReference returnType =
				genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<GenTypeReference>() {
					
					@Override
					public GenTypeReference handle(final GenSimpleOperationState s) {
						return null;
					}
					
					@Override
					public GenTypeReference handle(final GenFullParsedOperationState s) {
						return s.getReturntyp();
					}
				});
		String parameterNamesList = "";
		for (final GenParameter p : genJavaOperation.getParameters()) {
			parameterNamesList = parameterNamesList + ", " + p.getName();
		}
		if (parameterNamesList.length() > 0) {
			parameterNamesList = parameterNamesList.replaceFirst("," + " ", "");
		}
		final String methodbody =
				(returnType.getFullyQualifiedName().equals("void") ? "" : "return ") + "(("
						+ owner.getFullyQualifiedTypeName()
						+ ") this.get$generatedObjects().get(new de.fhdw.wtf.context.model.Str(\""
						+ owner.getFullyQualifiedTypeName() + "\")))." + genJavaOperation.getName() + "("
						+ parameterNamesList + ");";
		
		final GenJavaOperation result =
				GenJavaOperation.create(
						genJavaOperation.getName(),
						genJavaOperation.getParameters(),
						GenFullParsedOperationState.create(
								genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<GenComment>() {
									
									@Override
									public GenComment handle(final GenSimpleOperationState s) {
										return null;
									}
									
									@Override
									public GenComment handle(final GenFullParsedOperationState s) {
										return s.getComment();
									}
								}),
								genJavaOperation.getState().accept(
										new GenOperationStateVisitorReturn<Collection<GenException>>() {
											
											@Override
											public Collection<GenException> handle(final GenSimpleOperationState s) {
												return new Vector<>();
											}
											
											@Override
											public Collection<GenException> handle(final GenFullParsedOperationState s) {
												return s.getExceptions();
											}
										}),
								returnType,
								modifiers,
								genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<GenVisibility>() {
									
									@Override
									public GenVisibility handle(final GenSimpleOperationState s) {
										return GenVisibility.DEFAULT;
									}
									
									@Override
									public GenVisibility handle(final GenFullParsedOperationState s) {
										return s.getVisibility();
									}
								}),
								methodbody));
		result.getGenerics().addAll(genJavaOperation.getGenerics());
		return result;
	}
	
	@Override
	public void beginTask() throws TaskException {
		// nothing to do
		
	}
	
}
