/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.transformer.clipper.ClipToFileTask;
import java.util.Iterator;
import java.util.List;

public final class GenOperationSignature {
    private final String name;
    private final List<GenParameter> parameters;

    private GenOperationSignature(String name, List<GenParameter> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    public static GenOperationSignature create(String name, List<GenParameter> parameters) {
        return new GenOperationSignature(name, parameters);
    }

    public List<GenParameter> getParameters() {
        return this.parameters;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GenOperationSignature) {
            GenOperationSignature other = (GenOperationSignature)obj;
            if (this.getName().equals(other.getName())) {
                return GenOperationSignature.equalsParamTypes(this.getParameters(), other.getParameters());
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getParameters().hashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.name);
        result.append('(');
        if (!this.parameters.isEmpty()) {
            for (GenParameter param : this.parameters) {
                result.append(param);
                result.append(',');
            }
            result.deleteCharAt(result.length() - 1);
        }
        result.append(')');
        return result.toString();
    }

    public static boolean equalsParamTypes(List<GenParameter> a, List<GenParameter> b) {
        if (a.size() == b.size()) {
            Iterator<GenParameter> i = a.iterator();
            Iterator<GenParameter> j = b.iterator();
            while (i.hasNext()) {
                GenParameter currentI = i.next();
                if (!j.hasNext()) continue;
                GenParameter currentJ = j.next();
                if (ClipToFileTask.replaceIllegalChars(currentI.getTyp().getFullyQualifiedNameWithGenericArguments()).equals(ClipToFileTask.replaceIllegalChars(currentJ.getTyp().getFullyQualifiedNameWithGenericArguments()))) continue;
                return false;
            }
        }
        return true;
    }
}

