/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import de.fhdw.wtf.common.ast.Attribute;
import de.fhdw.wtf.common.ast.ConstructorOrOperation;
import de.fhdw.wtf.common.ast.Group;
import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReference;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitor;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitorReturn;
import de.fhdw.wtf.generator.transformer.exception.GenTypeNotReferencedException;
import de.fhdw.wtf.walker.walker.SimpleWalkerTask;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DelegationTransformer
extends SimpleWalkerTask {
    private final GeneratorModel generatorModel;
    private final List<ClassType> rootTypeList = new Vector<ClassType>();

    public DelegationTransformer(Model m, TaskExecutor taskmanager, GeneratorModel generatorModel) {
        super(m, taskmanager);
        this.generatorModel = generatorModel;
    }

    public void handleClass(final ClassType c) throws TaskException {
        GenClass clazz = this.generatorModel.getJavaClassForWTFClass((Type)c);
        clazz.accept(new GenClassVisitorException<GenTypeNotReferencedException>(){

            @Override
            public void handle(GenClassClass classClass) throws GenTypeNotReferencedException {
            }

            @Override
            public void handle(GenInterfaceClass interfaceClass) throws GenTypeNotReferencedException {
                interfaceClass.accept(new GenInterfaceClassVisitorException<GenTypeNotReferencedException>(){

                    @Override
                    public void handle(GenSimpleInterfaceClass simpleInterface) throws GenTypeNotReferencedException {
                    }

                    @Override
                    public void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) throws GenTypeNotReferencedException {
                        if (DelegationTransformer.this.isInterfaceInheritanceRoot(interfaceWithImplClass)) {
                            DelegationTransformer.this.addToRootTypeList(c);
                        }
                    }

                    @Override
                    public void handle(GenExternalInterfaceClass iface) throws GenTypeNotReferencedException {
                    }
                });
            }

            @Override
            public void handle(GenPrimitiveClass primitiveClass) throws GenTypeNotReferencedException {
            }
        });
    }

    private void addToRootTypeList(ClassType rootType) {
        this.rootTypeList.add(rootType);
    }

    private boolean isInterfaceInheritanceRoot(GenInterfaceWithClassImplClass checkInterface) throws GenTypeNotReferencedException {
        return checkInterface.getImplement().contains(this.generatorModel.getGenTypeForType((Type)this.getModel().getAnything()));
    }

    public void handleGroup(Group g) throws TaskException {
    }

    public void handleAttribute(Attribute a, ClassType owner) throws TaskException {
    }

    public void handleConstructorOrOperation(ConstructorOrOperation coo, ClassType owner) throws TaskException {
    }

    public void finalizeTask() throws TaskException {
        this.generateDelegationPatternForInheritanceTree();
    }

    private void generateDelegationPatternForInheritanceTree() {
        for (ClassType type : this.rootTypeList) {
            this.delegateOperationsInImplementingClasses(type);
        }
    }

    private void delegateOperationsInImplementingClasses(ClassType type) {
        GenClassVisitorReturn<GenInterfaceWithClassImplClass> genInterfaceWithClassImplClassReturnVisitor = new GenClassVisitorReturn<GenInterfaceWithClassImplClass>(){

            @Override
            public GenInterfaceWithClassImplClass handle(GenClassClass classClass) {
                return null;
            }

            @Override
            public GenInterfaceWithClassImplClass handle(GenInterfaceClass interfaceClass) {
                return interfaceClass.accept(new GenInterfaceClassVisitorReturn<GenInterfaceWithClassImplClass>(){

                    @Override
                    public GenInterfaceWithClassImplClass handle(GenSimpleInterfaceClass simpleInterface) {
                        return null;
                    }

                    @Override
                    public GenInterfaceWithClassImplClass handle(GenInterfaceWithClassImplClass interfaceWithImplClass) {
                        return interfaceWithImplClass;
                    }

                    @Override
                    public GenInterfaceWithClassImplClass handle(GenExternalInterfaceClass iface) {
                        return null;
                    }
                });
            }

            @Override
            public GenInterfaceWithClassImplClass handle(GenPrimitiveClass primitiveClass) {
                return null;
            }
        };
        GenInterfaceWithClassImplClass superInterface = this.generatorModel.getJavaClassForWTFClass((Type)type).accept(genInterfaceWithClassImplClassReturnVisitor);
        for (ClassType sub : type.getSubTypes()) {
            GenInterfaceWithClassImplClass subInterface = this.generatorModel.getJavaClassForWTFClass((Type)sub).accept(genInterfaceWithClassImplClassReturnVisitor);
            this.delegateFromSuperToSub(superInterface.getClassRepresentation(), subInterface.getClassRepresentation());
            this.delegateOperationsInImplementingClasses(sub);
        }
    }

    private void delegateFromSuperToSub(final GenClassClass superClass, final GenClassClass sub) {
        for (final GenJavaOperation genJavaOperation : superClass.getOperations()) {
            boolean sameNameFound = false;
            Iterator<GenJavaOperation> i2 = sub.getOperations().iterator();
            while (!sameNameFound && i2.hasNext()) {
                GenJavaOperation genJavaOperation2 = i2.next();
                if (genJavaOperation.getName().equals("accept")) {
                    sameNameFound = genJavaOperation2.toString().equals(genJavaOperation.toString());
                    continue;
                }
                sameNameFound = genJavaOperation2.getName().equals(genJavaOperation.getName());
            }
            if (sameNameFound) continue;
            genJavaOperation.getState().accept(new GenOperationStateVisitor(){

                @Override
                public void handle(GenSimpleOperationState s) {
                }

                @Override
                public void handle(GenFullParsedOperationState s) {
                    if (s.getModifiers().contains((Object)GenOperationModifier.ABSTRACT)) {
                        DelegationTransformer.this.handleAbstractOperation(genJavaOperation, sub, superClass);
                    } else {
                        GenJavaOperation operationWithDelegationMethod = DelegationTransformer.this.cloneAndChangeToDelegation(genJavaOperation, superClass);
                        sub.addOperation(operationWithDelegationMethod);
                    }
                }
            });
        }
    }

    private void handleAbstractOperation(GenJavaOperation genJavaOperation, GenClassClass sub, GenClassClass superClass) {
        String name = genJavaOperation.getName();
        List<GenParameter> parameters = genJavaOperation.getParameters();
        GenComment comment = genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<GenComment>(){

            @Override
            public GenComment handle(GenSimpleOperationState s) {
                return null;
            }

            @Override
            public GenComment handle(GenFullParsedOperationState s) {
                return s.getComment();
            }
        });
        Collection<GenException> exceptions = genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<Collection<GenException>>(){

            @Override
            public Collection<GenException> handle(GenSimpleOperationState s) {
                return null;
            }

            @Override
            public Collection<GenException> handle(GenFullParsedOperationState s) {
                return s.getExceptions();
            }
        });
        GenTypeReference returntyp = genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<GenTypeReference>(){

            @Override
            public GenTypeReference handle(GenSimpleOperationState s) {
                return null;
            }

            @Override
            public GenTypeReference handle(GenFullParsedOperationState s) {
                return s.getReturntyp();
            }
        });
        Collection<GenOperationModifier> modifiers = genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<Collection<GenOperationModifier>>(){

            @Override
            public Collection<GenOperationModifier> handle(GenSimpleOperationState s) {
                return null;
            }

            @Override
            public Collection<GenOperationModifier> handle(GenFullParsedOperationState s) {
                return s.getModifiers();
            }
        });
        GenVisibility visibility = genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<GenVisibility>(){

            @Override
            public GenVisibility handle(GenSimpleOperationState s) {
                return null;
            }

            @Override
            public GenVisibility handle(GenFullParsedOperationState s) {
                return s.getVisibility();
            }
        });
        String methodbodyForSub = "//TODO implement operation " + name + (returntyp.getFullyQualifiedName().equals("void") ? "" : "\n\t\treturn null;");
        GenFullParsedOperationState stateForSub = GenFullParsedOperationState.create(comment, exceptions, returntyp, modifiers, visibility, methodbodyForSub);
        GenJavaOperation operationForSub = GenJavaOperation.create(name, parameters, stateForSub);
        sub.addOperation(operationForSub);
        String methodbodyForSuper = (returntyp.getFullyQualifiedName().equals("void") ? "" : "return ") + "this.getThis()." + name + "();";
        GenFullParsedOperationState stateForSuper = GenFullParsedOperationState.create(comment, exceptions, returntyp, modifiers, visibility, methodbodyForSuper);
        GenJavaOperation operationForSuper = GenJavaOperation.create(name, parameters, stateForSuper);
        superClass.overrideExistingOperation(operationForSuper);
    }

    private GenJavaOperation cloneAndChangeToDelegation(GenJavaOperation genJavaOperation, GenClassClass owner) {
        Vector<GenOperationModifier> modifiers = new Vector<GenOperationModifier>();
        modifiers.addAll(genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<Collection<GenOperationModifier>>(){

            @Override
            public Collection<GenOperationModifier> handle(GenSimpleOperationState s) {
                return null;
            }

            @Override
            public Collection<GenOperationModifier> handle(GenFullParsedOperationState s) {
                return s.getModifiers();
            }
        }));
        GenTypeReference returnType = genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<GenTypeReference>(){

            @Override
            public GenTypeReference handle(GenSimpleOperationState s) {
                return null;
            }

            @Override
            public GenTypeReference handle(GenFullParsedOperationState s) {
                return s.getReturntyp();
            }
        });
        String parameterNamesList = "";
        for (GenParameter p : genJavaOperation.getParameters()) {
            parameterNamesList = parameterNamesList + ", " + p.getName();
        }
        if (parameterNamesList.length() > 0) {
            parameterNamesList = parameterNamesList.replaceFirst(", ", "");
        }
        String methodbody = (returnType.getFullyQualifiedName().equals("void") ? "" : "return ") + "((" + owner.getFullyQualifiedTypeName() + ") this.get$generatedObjects().get(new de.fhdw.wtf.context.model.Str(\"" + owner.getFullyQualifiedTypeName() + "\")))." + genJavaOperation.getName() + "(" + parameterNamesList + ");";
        GenJavaOperation result = GenJavaOperation.create(genJavaOperation.getName(), genJavaOperation.getParameters(), GenFullParsedOperationState.create(genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<GenComment>(){

            @Override
            public GenComment handle(GenSimpleOperationState s) {
                return null;
            }

            @Override
            public GenComment handle(GenFullParsedOperationState s) {
                return s.getComment();
            }
        }), genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<Collection<GenException>>(){

            @Override
            public Collection<GenException> handle(GenSimpleOperationState s) {
                return new Vector<GenException>();
            }

            @Override
            public Collection<GenException> handle(GenFullParsedOperationState s) {
                return s.getExceptions();
            }
        }), returnType, modifiers, genJavaOperation.getState().accept(new GenOperationStateVisitorReturn<GenVisibility>(){

            @Override
            public GenVisibility handle(GenSimpleOperationState s) {
                return GenVisibility.DEFAULT;
            }

            @Override
            public GenVisibility handle(GenFullParsedOperationState s) {
                return s.getVisibility();
            }
        }), methodbody));
        result.getGenerics().addAll(genJavaOperation.getGenerics());
        return result;
    }

    public void beginTask() throws TaskException {
    }
}

