/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import de.fhdw.wtf.common.exception.walker.CyclicDependencyException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.DependencyTask;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.facade.PackageConstants;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenUnqualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.java.walker.SimpleGeneratorModelWalkerTask;
import java.util.Vector;

public class FactoryTransformer
extends SimpleGeneratorModelWalkerTask {
    private static final String DEFAULT_PARAMETER_VALUE = "null";
    private final GenClassClass userObjectFactory;

    public FactoryTransformer(TaskExecutor taskmanager, GeneratorModel javaGeneratorModel, DependencyTask inheritanceTransformer) {
        super(taskmanager, javaGeneratorModel);
        GenUnqualifiedPackage packag = GenUnqualifiedPackage.create("de");
        GenPackage packag1 = ((GenPackage)packag).addName("fhdw");
        GenPackage packag2 = packag1.addName("wtf");
        GenPackage packag3 = packag2.addName("context");
        GenPackage packag4 = packag3.addName("model");
        GenUserClass userClass = GenUserClass.create("UserObjectFactory", new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), new Vector<GenJavaAttribute>(), new Vector<GenClassModifier>(), new Vector<GenJavaOperation>(), null, packag4, GenComment.create(""), "");
        this.userObjectFactory = userClass;
        try {
            this.addDependency(inheritanceTransformer);
        }
        catch (CyclicDependencyException e) {
            e.printStackTrace();
            throw new Error("Dependency tasks are cyclic in FactoryTransformer.");
        }
    }

    @Override
    public void finalizeTask() throws TaskException {
    }

    @Override
    public void handleClassClass(GenClassClass cc) throws TaskException {
        if (!cc.getModifieres().contains((Object)GenClassModifier.ABSTRACT) && (cc.getFullyQualifiedTypeName().startsWith("generated.model.") || cc.getFullyQualifiedTypeName().startsWith("generated.products."))) {
            this.generateFactory(cc, cc);
        }
    }

    @Override
    public void handleInterfaceClass(GenInterfaceClass ic) throws TaskException {
        ic.accept(new GenInterfaceClassVisitorException<TaskException>(){

            @Override
            public void handle(GenSimpleInterfaceClass simpleInterface) throws TaskException {
            }

            @Override
            public void handle(GenInterfaceWithClassImplClass iwc) throws TaskException {
                GenUserClass cc = iwc.getClassRepresentation();
                if (!cc.getModifieres().contains((Object)GenClassModifier.ABSTRACT) && cc.getFullyQualifiedTypeName().startsWith("generated.model.")) {
                    FactoryTransformer.this.generateFactory(iwc, iwc.getClassRepresentation());
                }
            }

            @Override
            public void handle(GenExternalInterfaceClass iface) {
            }
        });
    }

    private void generateFactory(GenClass iface, GenClassClass impl) {
        GenUserClass factory = GenUserClass.create(iface.getName() + "Factory", new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), new Vector<GenJavaAttribute>(), new Vector<GenClassModifier>(), new Vector<GenJavaOperation>(), this.userObjectFactory, PackageConstants.FACTORY_PACKAGE, GenComment.createFromPlainText("Comment", false), "");
        Vector<GenParameter> parameters = new Vector<GenParameter>();
        parameters.add(GenParameter.create("userObject", GenExternalClassClass.getInstance("de.fhdw.wtf.persistence.meta.UserObject")));
        GenJavaOperation createSpecificUserType = GenJavaOperation.create("createSpecificUserType", GenVisibility.PROTECTED, parameters, new Vector<GenException>(), "return new " + impl.getFullyQualifiedTypeNameWithGenericArguments() + "(" + "userObject" + ");", GenExternalInterfaceClass.getInstance("de.fhdw.wtf.context.model.IAnyType"), new Vector<GenOperationModifier>(), GenComment.create("@Override"));
        factory.addOperation(createSpecificUserType);
        this.getGeneratorModel().addNonAstClass(factory);
    }

    public String toString() {
        return "Modelclass factory generation";
    }

    @Override
    public void handleOperation(GenOperation o) throws TaskException {
    }
}

