package de.fhdw.wtf.generator.java.generatorModel;

import java.util.Collection;

import de.fhdw.wtf.generator.java.visitor.GenClassClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenClassClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenClassClassVisitorReturn;

/**
 * A {@link de.fhdw.wtf.generator.java.generatorModel.GenUserClass GenUserClass} is a user defined {@link GenClassClass}
 * . It represents a non-base-class of the WTF-model.
 */
public final class GenUserClass extends GenClassClass {
	
	/**
	 * Instantiates a new GenUserClass.
	 * 
	 * @param name
	 *            The name of the class and the java-file to generate.
	 * @param attributes
	 *            The attribute the class has.
	 * @param operations
	 *            The operations the class has.
	 * @param modifiers
	 *            The class-modifiers for this class. For example "public".
	 * @param constructors
	 *            The constructor-operations for this class.
	 * @param implement
	 *            The interfaces the class implements.
	 * @param extend
	 *            The class the class extends.
	 * @param comment
	 *            The comment that describes this class.
	 * @param packag
	 *            The package the class will be generated in.
	 * @param nonGeneratedPart
	 *            Additional lines of code.
	 */
	private GenUserClass(final String name,
			final Collection<GenJavaOperation> operations,
			final Collection<GenInterfaceClass> implement,
			final Collection<GenJavaAttribute> attributes,
			final Collection<GenClassModifier> modifiers,
			final Collection<GenJavaOperation> constructors,
			final GenClassClass extend,
			final GenPackage packag,
			final GenComment comment,
			final String nonGeneratedPart) {
		super(name, operations, implement, attributes, modifiers, constructors, extend, packag, comment,
				nonGeneratedPart);
	}
	
	/**
	 * Creates a GenClassClass with for a Type with the given parameters.
	 * 
	 * @param name
	 *            The name of the class and the java-file to generate.
	 * @param attributes
	 *            The attribute the class has.
	 * @param operations
	 *            The operations the class has.
	 * @param modifiers
	 *            The class-modifiers for this class. For example "public".
	 * @param constructors
	 *            The constructor-operations for this class.
	 * @param implement
	 *            The interfaces the class implements.
	 * @param extend
	 *            The class the class extends.
	 * @param comment
	 *            The comment that describes this class.
	 * @param packag
	 *            The package the class will be generated in.
	 * @param nonGeneratedPart
	 *            Additional lines of code.
	 * @return Returns a new GenUserClass with the given parameters.
	 */
	public static GenUserClass create(final String name,
			final Collection<GenJavaOperation> operations,
			final Collection<GenInterfaceClass> implement,
			final Collection<GenJavaAttribute> attributes,
			final Collection<GenClassModifier> modifiers,
			final Collection<GenJavaOperation> constructors,
			final GenClassClass extend,
			final GenPackage packag,
			final GenComment comment,
			final String nonGeneratedPart) {
		return new GenUserClass(name, operations, implement, attributes, modifiers, constructors, extend, packag,
				comment, nonGeneratedPart);
	}
	
	@Override
	public void accept(final GenClassClassVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenClassClassVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
	
	@Override
	public <Y extends Exception> void accept(final GenClassClassVisitorException<Y> visitor) throws Y {
		visitor.handle(this);
	}
}
