/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.facade;

import de.fhdw.wtf.common.ast.Name;
import de.fhdw.wtf.common.ast.UnqualifiedName;
import de.fhdw.wtf.common.ast.type.AtomicType;
import de.fhdw.wtf.common.ast.type.CompositeType;
import de.fhdw.wtf.common.ast.type.ListType;
import de.fhdw.wtf.common.ast.type.MapType;
import de.fhdw.wtf.common.ast.type.ProductElementType;
import de.fhdw.wtf.common.ast.type.ProductType;
import de.fhdw.wtf.common.ast.type.SumType;
import de.fhdw.wtf.common.ast.type.ThrownType;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.ast.type.TypeProxy;
import de.fhdw.wtf.common.ast.visitor.CompositeTypeVisitorReturn;
import de.fhdw.wtf.common.ast.visitor.CompositeTypeVisitorReturnException;
import de.fhdw.wtf.common.ast.visitor.TypeVisitorReturn;
import de.fhdw.wtf.common.ast.visitor.TypeVisitorReturnException;
import de.fhdw.wtf.common.token.DummyToken;
import de.fhdw.wtf.common.token.IdentifierToken;
import de.fhdw.wtf.common.token.Position;
import de.fhdw.wtf.facade.GeneratedNameTooLongException;
import de.fhdw.wtf.walker.walker.HelperUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TypeNameGenerator {
    public static final String SUM_BEGIN = "Sum$0";
    public static final String SUM_END = "$0$";
    public static final String SUM_SEPERATE_ELEMENT = "\u20ac_";
    public static final String PRODUCT_BEGIN = "Product$0";
    public static final String PRODUCT_END = "$0$";
    public static final String PRODUCT_SEPERATE_ATTRIBUTES = "\u20ac_";
    public static final String PRODUCT_SEPERATE_TYPE_AND_NAME = "\u20ac0";
    public static final String LIST_BEGIN = "List$_$";
    public static final String LIST_END = "$_$";
    public static final String THROWN_BEGIN = "Thrown$0";
    public static final String THROWN_END = "$!$";
    public static final String MAP_BEGIN = "Map$_$";
    public static final String MAP_END = "$_$";
    public static final String MAP_SEPERATE_KEY_AND_VALUE = "$";
    private static TypeNameGenerator instance;
    private static final Integer MAX_NAME_LENGTH;
    private final Map<Name, Name> userDefinedTypeNames = new HashMap<Name, Name>();

    public static synchronized TypeNameGenerator getInstance() {
        if (instance == null) {
            instance = new TypeNameGenerator();
        }
        return instance;
    }

    private TypeNameGenerator() {
    }

    public void defineTypeName(Name generateTypeName, Name userDefinedTypeName) {
        this.userDefinedTypeNames.put(generateTypeName, userDefinedTypeName);
    }

    public Integer getMaxNameLength() {
        return MAX_NAME_LENGTH;
    }

    public UnqualifiedName getTypeName(Type type) throws GeneratedNameTooLongException {
        UnqualifiedName name = (UnqualifiedName)type.accept((TypeVisitorReturnException)new GetTypeNameTypeVisitorReturnException());
        if (name.toString().length() > MAX_NAME_LENGTH) {
            throw new GeneratedNameTooLongException((Name)name);
        }
        return name;
    }

    public UnqualifiedName createName(String name) {
        return UnqualifiedName.create((IdentifierToken)IdentifierToken.create((String)name, (Position)DummyToken.getDummyPosition()));
    }

    static {
        MAX_NAME_LENGTH = 200;
    }

    private final class GetTypeNameTypeVisitorReturnException
    implements TypeVisitorReturnException<UnqualifiedName, GeneratedNameTooLongException> {
        private GetTypeNameTypeVisitorReturnException() {
        }

        public UnqualifiedName handle(AtomicType s) throws GeneratedNameTooLongException {
            return s.getTypeName().getLastAddedName();
        }

        public UnqualifiedName handle(CompositeType c) throws GeneratedNameTooLongException {
            return (UnqualifiedName)c.accept((CompositeTypeVisitorReturnException)new GetTypeNameCompositeTypeVisitorReturnException());
        }

        public UnqualifiedName handle(TypeProxy typeProxy) throws GeneratedNameTooLongException {
            return TypeNameGenerator.this.getTypeName((Type)HelperUtils.getTargetAtomicType((TypeProxy)typeProxy));
        }

        private final class GetTypeNameCompositeTypeVisitorReturnException
        implements CompositeTypeVisitorReturnException<UnqualifiedName, GeneratedNameTooLongException> {
            private GetTypeNameCompositeTypeVisitorReturnException() {
            }

            public UnqualifiedName handle(ListType list) throws GeneratedNameTooLongException {
                String name = TypeNameGenerator.LIST_BEGIN + TypeNameGenerator.this.getTypeName(list.getOf()).toString() + "$_$";
                return TypeNameGenerator.this.createName(name);
            }

            public UnqualifiedName handle(MapType map) throws GeneratedNameTooLongException {
                String name = TypeNameGenerator.MAP_BEGIN + TypeNameGenerator.this.getTypeName(map.getKey()).toString() + TypeNameGenerator.MAP_SEPERATE_KEY_AND_VALUE + TypeNameGenerator.this.getTypeName(map.getOf()).toString() + "$_$";
                return TypeNameGenerator.this.createName(name);
            }

            public UnqualifiedName handle(ProductType product) throws GeneratedNameTooLongException {
                StringBuilder name = new StringBuilder();
                name.append(TypeNameGenerator.PRODUCT_BEGIN);
                List elements = product.getElements();
                for (ProductElementType productElement : elements) {
                    name.append(productElement.getName());
                    name.append(TypeNameGenerator.PRODUCT_SEPERATE_TYPE_AND_NAME);
                    name.append(TypeNameGenerator.this.getTypeName(productElement.getType()).toString());
                    if (elements.indexOf(productElement) >= elements.size() - 1) continue;
                    name.append("\u20ac_");
                }
                name.append("$0$");
                return TypeNameGenerator.this.createName(name.toString());
            }

            public UnqualifiedName handle(SumType sum) throws GeneratedNameTooLongException {
                StringBuilder name = new StringBuilder();
                name.append(TypeNameGenerator.SUM_BEGIN);
                List elements = sum.getElements();
                for (Type type : elements) {
                    if (!((Boolean)type.accept((TypeVisitorReturn)new TypeVisitorReturn<Boolean>(){

                        public Boolean handle(AtomicType atomicType) {
                            return true;
                        }

                        public Boolean handle(CompositeType compositeType) {
                            return (Boolean)compositeType.accept((CompositeTypeVisitorReturn)new CompositeTypeVisitorReturn<Boolean>(){

                                public Boolean handle(ListType list) {
                                    return true;
                                }

                                public Boolean handle(MapType map) {
                                    return true;
                                }

                                public Boolean handle(ProductType product) {
                                    return true;
                                }

                                public Boolean handle(SumType sum) {
                                    return true;
                                }

                                public Boolean handle(ThrownType thrownType) {
                                    return false;
                                }
                            });
                        }

                        public Boolean handle(TypeProxy typeProxy) {
                            return true;
                        }
                    })).booleanValue()) continue;
                    if (!name.toString().equals(TypeNameGenerator.SUM_BEGIN)) {
                        name.append("\u20ac_");
                    }
                    name.append(TypeNameGenerator.this.getTypeName(type).toString());
                }
                name.append("$0$");
                return TypeNameGenerator.this.createName(name.toString());
            }

            public UnqualifiedName handle(ThrownType thrownType) throws GeneratedNameTooLongException {
                StringBuilder name = new StringBuilder();
                name.append(TypeNameGenerator.THROWN_BEGIN);
                name.append(TypeNameGenerator.this.getTypeName(thrownType.getUnderlyingType()).toString());
                name.append(TypeNameGenerator.THROWN_END);
                return TypeNameGenerator.this.createName(name.toString());
            }
        }
    }
}

