/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.database.tasks;

import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.exception.generation.NoTypeIdSetException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.database.generation.InitialGenerator;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.walker.walker.HelperUtils;
import de.fhdw.wtf.walker.walker.SimpleWalkerTaskForTypes;

public class SpecializationGenerationTask
extends SimpleWalkerTaskForTypes {
    private final InitialGenerator generator;

    public SpecializationGenerationTask(Model m, TaskExecutor man, InitialGenerator generator) {
        super(m, man);
        this.generator = generator;
    }

    public void handleType(Type c) throws TaskException {
        for (Type current : c.getSuperTypes()) {
            try {
                Type superType = HelperUtils.getReferencedType((Type)current);
                this.generator.createSpecialisation(superType.getTypeId().getId(), c.getTypeId().getId());
                this.generator.getClassFacade().finalizeSpecialization();
            }
            catch (NoTypeIdSetException | PersistenceException e) {
                throw new TaskException(e.getMessage());
            }
        }
    }

    public void finalizeTask() throws TaskException {
        try {
            this.generator.getClassFacade().finalizeSpecialization();
        }
        catch (PersistenceException e) {
            throw new TaskException((Exception)((Object)e));
        }
    }

    public void beginTask() throws TaskException {
    }
}

