/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.clipper;

import de.fhdw.wtf.common.exception.walker.CyclicDependencyException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.file.FileUtils;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationSignature;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReferenceByName;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.java.walker.SimpleGeneratorModelWalkerTask;
import de.fhdw.wtf.generator.transformer.clipper.ClipToFileTask;
import de.fhdw.wtf.generator.transformer.clipper.ClipperConfiguration;
import de.fhdw.wtf.generator.transformer.util.Tuple;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class LinkToGenClassTask
extends SimpleGeneratorModelWalkerTask {
    private static final String BREAK = "\n";
    private final ClipperConfiguration configuration;

    public LinkToGenClassTask(TaskExecutor taskmanager, GeneratorModel javaGeneratorModel, ClipperConfiguration configuration, ClipToFileTask clipperImport) {
        super(taskmanager, javaGeneratorModel);
        this.configuration = configuration;
        try {
            this.addDependency(clipperImport);
        }
        catch (CyclicDependencyException e) {
            e.printStackTrace();
            throw new Error("Dependency tasks are cyclic in ImportAllFromClipperTask.");
        }
    }

    private void handleType(final GenClass t) throws TaskException {
        final String filename = this.configuration.getRepoDirectoryRoot() + t.getFullyQualifiedTypeName().replace(".", "/");
        final File[] directoryListing = new File(filename).listFiles();
        if (directoryListing == null) {
            return;
        }
        t.accept(new GenClassVisitorException<TaskException>(){

            @Override
            public void handle(GenClassClass classClass) throws TaskException {
                LinkToGenClassTask.this.readClippedFile(directoryListing, filename, t);
            }

            @Override
            public void handle(GenInterfaceClass interfaceClass) throws TaskException {
                interfaceClass.accept(new GenInterfaceClassVisitorException<TaskException>(){

                    @Override
                    public void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) throws TaskException {
                        LinkToGenClassTask.this.readClippedFile(directoryListing, filename, t);
                        LinkToGenClassTask.this.handleType(interfaceWithImplClass.getClassRepresentation());
                    }

                    @Override
                    public void handle(GenSimpleInterfaceClass simpleInterface) throws TaskException {
                        LinkToGenClassTask.this.readClippedFile(directoryListing, filename, t);
                    }

                    @Override
                    public void handle(GenExternalInterfaceClass iface) throws TaskException {
                        throw new TaskException("Cannot restore contents of external interface " + iface.getFullyQualifiedTypeName());
                    }
                });
            }

            @Override
            public void handle(GenPrimitiveClass primitiveClass) throws TaskException {
                LinkToGenClassTask.this.readClippedFile(directoryListing, filename, t);
            }
        });
    }

    private void readClippedFile(File[] directoryListing, String filename, GenClass t) throws TaskException {
        block14: for (File file : directoryListing) {
            try {
                String fileName;
                if (file.isDirectory()) {
                    for (GenClassClass current : t.getInnerClasses()) {
                        if (!current.getName().equals(file.getName())) continue;
                        this.handleType(current);
                        continue block14;
                    }
                    continue;
                }
                String fileString = FileUtils.getFileString(file.getAbsolutePath());
                switch (fileName = file.getName()) {
                    case "#classcomment": {
                        t.setComment(GenComment.create(fileString));
                        break;
                    }
                    case "#protectedArea": {
                        t.setNonGeneratedPart(fileString);
                        break;
                    }
                    case "#errorFile": {
                        break;
                    }
                    case "#imports": {
                        t.setImports(BREAK + fileString + BREAK);
                        break;
                    }
                    default: {
                        if (fileName.startsWith("#attr#")) break;
                        if (fileName.startsWith("#constructor")) {
                            final GenJavaOperation constructor = GenJavaOperation.create(t.getName(), this.parseClipperFileName(fileName, true).getB(), GenSimpleOperationState.create(fileString));
                            t.accept(new GenClassVisitorException<TaskException>(){

                                @Override
                                public void handle(GenClassClass classClass) throws TaskException {
                                    LinkToGenClassTask.this.deleteConstructorLike(classClass.getConstructors(), constructor);
                                    classClass.getConstructors().add(constructor);
                                }

                                @Override
                                public void handle(GenInterfaceClass interfaceClass) throws TaskException {
                                    throw new TaskException("Clipper: Tried to add constructor to interface" + fileName);
                                }

                                @Override
                                public void handle(GenPrimitiveClass primitiveClass) throws TaskException {
                                }
                            });
                            break;
                        }
                        GenJavaOperation m = this.createNewMethod(fileName, fileString);
                        if (t.overrideExistingOperation(m)) continue block14;
                        t.tryToOverrideAbstractOperation(m);
                    }
                }
            }
            catch (IOException e) {
                throw new TaskException("Clipper: Retrieve method failed: " + filename);
            }
        }
    }

    private GenJavaOperation createNewMethod(String fileName, String fileString) {
        Tuple<String, List<GenParameter>> res = this.parseClipperFileName(fileName, false);
        GenJavaOperation newOperation = GenJavaOperation.create(res.getA(), res.getB(), GenSimpleOperationState.create(fileString));
        return newOperation;
    }

    private void deleteConstructorLike(Collection<GenJavaOperation> collection, GenJavaOperation constructor) {
        Iterator<GenJavaOperation> i = collection.iterator();
        while (i.hasNext()) {
            GenJavaOperation current = i.next();
            if (!GenOperationSignature.equalsParamTypes(current.getParameters(), constructor.getParameters())) continue;
            i.remove();
        }
    }

    private Tuple<String, List<GenParameter>> parseClipperFileName(String fileName, boolean constructor) {
        ArrayList<String> split = new ArrayList<String>(Arrays.asList(fileName.split("#")));
        if (constructor) {
            split.remove(0);
        }
        String name = (String)split.remove(0);
        ArrayList<GenParameter> result = new ArrayList<GenParameter>();
        for (String current : split) {
            GenTypeReferenceByName ref = GenTypeReferenceByName.create(current);
            GenParameter para = GenParameter.create("DUMMY-PARA-NAME", ref);
            result.add(para);
        }
        return new Tuple<String, List<GenParameter>>(name, result);
    }

    @Override
    public void handleClassClass(GenClassClass cc) throws TaskException {
        this.handleType(cc);
    }

    @Override
    public void handleInterfaceClass(GenInterfaceClass ic) throws TaskException {
        this.handleType(ic);
    }

    @Override
    public void finalizeTask() throws TaskException {
    }

    @Override
    public void handleOperation(GenOperation o) throws TaskException {
    }
}

