package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenCollectionType;
import de.fhdw.wtf.generator.java.generatorModel.GenDummyType;
import de.fhdw.wtf.generator.java.generatorModel.GenImportType;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaUtilCollection;
import de.fhdw.wtf.generator.java.generatorModel.GenMapType;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveType;
import de.fhdw.wtf.generator.java.generatorModel.Generic;

/**
 * This visitor handles all GenType-types. Maybe throws an exception.
 * 
 * @param <Y>
 *            The type of exception that can be thrown by handle-methods.
 */
public interface GenTypeVisitorException<Y extends Exception> {
	
	/**
	 * Handle method for objects of GenClass-type.
	 * 
	 * @param cla
	 *            GenClass to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenClass cla) throws Y;
	
	/**
	 * Handle method for objects of GenCollectionType-type.
	 * 
	 * @param collectionType
	 *            GenCollectionType to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenCollectionType collectionType) throws Y;
	
	/**
	 * Handle method for objects of GenPrimitiveType-type.
	 * 
	 * @param primitiveType
	 *            GenPrimitiveType to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenPrimitiveType primitiveType) throws Y;
	
	/**
	 * Handle method for objects of GenMapType-type.
	 * 
	 * @param mapType
	 *            GenMapType to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenMapType mapType) throws Y;
	
	/**
	 * Handle method for objects of GenImportType-type.
	 * 
	 * @param importType
	 *            GenImportType to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenImportType importType) throws Y;
	
	/**
	 * Handle method for objects of Generic-type.
	 * 
	 * @param generic
	 *            Generic to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(Generic generic) throws Y;
	
	/**
	 * Handle method for objects of GenDummyType-type.
	 * 
	 * @param dummy
	 *            GenDummyType to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenDummyType dummy) throws Y;
	
	/**
	 * Handle method for objects of GenJavaUtilCollection-type.
	 * 
	 * @param javaUtilCollection
	 *            GenJavaUtilCollection to handle.
	 * @throws Y
	 *             The exception that is thrown while handling.
	 */
	void handle(GenJavaUtilCollection javaUtilCollection) throws Y;
	
}
