/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.database.tasks;

import de.fhdw.wtf.common.ast.Attribute;
import de.fhdw.wtf.common.ast.ConstructorOrOperation;
import de.fhdw.wtf.common.ast.DatabaseIDSetState;
import de.fhdw.wtf.common.ast.DatabaseIDState;
import de.fhdw.wtf.common.ast.Group;
import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.type.AtomicType;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.ast.type.CompositeType;
import de.fhdw.wtf.common.ast.type.ListType;
import de.fhdw.wtf.common.ast.type.MapType;
import de.fhdw.wtf.common.ast.type.ProductType;
import de.fhdw.wtf.common.ast.type.SumType;
import de.fhdw.wtf.common.ast.type.ThrownType;
import de.fhdw.wtf.common.ast.type.TypeProxy;
import de.fhdw.wtf.common.ast.visitor.CompositeTypeVisitorException;
import de.fhdw.wtf.common.ast.visitor.TypeVisitorException;
import de.fhdw.wtf.common.exception.generation.NoTypeIdSetException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.context.model.collections.PersistentList;
import de.fhdw.wtf.context.model.collections.PersistentMap;
import de.fhdw.wtf.generator.database.generation.InitialGenerator;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.facade.TypeManager;
import de.fhdw.wtf.persistence.meta.Type;
import de.fhdw.wtf.persistence.meta.UnidirectionalAssociation;
import de.fhdw.wtf.walker.walker.HelperUtils;
import de.fhdw.wtf.walker.walker.SimpleWalkerTask;

public class AttributeGenerationTask
extends SimpleWalkerTask {
    private static final String THIS_ATTRIBUTE_NAME = "This";
    private static final String GENERATED_OBJECTS_ATTRIBUTE_NAME = "$generatedObjects";
    private final InitialGenerator generator;
    private Type persistentList;
    private Type persistentMap;

    public AttributeGenerationTask(Model m, TaskExecutor man, InitialGenerator generator) {
        super(m, man);
        this.generator = generator;
        this.persistentList = null;
        this.persistentMap = null;
    }

    public void handleAttribute(Attribute a, ClassType owner) throws TaskException {
        try {
            a.getAttrType().accept((TypeVisitorException)new AttributeTypeVisitor(a, owner));
        }
        catch (TaskException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskException(e);
        }
    }

    public void finalizeTask() {
    }

    public void handleConstructorOrOperation(ConstructorOrOperation coo, ClassType owner) throws TaskException {
    }

    public void handleGroup(Group g) throws TaskException {
    }

    public void handleClass(ClassType c) throws TaskException {
        try {
            long classId = c.getTypeId().getId();
            TypeManager typeManager = this.generator.getClassFacade().getTypeManager();
            if (!typeManager.existsType("de.fhdw.wtf.context.model.collections.MutableMap")) {
                this.generator.createClass("de.fhdw.wtf.context.model.collections.MutableMap", false, false);
            }
            this.generator.createUnidirectionalAssociation(THIS_ATTRIBUTE_NAME, false, false, classId, classId);
            this.generator.createUnidirectionalAssociation(GENERATED_OBJECTS_ATTRIBUTE_NAME, false, false, classId, this.generator.mapNameToType(PersistentMap.class.getName()).getId());
        }
        catch (NoTypeIdSetException | PersistenceException e) {
            throw new TaskException((Exception)e);
        }
    }

    public void beginTask() throws TaskException {
        this.persistentList = this.generator.mapNameToType(PersistentList.class.getName());
        this.persistentMap = this.generator.mapNameToType(PersistentMap.class.getName());
    }

    private class CompositeAttributeTypeVisitor
    implements CompositeTypeVisitorException<Exception> {
        private final Attribute a;
        private final ClassType owner;

        CompositeAttributeTypeVisitor(Attribute a, ClassType owner) {
            this.a = a;
            this.owner = owner;
        }

        public void handle(ListType list) throws Exception {
            UnidirectionalAssociation newAsso = AttributeGenerationTask.this.generator.createUnidirectionalAssociation(this.a.getName(), true, true, this.owner.getTypeId().getId(), AttributeGenerationTask.this.persistentList.getId());
            this.a.setAttributeId((DatabaseIDState)new DatabaseIDSetState(newAsso.getId()));
        }

        public void handle(MapType map) throws Exception {
            UnidirectionalAssociation newAsso = AttributeGenerationTask.this.generator.createUnidirectionalAssociation(this.a.getName(), true, true, this.owner.getTypeId().getId(), AttributeGenerationTask.this.persistentMap.getId());
            this.a.setAttributeId((DatabaseIDState)new DatabaseIDSetState(newAsso.getId()));
        }

        public void handle(ProductType product) throws Exception {
            UnidirectionalAssociation newAsso = AttributeGenerationTask.this.generator.createUnidirectionalAssociation(this.a.getName(), true, true, this.owner.getTypeId().getId(), product.getTypeId().getId());
            this.a.setAttributeId((DatabaseIDState)new DatabaseIDSetState(newAsso.getId()));
        }

        public void handle(SumType sum) throws Exception {
            UnidirectionalAssociation newAsso = AttributeGenerationTask.this.generator.createUnidirectionalAssociation(this.a.getName(), true, true, this.owner.getTypeId().getId(), sum.getTypeId().getId());
            this.a.setAttributeId((DatabaseIDState)new DatabaseIDSetState(newAsso.getId()));
        }

        public void handle(ThrownType thrownType) throws Exception {
            throw new TaskException("A type that should be thrown is not possible in an attribute.");
        }
    }

    private class AttributeTypeVisitor
    implements TypeVisitorException<Exception> {
        private final Attribute a;
        private final ClassType owner;

        AttributeTypeVisitor(Attribute a, ClassType owner) {
            this.a = a;
            this.owner = owner;
        }

        public void handle(AtomicType s) throws Exception {
            UnidirectionalAssociation newAsso = AttributeGenerationTask.this.generator.createUnidirectionalAssociation(this.a.getName(), true, true, this.owner.getTypeId().getId(), s.getTypeId().getId());
            this.a.setAttributeId((DatabaseIDState)new DatabaseIDSetState(newAsso.getId()));
        }

        public void handle(CompositeType c) throws Exception {
            c.accept((CompositeTypeVisitorException)new CompositeAttributeTypeVisitor(this.a, this.owner));
        }

        public void handle(TypeProxy s) throws Exception {
            HelperUtils.getReferencedType((de.fhdw.wtf.common.ast.type.Type)s).accept((TypeVisitorException)this);
        }
    }
}

