package de.fhdw.wtf.generator.transformer.visitorTransformation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.type.AtomicType;
import de.fhdw.wtf.common.ast.type.BaseType;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.ast.type.CompositeType;
import de.fhdw.wtf.common.ast.type.ListType;
import de.fhdw.wtf.common.ast.type.MapType;
import de.fhdw.wtf.common.ast.type.ProductType;
import de.fhdw.wtf.common.ast.type.SumType;
import de.fhdw.wtf.common.ast.type.ThrownType;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.ast.type.TypeProxy;
import de.fhdw.wtf.common.ast.visitor.AtomicTypeVisitorException;
import de.fhdw.wtf.common.ast.visitor.CompositeTypeVisitorException;
import de.fhdw.wtf.common.ast.visitor.TypeVisitorException;
import de.fhdw.wtf.common.exception.walker.CyclicDependencyException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.facade.PackageConstants;
import de.fhdw.wtf.generator.java.generatorModel.GenAspect;
import de.fhdw.wtf.generator.java.generatorModel.GenAspectOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenCollectionType;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenDummyType;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenHasGenericType;
import de.fhdw.wtf.generator.java.generatorModel.GenHasNoGenericType;
import de.fhdw.wtf.generator.java.generatorModel.GenImportType;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaException;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaUtilCollection;
import de.fhdw.wtf.generator.java.generatorModel.GenMapType;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveType;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenType;
import de.fhdw.wtf.generator.java.generatorModel.GenUnqualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.java.generatorModel.GenVoidType;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.generatorModel.Generic;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitor;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitorReturnException;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorReturn;
import de.fhdw.wtf.generator.transformer.exception.GenTypeNotReferencedException;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.InheritanceTransformer;
import de.fhdw.wtf.walker.walker.HelperUtils;
import de.fhdw.wtf.walker.walker.SimpleWalkerTaskForTypes;

public final class VisitorTypeTransformer extends SimpleWalkerTaskForTypes {
	
	private final GeneratorModel generatorModel;
	private GenException currentException = null;
	private GenType currentReturnType = null;
	private final Map<GenInterfaceClass, List<GenType>> handledTypes;
	
	private VisitorTypeTransformer(final Model m,
			final TaskExecutor taskmanager,
			final GeneratorModel genModel,
			final InheritanceTransformer inheritanceTransformer) {
		super(m, taskmanager, true);
		this.handledTypes = new HashMap<>();
		this.generatorModel = genModel;
		
		try {
			this.addDependency(inheritanceTransformer);
		} catch (final CyclicDependencyException e) {
			// should not happen
			e.printStackTrace();
			throw new Error("Dependency tasks are cyclic in VisitorTypeTransformer.");
		}
	}
	
	public static VisitorTypeTransformer create(final Model m,
			final TaskExecutor taskmanager,
			final GeneratorModel generatorModel,
			final InheritanceTransformer inheritanceTransformer) {
		return new VisitorTypeTransformer(m, taskmanager, generatorModel, inheritanceTransformer);
	}
	
	/**
	 * Processes a ClassType.
	 * 
	 * @param type
	 *            The class type.
	 */
	private void processClassType(final ClassType type) {
		if (UtilVisitorTransformer.isVisitable(type)) {
			this.createVisitorWithoutReturnAndException(type, true);
			this.createVisitorWithoutReturnAndException(type, false);
			this.createVisitorWithReturnWithoutException(type, true);
			this.createVisitorWithReturnWithoutException(type, false);
			this.createVisitorWithoutReturnWithException(type, true);
			this.createVisitorWithoutReturnWithException(type, false);
			this.createVisitorWitReturnAndException(type, false);
			this.createVisitorWitReturnAndException(type, true);
		}
	}
	
	/**
	 * Creates a new visitor with a return value and with exception. If <code>full</code> it will visitor for all
	 * concrete {@link Class} in the hierarchy of <code>c</code> The {@link GenInterfaceClass} of the visitor will be
	 * returned.
	 * 
	 * @param c
	 *            c
	 * @param full
	 *            If the value of full is true the returned name is for the complete hierarchy of c, otherwise for the
	 *            first hierarchy of c
	 */
	private void createVisitorWitReturnAndException(final ClassType c, final boolean full) {
		final String intName = this.getVisitorInterfaceName(c, full, true, true);
		final Vector<GenJavaOperation> operations = new Vector<>();
		GenPackage javaExceptionPackage = GenUnqualifiedPackage.create("java");
		javaExceptionPackage = javaExceptionPackage.addName("lang");
		final GenJavaException javaException = GenJavaException.createJavaException(javaExceptionPackage);
		final Generic genericException = Generic.create("Y", GenHasGenericType.create(javaException));
		final Generic genericReturn = Generic.create("X", GenHasNoGenericType.create());
		final GenComment visitorDefaultComment =
				GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_VISITOR_COMMENT, false);
		final Vector<GenInterfaceClass> impls = new Vector<>();
		final GenInterfaceClass visitorInterface =
				GenSimpleInterfaceClass.create(
						intName,
						operations,
						impls,
						PackageConstants.VISITOR_PACKAGE,
						visitorDefaultComment,
						"");
		visitorInterface.getGenerics().add(genericReturn);
		visitorInterface.getGenerics().add(genericException);
		final GenJavaOperation acceptOperation = this.createAcceptOperation(c, visitorInterface, genericReturn);
		acceptOperation.getGenerics().add(genericException);
		acceptOperation.getParameters().get(0).getGenerics().add(genericException);
		this.addException(acceptOperation, this.getGeneratorModelException(genericException));
		this.createVisitorWithReturnAndExceptionHandleOperations(
				c.getSubTypes(),
				visitorInterface,
				genericReturn,
				genericException,
				full);
		this.getGeneratorModel().addNonAstClass(visitorInterface);
		
	}
	
	/**
	 * Creates a new visitor without a return value and with exception. If <code>full</code> it will visitor for all
	 * concrete {@link Class} in the hierarchy of <code>c</code> The {@link GenInterfaceClass} of the visitor will be
	 * returned.
	 * 
	 * @param c
	 *            c
	 * @param full
	 *            If the value of full is true the returned name is for the complete hierarchy of c, otherwise for the
	 *            first hierarchy of c
	 */
	private void createVisitorWithoutReturnWithException(final ClassType c, final boolean full) {
		final String intName = this.getVisitorInterfaceName(c, full, false, true);
		final Vector<GenJavaOperation> operations = new Vector<>();
		GenPackage javaExceptionPackage = GenUnqualifiedPackage.create("java");
		javaExceptionPackage = javaExceptionPackage.addName("lang");
		final GenJavaException javaException = GenJavaException.createJavaException(javaExceptionPackage);
		final Generic generic = Generic.create("Y", GenHasGenericType.create(javaException));
		final GenComment visitorDefaultComment =
				GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_VISITOR_COMMENT, false);
		final Vector<GenInterfaceClass> impls = new Vector<>();
		final GenInterfaceClass visitorInterface =
				GenSimpleInterfaceClass.create(
						intName,
						operations,
						impls,
						PackageConstants.VISITOR_PACKAGE,
						visitorDefaultComment,
						"");
		visitorInterface.getGenerics().add(generic);
		final GenJavaOperation acceptOperation =
				this.createAcceptOperation(c, visitorInterface, GenVoidType.getInstance());
		acceptOperation.getGenerics().add(generic);
		acceptOperation.getParameters().get(0).getGenerics().add(generic);
		this.addException(acceptOperation, this.getGeneratorModelException(generic));
		this.createVisitorWithoutReturnWithExceptionHandleOperations(c.getSubTypes(), visitorInterface, generic, full);
		this.getGeneratorModel().addNonAstClass(visitorInterface);
	}
	
	/**
	 * Creates a new visitor with a return value and without exception. If <code>full</code> it will visitor for all
	 * concrete {@link Class} in the hierarchy of <code>c</code> The {@link GenInterfaceClass} of the visitor will be
	 * returned.
	 * 
	 * @param c
	 *            c
	 * @param full
	 *            If the value of full is true the returned name is for the complete hierarchy of c, otherwise for the
	 *            first hierarchy of c
	 */
	private void createVisitorWithReturnWithoutException(final ClassType c, final boolean full) {
		final String intName = this.getVisitorInterfaceName(c, full, true, false);
		final Vector<GenJavaOperation> operations = new Vector<>();
		final Generic generic = Generic.create("X", GenHasNoGenericType.create());
		final GenComment visitorDefaultComment =
				GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_VISITOR_COMMENT, false);
		final Vector<GenInterfaceClass> impls = new Vector<>();
		final GenInterfaceClass visitorInterface =
				GenSimpleInterfaceClass.create(
						intName,
						operations,
						impls,
						PackageConstants.VISITOR_PACKAGE,
						visitorDefaultComment,
						"");
		visitorInterface.getGenerics().add(generic);
		this.createAcceptOperation(c, visitorInterface, generic);
		this.createVisitorWithReturnWithoutExceptionHandleOperations(c.getSubTypes(), visitorInterface, generic, full);
		this.getGeneratorModel().addNonAstClass(visitorInterface);
		
	}
	
	/**
	 * Creates a new visitor without a return value and without exception. If <code>full</code> it will visitor for all
	 * concrete {@link Class} in the hierarchy of <code>c</code> The {@link GenInterfaceClass} of the visitor will be
	 * returned.
	 * 
	 * @param c
	 *            c
	 * @param full
	 *            If the value of full is true the returned name is for the complete hierarchy of c, otherwise for the
	 *            first hierarchy of c
	 * @return GenInterfaceClass
	 */
	private GenInterfaceClass createVisitorWithoutReturnAndException(final ClassType c, final boolean full) {
		final String intName = this.getVisitorInterfaceName(c, full, false, false);
		final Vector<GenJavaOperation> operations = new Vector<>();
		final GenComment visitorDefaultComment =
				GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_VISITOR_COMMENT, false);
		final Vector<GenInterfaceClass> impls = new Vector<>();
		final GenInterfaceClass visitorInterface =
				GenSimpleInterfaceClass.create(
						intName,
						operations,
						impls,
						PackageConstants.VISITOR_PACKAGE,
						visitorDefaultComment,
						"");
		this.createAcceptOperation(c, visitorInterface, GenVoidType.getInstance());
		this.createVisitorWithoutReturnAndExceptionHandleOperations(
				c.getSubTypes(),
				visitorInterface,
				GenVoidType.getInstance(),
				full);
		this.getGeneratorModel().addNonAstClass(visitorInterface);
		return visitorInterface;
	}
	
	private GenJavaOperation createAcceptOperation(final ClassType c,
			final GenInterfaceClass visitorInterface,
			final GenType returnType) {
		final Vector<GenParameter> params = new Vector<>();
		final GenParameter param = GenParameter.create(UtilVisitorTransformer.ACCEPT_PARAMETER_NAME, visitorInterface);
		params.add(param);
		final Vector<GenException> exceptions = new Vector<>();
		final GenComment comment = GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_HANDLE_COMMENT, true);
		final Vector<GenOperationModifier> modifiers = new Vector<>();
		if (c.isAbstract()) {
			modifiers.add(GenOperationModifier.ABSTRACT);
		}
		String acceptMethod = "";
		if (this.isGeneric(returnType)) {
			acceptMethod = UtilVisitorTransformer.ACCEPT_METHOD_RETURN;
		} else {
			acceptMethod = UtilVisitorTransformer.ACCEPT_METHOD_WITHOUT_RETURN;
		}
		
		final GenJavaOperation acceptAbstract =
				GenJavaOperation.create(
						UtilVisitorTransformer.ACCEPT_OPNAME,
						GenVisibility.PUBLIC,
						params,
						exceptions,
						acceptMethod,
						returnType,
						modifiers,
						comment);
		returnType.accept(new GenTypeVisitor() {
			@Override
			public void handle(final GenImportType importType) {
				// nothing to do
			}
			
			@Override
			public void handle(final Generic generic) {
				param.getGenerics().add(generic);
				acceptAbstract.getGenerics().add(generic);
			}
			
			@Override
			public void handle(final GenMapType mapType) {
				// nothing to do
			}
			
			@Override
			public void handle(final GenPrimitiveType primitiveType) {
				// nothing to do
			}
			
			@Override
			public void handle(final GenCollectionType collectionType) {
				// nothing to do
			}
			
			@Override
			public void handle(final GenClass cla) {
				// nothing to do
			}
			
			@Override
			public void handle(final GenJavaUtilCollection javaUtilCollection) {
				// nothing to do
			}
			
			@Override
			public void handle(final GenDummyType dummy) {
				// nothing to do
			}
		});
		
		final GenClass genOwner = this.getGeneratorModel().getClassMapping().get(c);
		genOwner.accept(new GenClassVisitor() {
			
			@Override
			public void handle(final GenPrimitiveClass primitiveClass) {
				// primitiveClass will not be generated, adding operation is useless
			}
			
			@Override
			public void handle(final GenInterfaceClass interfaceClass) {
				interfaceClass.accept(new GenInterfaceClassVisitor() {
					
					@Override
					public void handle(final GenInterfaceWithClassImplClass interfaceWithImplClass) {
						interfaceWithImplClass.addOperation(acceptAbstract);
						interfaceWithImplClass.getClassRepresentation().addOperation(acceptAbstract);
					}
					
					@Override
					public void handle(final GenSimpleInterfaceClass simpleInterface) {
						simpleInterface.addOperation(acceptAbstract);
					}
					
					@Override
					public void handle(final GenExternalInterfaceClass iface) {
						throw new Error("Operation " + acceptAbstract.getName()
								+ " cannot be added to external interface " + iface.getFullyQualifiedTypeName());
					}
				});
			}
			
			@Override
			public void handle(final GenClassClass classClass) {
				classClass.addOperation(acceptAbstract);
			}
		});
		
		return acceptAbstract;
	}
	
	/**
	 * Returns an {@link GenException} with the name of <code>type</code>. This exception will not be written to a file.
	 * 
	 * @param type
	 * @return {@link GenException}
	 */
	private GenException getGeneratorModelException(final GenType type) {
		final GenException exception =
				GenException.create(
						type.getName(),
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						new Vector<GenJavaAttribute>(),
						new Vector<GenClassModifier>(),
						new Vector<GenJavaOperation>(),
						GenUnqualifiedPackage.create(""),
						GenComment.createFromPlainText("", true),
						"");
		this.setCurrentException(exception);
		return exception;
	}
	
	private boolean isGeneric(final GenType returnType) {
		return returnType.accept(new GenTypeVisitorReturn<Boolean>() {
			@Override
			public Boolean handle(final GenClass cla) {
				return false;
			}
			
			@Override
			public Boolean handle(final GenCollectionType collectionType) {
				return false;
			}
			
			@Override
			public Boolean handle(final GenPrimitiveType primitiveType) {
				return false;
			}
			
			@Override
			public Boolean handle(final GenMapType mapType) {
				return false;
			}
			
			@Override
			public Boolean handle(final GenImportType importType) {
				return false;
			}
			
			@Override
			public Boolean handle(final GenDummyType dummyType) {
				return false;
			}
			
			@Override
			public Boolean handle(final Generic generic) {
				return true;
			}
			
			@Override
			public Boolean handle(final GenJavaUtilCollection javaUtilCollection) {
				return false;
			}
		});
	}
	
	private void createVisitorWithoutReturnWithExceptionHandleOperations(final Collection<ClassType> subTypes,
			final GenInterfaceClass visitorInterface,
			final Generic generic,
			final boolean full) {
		final Iterator<ClassType> i = subTypes.iterator();
		while (i.hasNext()) {
			final ClassType current = i.next();
			if (!current.isAbstract()) {
				final Vector<GenParameter> params = new Vector<>();
				final GenParameter param =
						GenParameter.create(current.getTypeName().getLastAddedName().toString().toLowerCase()
								.substring(0, 1), this.getGeneratorModel().getClassMapping().get(current));
				params.add(param);
				final Vector<GenException> exceptions = new Vector<>();
				exceptions.add(this.getCurrentException());
				final GenComment comment =
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_HANDLE_COMMENT, true);
				final Vector<GenOperationModifier> modifiers = new Vector<>();
				final GenJavaOperation handleOperationClass =
						GenJavaOperation.create(
								UtilVisitorTransformer.HANDLE_OPNAME,
								GenVisibility.PUBLIC,
								params,
								exceptions,
								"",
								GenVoidType.getInstance(),
								modifiers,
								comment);
				visitorInterface.addOperation(handleOperationClass);
				final GenJavaOperation acceptOperation =
						this.createAcceptOperation(current, visitorInterface, GenVoidType.getInstance());
				this.addException(acceptOperation, this.getCurrentException());
				acceptOperation.getGenerics().add(generic);
				acceptOperation.getParameters().get(0).getGenerics().add(generic);
			}
			if (full) {
				this.createVisitorWithoutReturnWithExceptionHandleOperations(
						current.getSubTypes(),
						visitorInterface,
						generic,
						full);
			}
		}
		
	}
	
	/**
	 * Adds the {@link GenException} <code>exception</code> to the {@link GenJavaOperation} <code>operation</code>.
	 * 
	 * @param operation
	 *            the operation that will be changed
	 * @param exception
	 *            the exception that will be added to the given operation
	 */
	private void addException(final GenJavaOperation operation, final GenException exception) {
		operation.getState().accept(new GenOperationStateVisitor() {
			@Override
			public void handle(final GenFullParsedOperationState s) {
				s.getExceptions().add(exception);
			}
			
			@Override
			public void handle(final GenSimpleOperationState s) {
				// nothing to do
			}
		});
	}
	
	/**
	 * Creates the handle-operation for the <code>subTypes</code> an add them in the <code>operations</code> list.
	 * 
	 * @param subTypes
	 * @param operations
	 */
	private void createVisitorWithoutReturnAndExceptionHandleOperations(final Collection<ClassType> subTypes,
			final GenInterfaceClass visitorInterface,
			final GenType returnType,
			final boolean full) {
		final Iterator<ClassType> i = subTypes.iterator();
		while (i.hasNext()) {
			final ClassType current = i.next();
			if (!current.isAbstract()) {
				final Vector<GenParameter> params = new Vector<>();
				final GenParameter param =
						GenParameter.create(current.getTypeName().getLastAddedName().toString().toLowerCase()
								.substring(0, 1), this.getGeneratorModel().getClassMapping().get(current));
				params.add(param);
				final Vector<GenException> exceptions = new Vector<>();
				final GenComment comment =
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_HANDLE_COMMENT, true);
				final Vector<GenOperationModifier> modifiers = new Vector<>();
				final GenJavaOperation handleOperationClass =
						GenJavaOperation.create(
								UtilVisitorTransformer.HANDLE_OPNAME,
								GenVisibility.PUBLIC,
								params,
								exceptions,
								"",
								returnType,
								modifiers,
								comment);
				visitorInterface.addOperation(handleOperationClass);
				this.createAcceptOperation(current, visitorInterface, returnType);
			}
			if (full) {
				this.createVisitorWithoutReturnAndExceptionHandleOperations(
						current.getSubTypes(),
						visitorInterface,
						returnType,
						full);
			}
		}
		
	}
	
	/**
	 * Creates the handle-operation for the <code>subTypes</code> an add them in the <code>operations</code> list. Add
	 * the <code>generic</code> to all handles and to the parameter of the handle-operation.
	 * 
	 * @param subTypes
	 * @param operations
	 */
	private void createVisitorWithReturnWithoutExceptionHandleOperations(final Collection<ClassType> subTypes,
			final GenInterfaceClass visitorInterface,
			final Generic generic,
			final boolean full) {
		this.createVisitorWithoutReturnAndExceptionHandleOperations(subTypes, visitorInterface, generic, full);
	}
	
	/**
	 * Creates the handle-operation for the <code>subTypes</code> an add them in the <code>operations</code> list. Add
	 * the <code>genericReturn</code> and <code>genericException</code> to all handles and to the parameter of the
	 * handle-operation.
	 * 
	 * @param subTypes
	 * @param visitorInterface
	 * @param genericReturn
	 * @param genericException
	 * @param full
	 */
	private void createVisitorWithReturnAndExceptionHandleOperations(final Collection<ClassType> subTypes,
			final GenInterfaceClass visitorInterface,
			final Generic genericReturn,
			final Generic genericException,
			final boolean full) {
		final Iterator<ClassType> i = subTypes.iterator();
		while (i.hasNext()) {
			final ClassType current = i.next();
			if (!current.isAbstract()) {
				final Vector<GenParameter> params = new Vector<>();
				final GenParameter param =
						GenParameter.create(current.getTypeName().getLastAddedName().toString().toLowerCase()
								.substring(0, 1), this.getGeneratorModel().getClassMapping().get(current));
				params.add(param);
				final Vector<GenException> exceptions = new Vector<>();
				exceptions.add(this.getCurrentException());
				final GenComment comment =
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_HANDLE_COMMENT, true);
				final Vector<GenOperationModifier> modifiers = new Vector<>();
				final GenJavaOperation handleOperationClass =
						GenJavaOperation.create(
								UtilVisitorTransformer.HANDLE_OPNAME,
								GenVisibility.PUBLIC,
								params,
								exceptions,
								"",
								genericReturn,
								modifiers,
								comment);
				visitorInterface.addOperation(handleOperationClass);
				final GenJavaOperation acceptOperation =
						this.createAcceptOperation(current, visitorInterface, genericReturn);
				acceptOperation.getGenerics().add(genericException);
				acceptOperation.getParameters().get(0).getGenerics().add(genericException);
				this.addException(acceptOperation, this.getCurrentException());
			}
			if (full) {
				this.createVisitorWithReturnAndExceptionHandleOperations(
						current.getSubTypes(),
						visitorInterface,
						genericReturn,
						genericException,
						full);
			}
		}
		
	}
	
	/**
	 * Returns the name of the visitor for the {@link Class} <code></code>. If the value of <code>full</code> is true
	 * the returned name is for the complete hierarchy of <code>c</code>, otherwise for the first hierarchy of
	 * <code>c</code>.
	 * 
	 * @param c
	 *            c
	 * @param full
	 *            If the value of full is true the returned name is for the complete hierarchy of c, otherwise for the
	 *            first hierarchy of c
	 * @param returnValue
	 *            if this is true, then the visitor return a value. If this is false, then the visitor return nothing.
	 * @param exception
	 *            if this is true, then the visitor can throw an exception. If this is false, then the visitor throw no
	 *            planned exception.
	 * @return String. The name of the visitor.
	 */
	private String getVisitorInterfaceName(final ClassType c,
			final boolean full,
			final boolean returnValue,
			final boolean exception) {
		String result = this.getGeneratorModel().getClassMapping().get(c).getName();
		if (full) {
			result += UtilVisitorTransformer.FULL_VISITOR_SUFFIX;
		} else {
			result += UtilVisitorTransformer.PARTIAL_VISITOR_SUFFIX;
		}
		if (returnValue) {
			result += UtilVisitorTransformer.RETURN_VISITOR;
		}
		if (exception) {
			result += UtilVisitorTransformer.EXCEPTION_VISITOR;
		}
		return result;
	}
	
	@Override
	public void handleType(final Type c) throws TaskException {
		c.accept(new TypeVisitorException<TaskException>() {
			
			@Override
			public void handle(final AtomicType s) throws TaskException {
				s.accept(new AtomicTypeVisitorException<TaskException>() {
					
					@Override
					public void handle(final BaseType baseType) throws TaskException {
						// nothing to do
					}
					
					@Override
					public void handle(final ClassType clazz) throws TaskException {
						VisitorTypeTransformer.this.processClassType(clazz);
					}
					
				});
			}
			
			@Override
			public void handle(final CompositeType compositeType) throws TaskException {
				compositeType.accept(new CompositeTypeVisitorException<TaskException>() {
					
					@Override
					public void handle(final MapType arg0) {
						// nothing to do
					}
					
					@Override
					public void handle(final ProductType arg0) {
						// TODO implement product visitor
						// try {
						// VisitorTypeTransformer.this.createProductVisitor(p);
						// } catch (TypeNotReferencedException e) {
						// throw new TaskException(e);
						// }
					}
					
					@Override
					public void handle(final SumType s) throws TaskException {
						// do not create visitors for the empty sum
						if (s.getElementsSizeWithoutThrownTypes() > 1) {
							VisitorTypeTransformer.this.createPartialVisitorsSum(s);
							VisitorTypeTransformer.this.createFullVisitorsSum(s);
						}
					}
					
					@Override
					public void handle(final de.fhdw.wtf.common.ast.type.ListType list) {
						// nothing to do
					}
					
					@Override
					public void handle(final ThrownType thrownType) throws TaskException {
						// nothing to do
					}
					
				});
				
			}
			
			@Override
			public void handle(final TypeProxy s) throws TaskException {
				// nothing to do
			}
		});
	}
	
	private void addVoidHandleToVisitor(final GenInterfaceClass visitor, final GenType toHandle) {
		final List<GenParameter> params = new ArrayList<>();
		params.add(GenParameter.create(toHandle.getName().toLowerCase().substring(0, 1), toHandle));
		final GenJavaOperation handle =
				GenJavaOperation.create(
						UtilVisitorTransformer.HANDLE_OPNAME,
						GenVisibility.PUBLIC,
						params,
						new ArrayList<GenException>(),
						"",
						GenVoidType.getInstance(),
						new ArrayList<GenOperationModifier>(),
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_HANDLE_COMMENT, true));
		visitor.addOperation(handle);
	}
	
	private void addReturnHandleToVisitor(final GenInterfaceClass visitor, final GenType toHandle) {
		final List<GenParameter> params = new ArrayList<>();
		params.add(GenParameter.create(toHandle.getName().toLowerCase().substring(0, 1), toHandle));
		final GenJavaOperation handle =
				GenJavaOperation.create(
						UtilVisitorTransformer.HANDLE_OPNAME,
						GenVisibility.PUBLIC,
						params,
						new ArrayList<GenException>(),
						"",
						this.getCurrentReturnType(),
						new ArrayList<GenOperationModifier>(),
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_HANDLE_COMMENT, true));
		visitor.addOperation(handle);
	}
	
	private void addExceptionHandleToVisitor(final GenInterfaceClass visitor, final GenType toHandle) {
		final List<GenParameter> params = new ArrayList<>();
		params.add(GenParameter.create(toHandle.getName().toLowerCase().substring(0, 1), toHandle));
		final GenJavaOperation handle =
				GenJavaOperation.create(
						UtilVisitorTransformer.HANDLE_OPNAME,
						GenVisibility.PUBLIC,
						params,
						new ArrayList<GenException>(),
						"",
						GenVoidType.getInstance(),
						new ArrayList<GenOperationModifier>(),
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_HANDLE_COMMENT, true));
		this.addException(handle, this.getCurrentException());
		visitor.addOperation(handle);
	}
	
	private void addReturnExceptionHandleToVisitor(final GenInterfaceClass visitor, final GenType toHandle) {
		final List<GenParameter> params = new ArrayList<>();
		params.add(GenParameter.create(toHandle.getName().toLowerCase().substring(0, 1), toHandle));
		final GenJavaOperation handle =
				GenJavaOperation.create(
						UtilVisitorTransformer.HANDLE_OPNAME,
						GenVisibility.PUBLIC,
						params,
						new ArrayList<GenException>(),
						"",
						this.getCurrentReturnType(),
						new ArrayList<GenOperationModifier>(),
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_HANDLE_COMMENT, true));
		this.addException(handle, this.getCurrentException());
		visitor.addOperation(handle);
	}
	
	private void createPartialVisitorsSum(final SumType s) throws TaskException {
		final GenType sumType = VisitorTypeTransformer.this.getGeneratorModel().getGenTypeForType(s);
		final GenPackage visPackage = PackageConstants.VISITOR_PACKAGE;
		
		// 1. Visitor: void
		final GenInterfaceClass sumVisitorPartialVoid =
				GenSimpleInterfaceClass.create(
						sumType.getName() + UtilVisitorTransformer.PARTIAL_VISITOR_SUFFIX,
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						visPackage,
						GenComment.createFromPlainText(
								"This is a Visitor for the hierarchie of " + sumType.getName(),
								false),
						"");
		// accept
		final List<GenParameter> params = new ArrayList<>();
		params.add(GenParameter.create(UtilVisitorTransformer.ACCEPT_PARAMETER_NAME, sumVisitorPartialVoid));
		final GenJavaOperation accept =
				GenJavaOperation.create(
						UtilVisitorTransformer.ACCEPT_OPNAME,
						GenVisibility.PUBLIC,
						params,
						new ArrayList<GenException>(),
						UtilVisitorTransformer.ACCEPT_METHOD_WITHOUT_RETURN,
						GenVoidType.getInstance(),
						new ArrayList<GenOperationModifier>(),
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_ACCEPT_COMMENT, true));
		// construct
		this.assumeClassAndAddOperation(sumType, accept);
		this.acceptVisitorInSum(s, sumVisitorPartialVoid, accept, true, true, false);
		this.getGeneratorModel().addNonAstClass(sumVisitorPartialVoid);
		
		// 2. Visitor: return
		final GenInterfaceClass sumVisitorPartialReturn =
				GenSimpleInterfaceClass.create(
						sumType.getName() + UtilVisitorTransformer.PARTIAL_VISITOR_SUFFIX
								+ UtilVisitorTransformer.RETURN_VISITOR,
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						visPackage,
						GenComment.createFromPlainText(
								"This is a Visitor for the hierarchie of " + sumType.getName(),
								false),
						"");
		final Generic genericReturn = Generic.create("X", GenHasNoGenericType.create());
		sumVisitorPartialReturn.getGenerics().add(genericReturn);
		// accept
		final List<GenParameter> paramsReturn = new ArrayList<>();
		final GenParameter paramReturn =
				GenParameter.create(UtilVisitorTransformer.ACCEPT_PARAMETER_NAME, sumVisitorPartialReturn);
		paramReturn.getGenerics().add(genericReturn);
		paramsReturn.add(paramReturn);
		final GenJavaOperation acceptReturn =
				GenJavaOperation.create(
						UtilVisitorTransformer.ACCEPT_OPNAME,
						GenVisibility.PUBLIC,
						paramsReturn,
						new ArrayList<GenException>(),
						UtilVisitorTransformer.ACCEPT_METHOD_RETURN,
						genericReturn,
						new ArrayList<GenOperationModifier>(),
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_ACCEPT_COMMENT, true));
		acceptReturn.getGenerics().add(genericReturn);
		this.setCurrentReturnType(genericReturn);
		// construct
		this.assumeClassAndAddOperation(sumType, acceptReturn);
		this.acceptVisitorInSum(s, sumVisitorPartialReturn, acceptReturn, true, false, false);
		this.getGeneratorModel().addNonAstClass(sumVisitorPartialReturn);
		
		// 3. Visitor: exception
		GenPackage javaExceptionPackage = GenUnqualifiedPackage.create("java");
		javaExceptionPackage = javaExceptionPackage.addName("lang");
		final GenJavaException javaException = GenJavaException.createJavaException(javaExceptionPackage);
		final Generic genericException = Generic.create("Y", GenHasGenericType.create(javaException));
		final GenInterfaceClass sumVisitorPartialException =
				GenSimpleInterfaceClass.create(
						sumType.getName() + UtilVisitorTransformer.PARTIAL_VISITOR_SUFFIX
								+ UtilVisitorTransformer.EXCEPTION_VISITOR,
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						visPackage,
						GenComment.createFromPlainText(
								"This is a Visitor for the hierarchie of " + sumType.getName(),
								false),
						"");
		sumVisitorPartialException.getGenerics().add(genericException);
		// accept
		final List<GenParameter> paramsException = new ArrayList<>();
		final GenParameter paramException =
				GenParameter.create(UtilVisitorTransformer.ACCEPT_PARAMETER_NAME, sumVisitorPartialException);
		paramException.getGenerics().add(genericException);
		paramsException.add(paramException);
		final GenJavaOperation acceptException =
				GenJavaOperation.create(
						UtilVisitorTransformer.ACCEPT_OPNAME,
						GenVisibility.PUBLIC,
						paramsException,
						new ArrayList<GenException>(),
						UtilVisitorTransformer.ACCEPT_METHOD_WITHOUT_RETURN,
						GenVoidType.getInstance(),
						new ArrayList<GenOperationModifier>(),
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_ACCEPT_COMMENT, true));
		acceptException.getGenerics().add(genericException);
		this.addException(acceptException, this.getGeneratorModelException(genericException));
		// construct
		this.assumeClassAndAddOperation(sumType, acceptException);
		this.acceptVisitorInSum(s, sumVisitorPartialException, acceptException, true, true, true);
		this.getGeneratorModel().addNonAstClass(sumVisitorPartialException);
		
		// 4. Visitor: return/exception
		final GenInterfaceClass sumVisitorPartialReturnException =
				GenSimpleInterfaceClass.create(
						sumType.getName() + UtilVisitorTransformer.PARTIAL_VISITOR_SUFFIX
								+ UtilVisitorTransformer.RETURN_VISITOR + UtilVisitorTransformer.EXCEPTION_VISITOR,
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						visPackage,
						GenComment.createFromPlainText(
								"This is a Visitor for the hierarchie of " + sumType.getName(),
								false),
						"");
		final List<GenParameter> paramsReturnException = new ArrayList<>();
		final GenParameter paramReturnException =
				GenParameter.create(UtilVisitorTransformer.ACCEPT_PARAMETER_NAME, sumVisitorPartialReturnException);
		final Generic genericReturn2 = Generic.create("X", GenHasNoGenericType.create());
		sumVisitorPartialReturnException.getGenerics().add(genericReturn2);
		sumVisitorPartialReturnException.getGenerics().add(genericException);
		paramReturnException.getGenerics().add(genericReturn2);
		paramReturnException.getGenerics().add(genericException);
		paramsReturnException.add(paramReturnException);
		final GenJavaOperation acceptReturnException =
				GenJavaOperation.create(
						UtilVisitorTransformer.ACCEPT_OPNAME,
						GenVisibility.PUBLIC,
						paramsReturnException,
						new ArrayList<GenException>(),
						UtilVisitorTransformer.ACCEPT_METHOD_RETURN,
						genericReturn2,
						new ArrayList<GenOperationModifier>(),
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_ACCEPT_COMMENT, true));
		acceptReturnException.getGenerics().add(genericReturn2);
		acceptReturnException.getGenerics().add(genericException);
		this.addException(acceptReturnException, this.getCurrentException());
		this.setCurrentReturnType(genericReturn2);
		// construct
		this.assumeClassAndAddOperation(sumType, acceptReturnException);
		this.acceptVisitorInSum(s, sumVisitorPartialReturnException, acceptReturnException, true, false, true);
		this.getGeneratorModel().addNonAstClass(sumVisitorPartialReturnException);
	}
	
	private void createFullVisitorsSum(final SumType s) throws TaskException {
		final GenType sumType = VisitorTypeTransformer.this.getGeneratorModel().getGenTypeForType(s);
		final GenPackage visPackage = PackageConstants.VISITOR_PACKAGE;
		// 1. Visitor: void
		final GenInterfaceClass sumVisitorFull =
				GenSimpleInterfaceClass.create(
						sumType.getName() + UtilVisitorTransformer.FULL_VISITOR_SUFFIX,
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						visPackage,
						GenComment.createFromPlainText(
								"This is a Visitor for the hierarchie of " + sumType.getName(),
								false),
						"");
		// accept
		final List<GenParameter> params = new ArrayList<>();
		params.add(GenParameter.create(UtilVisitorTransformer.ACCEPT_PARAMETER_NAME, sumVisitorFull));
		final GenJavaOperation accept =
				GenJavaOperation.create(
						UtilVisitorTransformer.ACCEPT_OPNAME,
						GenVisibility.PUBLIC,
						params,
						new ArrayList<GenException>(),
						UtilVisitorTransformer.ACCEPT_METHOD_WITHOUT_RETURN,
						GenVoidType.getInstance(),
						new ArrayList<GenOperationModifier>(),
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_ACCEPT_COMMENT, true));
		// construct
		this.assumeClassAndAddOperation(sumType, accept);
		this.acceptVisitorInSum(s, sumVisitorFull, accept, false, true, false);
		this.getGeneratorModel().addNonAstClass(sumVisitorFull);
		
		// 2. Visitor: return
		
		final GenInterfaceClass sumVisitorFullReturn =
				GenSimpleInterfaceClass.create(
						sumType.getName() + UtilVisitorTransformer.FULL_VISITOR_SUFFIX
								+ UtilVisitorTransformer.RETURN_VISITOR,
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						visPackage,
						GenComment.createFromPlainText(
								"This is a Visitor for the hierarchie of " + sumType.getName(),
								false),
						"");
		final Generic generic = Generic.create("X", GenHasNoGenericType.create());
		sumVisitorFullReturn.getGenerics().add(generic);
		// accept
		final List<GenParameter> paramsReturn = new ArrayList<>();
		final GenParameter paramReturn =
				GenParameter.create(UtilVisitorTransformer.ACCEPT_PARAMETER_NAME, sumVisitorFullReturn);
		paramReturn.getGenerics().add(generic);
		paramsReturn.add(paramReturn);
		final GenJavaOperation acceptReturn =
				GenJavaOperation.create(
						UtilVisitorTransformer.ACCEPT_OPNAME,
						GenVisibility.PUBLIC,
						paramsReturn,
						new ArrayList<GenException>(),
						UtilVisitorTransformer.ACCEPT_METHOD_RETURN,
						generic,
						new ArrayList<GenOperationModifier>(),
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_ACCEPT_COMMENT, true));
		acceptReturn.getGenerics().add(generic);
		// construct
		this.assumeClassAndAddOperation(sumType, acceptReturn);
		this.acceptVisitorInSum(s, sumVisitorFullReturn, acceptReturn, false, false, false);
		this.getGeneratorModel().addNonAstClass(sumVisitorFullReturn);
		
		// 3. Visitor: exception
		
		GenPackage javaExceptionPackage = GenUnqualifiedPackage.create("java");
		javaExceptionPackage = javaExceptionPackage.addName("lang");
		final GenJavaException javaException = GenJavaException.createJavaException(javaExceptionPackage);
		final Generic genericException = Generic.create("Y", GenHasGenericType.create(javaException));
		final GenInterfaceClass sumVisitorFullException =
				GenSimpleInterfaceClass.create(
						sumType.getName() + UtilVisitorTransformer.FULL_VISITOR_SUFFIX
								+ UtilVisitorTransformer.EXCEPTION_VISITOR,
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						visPackage,
						GenComment.createFromPlainText(
								"This is a Visitor for the hierarchie of " + sumType.getName(),
								false),
						"");
		sumVisitorFullException.getGenerics().add(genericException);
		// accept
		final List<GenParameter> paramsException = new ArrayList<>();
		final GenParameter paramException =
				GenParameter.create(UtilVisitorTransformer.ACCEPT_PARAMETER_NAME, sumVisitorFullException);
		paramException.getGenerics().add(genericException);
		paramsException.add(paramException);
		final GenJavaOperation acceptException =
				GenJavaOperation.create(
						UtilVisitorTransformer.ACCEPT_OPNAME,
						GenVisibility.PUBLIC,
						paramsException,
						new ArrayList<GenException>(),
						UtilVisitorTransformer.ACCEPT_METHOD_WITHOUT_RETURN,
						GenVoidType.getInstance(),
						new ArrayList<GenOperationModifier>(),
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_ACCEPT_COMMENT, true));
		acceptException.getGenerics().add(genericException);
		this.addException(acceptException, this.getGeneratorModelException(genericException));
		// construct
		this.assumeClassAndAddOperation(sumType, acceptException);
		this.acceptVisitorInSum(s, sumVisitorFullException, acceptException, false, true, true);
		this.getGeneratorModel().addNonAstClass(sumVisitorFullException);
		
		// 4. Visitor: return/exception
		
		final GenInterfaceClass sumVisitorFullReturnException =
				GenSimpleInterfaceClass.create(
						sumType.getName() + UtilVisitorTransformer.FULL_VISITOR_SUFFIX
								+ UtilVisitorTransformer.RETURN_VISITOR + UtilVisitorTransformer.EXCEPTION_VISITOR,
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						visPackage,
						GenComment.createFromPlainText(
								"This is a Visitor for the hierarchie of " + sumType.getName(),
								false),
						"");
		final List<GenParameter> paramsReturnException = new ArrayList<>();
		final GenParameter paramReturnException =
				GenParameter.create(UtilVisitorTransformer.ACCEPT_PARAMETER_NAME, sumVisitorFullReturnException);
		final Generic genericReturn2 = Generic.create("X", GenHasNoGenericType.create());
		sumVisitorFullReturnException.getGenerics().add(genericReturn2);
		sumVisitorFullReturnException.getGenerics().add(genericException);
		// accept
		paramReturnException.getGenerics().add(genericReturn2);
		paramReturnException.getGenerics().add(genericException);
		paramsReturnException.add(paramReturnException);
		final GenJavaOperation acceptReturnException =
				GenJavaOperation.create(
						UtilVisitorTransformer.ACCEPT_OPNAME,
						GenVisibility.PUBLIC,
						paramsReturnException,
						new ArrayList<GenException>(),
						UtilVisitorTransformer.ACCEPT_METHOD_RETURN,
						genericReturn2,
						new ArrayList<GenOperationModifier>(),
						GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_ACCEPT_COMMENT, true));
		acceptReturnException.getGenerics().add(genericReturn2);
		acceptReturnException.getGenerics().add(genericException);
		this.addException(acceptReturnException, this.getCurrentException());
		// construct
		this.assumeClassAndAddOperation(sumType, acceptReturnException);
		this.acceptVisitorInSum(s, sumVisitorFullReturnException, acceptReturnException, false, false, true);
		this.getGeneratorModel().addNonAstClass(sumVisitorFullReturnException);
	}
	
	private void acceptVisitorInSum(final SumType s,
			final GenInterfaceClass visitor,
			final GenJavaOperation accept,
			final boolean partial,
			final boolean isVoid,
			final boolean hasException) throws TaskException {
		for (final Type type : s.getElements()) {
			if (partial) {
				this.acceptVisitorInAstTypePartial(type, visitor, accept, isVoid, hasException);
			} else {
				this.acceptVisitorInAstTypeFull(type, visitor, accept, isVoid, hasException);
			}
			
		}
	}
	
	/**
	 * Adds some handle() operation to a visitor.
	 * 
	 * @param visitor
	 *            The visitor to extend.
	 * @param genType
	 *            The type of the handle() parameter.
	 * @param isVoid
	 *            True if the handle() operation shall have return type void.
	 * @param hasException
	 *            True if the handle() operation shall have a throws clause.
	 */
	private void addHandleOperation(final GenInterfaceClass visitor,
			final GenType genType,
			final boolean isVoid,
			final boolean hasException) {
		if (isVoid && !hasException) {
			VisitorTypeTransformer.this.addVoidHandleToVisitor(visitor, genType);
		} else if (isVoid && hasException) {
			VisitorTypeTransformer.this.addExceptionHandleToVisitor(visitor, genType);
		} else if (!isVoid && !hasException) {
			VisitorTypeTransformer.this.addReturnHandleToVisitor(visitor, genType);
		} else {
			VisitorTypeTransformer.this.addReturnExceptionHandleToVisitor(visitor, genType);
		}
	}
	
	private void acceptVisitorInAstTypePartial(final Type astType,
			final GenInterfaceClass visitor,
			final GenJavaOperation accept,
			final boolean isVoid,
			final boolean hasException) throws TaskException {
		astType.accept(new TypeVisitorException<TaskException>() {
			
			@Override
			public void handle(final AtomicType s) throws TaskException {
				s.accept(new AtomicTypeVisitorException<TaskException>() {
					
					@Override
					public void handle(final BaseType b) throws TaskException {
						VisitorTypeTransformer.this.addAcceptOperationToBaseType(b, accept);
						final GenType genType = VisitorTypeTransformer.this.getGeneratorModel().getGenTypeForType(b);
						VisitorTypeTransformer.this.addHandleOperation(visitor, genType, isVoid, hasException);
					}
					
					@Override
					public void handle(final ClassType c) throws TaskException {
						final GenClass genType =
								(GenClass) VisitorTypeTransformer.this.getGeneratorModel().getGenTypeForType(c);
						
						genType.accept(new GenClassVisitorException<TaskException>() {
							@Override
							public void handle(final GenClassClass classClass) throws TaskException {
								// TODO Irgendwo an dieser Stelle muss die Generierung der PartialVisitorAcceptoren für
								// Klassen
								// die von Mehrfachvererbung betroffen sind, angepasst werden.
								if (!classClass.getModifieres().contains(GenClassModifier.ABSTRACT)) {
									if (!VisitorTypeTransformer.this.hasTypeHandled(visitor, genType)) {
										VisitorTypeTransformer.this.addHandledType(visitor, genType);
										classClass.addOperation(accept);
										VisitorTypeTransformer.this.addHandleOperation(
												visitor,
												genType,
												isVoid,
												hasException);
									}
								} else {
									for (final ClassType astClass : c.getSubTypes()) {
										VisitorTypeTransformer.this.acceptVisitorInAstTypePartial(
												astClass,
												visitor,
												accept,
												isVoid,
												hasException);
									}
								}
							}
							
							@Override
							public void handle(final GenInterfaceClass interfaceClass) throws TaskException {
								final GenClassVisitorException<TaskException> gcv = this;
								interfaceClass.accept(new GenInterfaceClassVisitorException<TaskException>() {
									
									@Override
									public void handle(final GenInterfaceWithClassImplClass interfaceWithImplClass)
											throws TaskException {
										gcv.handle(interfaceWithImplClass.getClassRepresentation());
									}
									
									@Override
									public void handle(final GenSimpleInterfaceClass simpleInterface)
											throws TaskException {
										for (final ClassType astClass : c.getSubTypes()) {
											VisitorTypeTransformer.this.acceptVisitorInAstTypePartial(
													astClass,
													visitor,
													accept,
													isVoid,
													hasException);
										}
									}
									
									@Override
									public void handle(final GenExternalInterfaceClass iface) {
										// nothing to do for external interfaces
									}
								});
							}
							
							@Override
							public void handle(final GenPrimitiveClass primitiveClass) {
								// nothing to do
							}
						});
					}
				});
			}
			
			@Override
			public void handle(final CompositeType c) throws TaskException {
				c.accept(new CompositeTypeVisitorException<TaskException>() {
					
					@Override
					public void handle(final MapType arg0) {
						// Lists are not generated
					}
					
					@Override
					public void handle(final ProductType p) throws TaskException {
						final GenType genType = VisitorTypeTransformer.this.getGeneratorModel().getGenTypeForType(p);
						if (!VisitorTypeTransformer.this.hasTypeHandled(visitor, genType)) {
							VisitorTypeTransformer.this.addHandledType(visitor, genType);
							VisitorTypeTransformer.this.assumeClassAndAddOperation(genType, accept);
							VisitorTypeTransformer.this.addHandleOperation(visitor, genType, isVoid, hasException);
						}
					}
					
					@Override
					public void handle(final SumType s) throws TaskException {
						VisitorTypeTransformer.this.acceptVisitorInSum(s, visitor, accept, true, isVoid, hasException);
					}
					
					@Override
					public void handle(final ListType list) {
						// Lists are not generated
					}
					
					@Override
					public void handle(final ThrownType thrownType) throws TaskException {
						// nothing to do
					}
				});
			}
			
			@Override
			public void handle(final TypeProxy s) throws TaskException {
				VisitorTypeTransformer.this.acceptVisitorInAstTypePartial(
						HelperUtils.getTargetAtomicType(s),
						visitor,
						accept,
						isVoid,
						hasException);
			}
		});
	}
	
	private void acceptVisitorInAstTypeFull(final Type astType,
			final GenInterfaceClass visitor,
			final GenJavaOperation accept,
			final boolean isVoid,
			final boolean hasException) throws TaskException {
		astType.accept(new TypeVisitorException<TaskException>() {
			
			@Override
			public void handle(final AtomicType s) throws TaskException {
				s.accept(new AtomicTypeVisitorException<TaskException>() {
					
					@Override
					public void handle(final BaseType b) throws TaskException {
						VisitorTypeTransformer.this.addAcceptOperationToBaseType(b, accept);
						final GenType genType = VisitorTypeTransformer.this.getGeneratorModel().getGenTypeForType(b);
						VisitorTypeTransformer.this.addHandleOperation(visitor, genType, isVoid, hasException);
					}
					
					@Override
					public void handle(final ClassType c) throws TaskException {
						final GenClass genType =
								(GenClass) VisitorTypeTransformer.this.getGeneratorModel().getGenTypeForType(c);
						genType.accept(new GenClassVisitorException<TaskException>() {
							@Override
							public void handle(final GenClassClass classClass) throws TaskException {
								if (!classClass.getModifieres().contains(GenClassModifier.ABSTRACT)) {
									if (!VisitorTypeTransformer.this.hasTypeHandled(visitor, genType)) {
										VisitorTypeTransformer.this.addHandledType(visitor, genType);
										classClass.addOperation(accept);
										VisitorTypeTransformer.this.addHandleOperation(
												visitor,
												genType,
												isVoid,
												hasException);
									}
									
								}
								for (final ClassType astClass : c.getSubTypes()) {
									VisitorTypeTransformer.this.acceptVisitorInAstTypeFull(
											astClass,
											visitor,
											accept,
											isVoid,
											hasException);
								}
							}
							
							@Override
							public void handle(final GenInterfaceClass interfaceClass) throws TaskException {
								final GenClassVisitorException<TaskException> gcv = this;
								interfaceClass.accept(new GenInterfaceClassVisitorException<TaskException>() {
									
									@Override
									public void handle(final GenInterfaceWithClassImplClass interfaceWithImplClass)
											throws TaskException {
										gcv.handle(interfaceWithImplClass.getClassRepresentation());
									}
									
									@Override
									public void handle(final GenSimpleInterfaceClass simpleInterface)
											throws TaskException {
										// nothing to do
									}
									
									@Override
									public void handle(final GenExternalInterfaceClass iface) {
										// nothing to do for external interfaces
									}
								});
								
								for (final ClassType astClass : c.getSubTypes()) {
									VisitorTypeTransformer.this.acceptVisitorInAstTypeFull(
											astClass,
											visitor,
											accept,
											isVoid,
											hasException);
								}
							}
							
							@Override
							public void handle(final GenPrimitiveClass primitiveClass) {
								// nothing to do
							}
						});
					}
				});
			}
			
			@Override
			public void handle(final CompositeType c) throws TaskException {
				c.accept(new CompositeTypeVisitorException<TaskException>() {
					
					@Override
					public void handle(final MapType arg0) {
						// Maps are not generated
					}
					
					@Override
					public void handle(final ProductType p) throws GenTypeNotReferencedException {
						final GenType genType = VisitorTypeTransformer.this.getGeneratorModel().getGenTypeForType(p);
						if (!VisitorTypeTransformer.this.hasTypeHandled(visitor, genType)) {
							VisitorTypeTransformer.this.addHandledType(visitor, genType);
							VisitorTypeTransformer.this.assumeClassAndAddOperation(genType, accept);
							VisitorTypeTransformer.this.addHandleOperation(visitor, genType, isVoid, hasException);
						}
					}
					
					@Override
					public void handle(final SumType s) throws TaskException {
						VisitorTypeTransformer.this.acceptVisitorInSum(s, visitor, accept, false, isVoid, hasException);
					}
					
					@Override
					public void handle(final de.fhdw.wtf.common.ast.type.ListType list) {
						// Lists are not generated
					}
					
					@Override
					public void handle(final ThrownType thrownType) throws TaskException {
						// nothing to do
					}
				});
			}
			
			@Override
			public void handle(final TypeProxy s) throws TaskException {
				VisitorTypeTransformer.this.acceptVisitorInAstTypeFull(
						HelperUtils.getTargetAtomicType(s),
						visitor,
						accept,
						isVoid,
						hasException);
			}
		});
	}
	
	private void addAcceptOperationToBaseType(final BaseType baseType, final GenJavaOperation accept)
			throws GenTypeNotReferencedException {
		// transform accept-java-method to aspect-method
		final GenClass owner = this.getGeneratorModel().getBaseClassMapping().get(baseType);
		final GenAspectOperation aspectAccept =
				GenAspectOperation.create(accept.getName(), accept.getParameters(), accept.getState(), owner);
		aspectAccept.getGenerics().addAll(accept.getGenerics());
		final GenAspect aspectForBaseTypeExpansion = this.getGeneratorModel().getAspectForBaseTypeExpansion(baseType);
		aspectForBaseTypeExpansion.addAspectOperation(aspectAccept);
	}
	
	private void assumeClassAndAddOperation(final GenType genType, final GenJavaOperation accept) {
		genType.accept(new GenTypeVisitor() {
			
			@Override
			public void handle(final Generic generic) {
				// nothing to do
			}
			
			@Override
			public void handle(final GenMapType mapType) {
				// nothing to do
			}
			
			@Override
			public void handle(final GenPrimitiveType primitiveType) {
				// nothing to do
			}
			
			@Override
			public void handle(final GenCollectionType collectionType) {
				// nothing to do
			}
			
			@Override
			public void handle(final GenClass cla) {
				cla.addOperation(accept);
			}
			
			@Override
			public void handle(final GenJavaUtilCollection javaUtilCollection) {
				// nothing to do
			}
			
			@Override
			public void handle(final GenImportType importType) {
				// nothing to do
			}
			
			@Override
			public void handle(final GenDummyType dummy) {
				// nothing to do
			}
		});
	}
	
	// TODO Is not used yet, but is necessary for Product refactoring
	// private void createProductVisitor(final ProductType p) throws TaskException {
	// if (this.visitorNecessary(p)) {
	// this.createFullVisitorProduct(p);
	// }
	// }
	
	// TODO Ist not used yet, but is used in createProductVisitor
	// private void createFullVisitorProduct(final ProductType p) throws TaskException {
	// final GenClass prodType =
	// this.getGeneratorModel().getClassMapping().get(p);
	// final GenPackage visitorPackage = UtilVisitorTransformer.getVisitorPackage();
	// // 1. Visitor: void
	// final Vector<GenJavaOperation> visitorVoidOp = new Vector<>();
	// final GenInterfaceClass visitorVoid =
	// GenSimpleInterfaceClass.create(
	// prodType.getName() + UtilVisitorTransformer.FULL_VISITOR_SUFFIX,
	// visitorVoidOp,
	// new Vector<GenInterfaceClass>(),
	// visitorPackage,
	// GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_VISITOR_COMMENT, true),
	// "",
	// new Vector<GenType>(),
	// false);
	// final Vector<GenParameter> paramsVoid = new Vector<>();
	// final GenParameter paramVoid = GenParameter.create(UtilVisitorTransformer.ACCEPT_PARAMETER_NAME, visitorVoid);
	// paramsVoid.add(paramVoid);
	// GenJavaOperation.create(
	// UtilVisitorTransformer.ACCEPT_OPNAME,
	// GenVisibility.PUBLIC,
	// paramsVoid,
	// new Vector<GenException>(),
	// UtilVisitorTransformer.ACCEPT_METHOD_WITHOUT_RETURN,
	// GenVoidType.getInstance(),
	// new Vector<GenOperationModifier>(),
	// GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_ACCEPT_COMMENT, true));
	// final ArrayList<GenJavaOperation> handleOps = this.createVoidHandleOperation(p);
	//
	// }
	
	// TODO Ist not used yet, but is used in createFullVisitorProduct
	// private ArrayList<GenJavaOperation> createVoidHandleOperation(final ProductType p) throws TaskException {
	// final ArrayList<GenJavaOperation> result = new ArrayList<>();
	// final Iterator<ProductElementType> i = p.getElements().iterator();
	// final boolean first = false;
	// while (i.hasNext()) {
	// final ProductElementType current = i.next();
	// final Type type = UtilTransformer.getTypeProxyFreePrototype(current.getType());
	// if (!first) {
	// result.add(GenJavaOperation.create(
	// UtilVisitorTransformer.HANDLE_OPNAME,
	// GenVisibility.PUBLIC,
	// new ArrayList<GenParameter>(),
	// new Vector<GenException>(),
	// "",
	// GenVoidType.getInstance(),
	// new Vector<GenOperationModifier>(),
	// GenComment.createFromPlainText(UtilVisitorTransformer.DEFAULT_HANDLE_COMMENT, true)));
	// }
	// this.addParameterToHandles(result, type);
	// }
	// return result;
	// }
	
	// TODO Ist not used yet, but is used in createVoidHandleOperation
	// private void addParameterToHandles(final ArrayList<GenJavaOperation> ops,
	// final Type type) throws TaskException {
	// final Iterator<GenJavaOperation> i = ops.iterator();
	// while (i.hasNext()) {
	// final GenJavaOperation current = i.next();
	// type.accept(new TypeVisitorException<TaskException>() {
	//
	// @Override
	// public void handle(final AtomicType arg0) throws TaskException {
	// arg0.accept(new AtomicTypeVisitorException<TaskException>() {
	//
	// @Override
	// public void handle(final BaseType b) throws TaskException {
	// VisitorTypeTransformer.this.addParameterToHandles(current, b);
	// }
	//
	// @Override
	// public void handle(final ClassType c) throws TaskException {
	// if (UtilVisitorTransformer.isVisitable(c)) {
	// VisitorTypeTransformer.this.addParameterHierarchieToHandles(ops, c);
	// } else {
	// VisitorTypeTransformer.this.addParameterToHandles(current, c);
	// }
	// }
	// });
	// }
	//
	// @Override
	// public void handle(final CompositeType arg0) throws TaskException {
	// arg0.accept(new CompositeTypeVisitorException<TaskException>() {
	//
	// @Override
	// public void handle(final MapType m) throws TaskException {
	// VisitorTypeTransformer.this.addParameterToHandles(current, m);
	// }
	//
	// @Override
	// public void handle(final ProductType p) throws TaskException {
	// VisitorTypeTransformer.this.addParameterToHandles(current, p);
	// }
	//
	// @Override
	// public void handle(final SumType s) throws TaskException {
	// VisitorTypeTransformer.this.addParameterToHandles(current, s);
	// }
	//
	// @Override
	// public void handle(final de.fhdw.wtf.common.ast.type.ListType list) throws TaskException {
	// VisitorTypeTransformer.this.addParameterToHandles(current, list);
	// }
	// });
	// }
	//
	// @Override
	// public void handle(final TypeProxy arg0) throws TaskException {
	// // No need to handle TypeProxy
	// }
	// });
	// }
	//
	// }
	
	// TODO Ist not used yet, but is used in addParameterToHandles
	// private void addParameterHierarchieToHandles(final ArrayList<GenJavaOperation> ops, final ClassType c)
	// throws TaskException {
	// // TODO implements handle-operation for c and subtypes.
	// }
	
	private GenJavaOperation copyOperation(final GenJavaOperation op) throws TaskException {
		final String name = op.getName();
		final ArrayList<Generic> generics = this.copyGenerics(op.getGenerics());
		final List<GenParameter> params = this.copyParams(op.getParameters());
		final GenOperationState opState = this.copyOperationState(op.getState());
		final GenJavaOperation newOp = GenJavaOperation.create(name, params, opState);
		newOp.getGenerics().addAll(generics);
		return newOp;
	}
	
	private GenOperationState copyOperationState(final GenOperationState state) throws TaskException {
		return state.accept(new GenOperationStateVisitorReturnException<GenOperationState, TaskException>() {
			@Override
			public GenOperationState handle(final GenSimpleOperationState s) throws TaskException {
				return GenSimpleOperationState.create(s.getFullOperationWithPossibleImplementation());
			}
			
			@Override
			public GenOperationState handle(final GenFullParsedOperationState s) throws TaskException {
				return GenFullParsedOperationState.create(
						s.getComment(),
						VisitorTypeTransformer.this.copyException(s.getExceptions()),
						s.getReturntyp(),
						s.getModifiers(),
						s.getVisibility(),
						s.getMethodBody());
			}
		});
	}
	
	private Collection<GenException> copyException(final Collection<GenException> exceptions) throws TaskException {
		final Collection<GenException> result = new Vector<>();
		final Iterator<GenException> i = exceptions.iterator();
		while (i.hasNext()) {
			final GenException current = i.next();
			result.add(GenException.create(
					current.getName(),
					this.copyOperations(current.getOperations()),
					current.getImplement(),
					this.copyExceptionAttributes(current.getAttributes()),
					current.getModifieres(),
					current.getConstructors(),
					current.getPackag(),
					current.getComment(),
					current.getNonGeneratedPart()
			// ,current.getImports()
					));
		}
		return result;
	}
	
	private Collection<GenJavaOperation> copyOperations(final Collection<GenJavaOperation> operations)
			throws TaskException {
		final Collection<GenJavaOperation> result = new Vector<>();
		final Iterator<GenJavaOperation> i = operations.iterator();
		while (i.hasNext()) {
			final GenJavaOperation current = i.next();
			result.add(this.copyOperation(current));
		}
		return result;
	}
	
	private Collection<GenJavaAttribute> copyExceptionAttributes(final Collection<GenJavaAttribute> attributes) {
		// TODO IMPLEMENT THIS METHOD...
		return attributes;
	}
	
	private List<GenParameter> copyParams(final List<GenParameter> parameters) {
		final List<GenParameter> result = new ArrayList<>();
		final Iterator<GenParameter> i = parameters.iterator();
		while (i.hasNext()) {
			final GenParameter current = i.next();
			result.add(GenParameter.create(current.getName(), current.getTyp()));
		}
		return result;
	}
	
	private ArrayList<Generic> copyGenerics(final ArrayList<Generic> generics) {
		final ArrayList<Generic> result = new ArrayList<>();
		final Iterator<Generic> i = generics.iterator();
		while (i.hasNext()) {
			final Generic current = i.next();
			result.add(Generic.create(current.getGenericName(), current.getGenericType()));
		}
		return result;
	}
	
	// TODO Ist not used yet, but is used in different methods which are uncommented.
	// private void addParameterToHandles(final GenJavaOperation op, final Type type)
	// throws GeneratedNameTooLongException, GenTypeNotReferencedException {
	// final GenParameter parameter =
	// GenParameter.create(
	// UtilVisitorTransformer.firstToLowerCase(TypeNameGenerator.getInstance().getTypeName(type)
	// .getLastAddedName().toString()),
	// this.getGeneratorModel().getGenTypeForType(type));
	// op.getParameters().add(parameter);
	// }
	
	// TODO Ist not used yet, but is used in different methods which are uncommented.
	// private boolean visitorNecessary(final ProductType p) {
	// boolean result = false;
	// final Iterator<ProductElementType> i = p.getElements().iterator();
	// while (i.hasNext() && !result) {
	// final ProductElementType current = i.next();
	// result = this.hasVisitableElement(current);
	// if (this.isBasetypeOrCollection(current)) {
	// // throw NoBaseTypeOrCollectionInSumAndProductAllowed.create();
	// // TODO what to do for a product visitor?
	// }
	// }
	// return result;
	// }
	
	// TODO Ist not used yet, but is used in different methods which are uncommented.
	// private boolean hasVisitableElement(final ProductElementType current) {
	// return current.getType().accept(new TypeVisitorReturn<Boolean>() {
	// @Override
	// public Boolean handle(final AtomicType s) {
	// return false;
	// }
	//
	// @Override
	// public Boolean handle(final CompositeType c) {
	// return false;
	// }
	//
	// @Override
	// public Boolean handle(final TypeProxy s) {
	// return HelperUtils.getTargetAtomicType(s).accept(new TypeVisitorReturn<Boolean>() {
	//
	// @Override
	// public Boolean handle(final AtomicType s) {
	// return s.accept(new AtomicTypeVisitorReturn<Boolean>() {
	//
	// @Override
	// public Boolean handle(final BaseType baseType) {
	// return false;
	// }
	//
	// @Override
	// public Boolean handle(final ClassType clazz) {
	// return UtilVisitorTransformer.isVisitable(clazz);
	// }
	// });
	// }
	//
	// @Override
	// public Boolean handle(final CompositeType c) {
	// return false;
	//
	// }
	//
	// @Override
	// public Boolean handle(final TypeProxy s) {
	// return false;
	// }
	// });
	// }
	// });
	// }
	
	// TODO Ist not used yet, but is used in different methods which are uncommented.
	// private boolean isBasetypeOrCollection(final ProductElementType element) {
	// return element.getType().accept(new TypeVisitorReturn<Boolean>() {
	//
	// @Override
	// public Boolean handle(final AtomicType s) {
	// return s.accept(new AtomicTypeVisitorReturn<Boolean>() {
	//
	// @Override
	// public Boolean handle(final BaseType arg0) {
	// return true;
	// }
	//
	// @Override
	// public Boolean handle(final ClassType arg0) {
	// return false;
	// }
	// });
	// }
	//
	// @Override
	// public Boolean handle(final CompositeType c) {
	// return c.accept(new CompositeTypeVisitorReturn<Boolean>() {
	//
	// @Override
	// public Boolean handle(final MapType arg0) {
	// return true;
	// }
	//
	// @Override
	// public Boolean handle(final ProductType arg0) {
	// return false;
	// }
	//
	// @Override
	// public Boolean handle(final SumType arg0) {
	// return false;
	// }
	//
	// @Override
	// public Boolean handle(final de.fhdw.wtf.common.ast.type.ListType list) {
	// return true;
	// }
	// });
	// }
	//
	// @Override
	// public Boolean handle(final TypeProxy s) {
	// return false;
	// }
	// });
	// }
	
	public GeneratorModel getGeneratorModel() {
		return this.generatorModel;
	}
	
	public GenException getCurrentException() {
		return this.currentException;
	}
	
	public void setCurrentException(final GenException currentException) {
		this.currentException = currentException;
	}
	
	public GenType getCurrentReturnType() {
		return this.currentReturnType;
	}
	
	public void setCurrentReturnType(final GenType currentReturnType) {
		this.currentReturnType = currentReturnType;
	}
	
	public boolean hasTypeHandled(final GenInterfaceClass visitor, final GenType handledType) {
		final List<GenType> list = this.handledTypes.get(visitor);
		return list != null && list.contains(handledType);
	}
	
	public void addHandledType(final GenInterfaceClass visitor, final GenType handledType) {
		List<GenType> list = this.handledTypes.get(visitor);
		if (list == null) {
			list = new ArrayList<>();
			this.handledTypes.put(visitor, list);
		}
		list.add(handledType);
	}
	
	@Override
	public void beginTask() throws TaskException {
		// nothing to do
	}
	
	@Override
	public void finalizeTask() throws TaskException {
		// nothing to do
	}
}
