package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenCollectionTypeVisitor;

/**
 * Represents a map type in the generator model.
 */
public class GenMutableMap extends GenCollectionType {
	
	/**
	 * Name of the Context class representing maps.
	 */
	private static final String MUTABLE_MAP_TYPENAME = "MutableMap";
	
	/**
	 * The map's key type.
	 */
	private GenType key;
	
	/**
	 * Creates a {@link GenMutableMap} object.
	 *
	 * @param key
	 *            The map's key type.
	 * @param value
	 *            The map's value type.
	 */
	protected GenMutableMap(final GenType key, final GenType value) {
		super(MUTABLE_MAP_TYPENAME, value);
		this.key = key;
	}
	
	/**
	 * Creates a {@link GenMutableMap} object.
	 *
	 * @param key
	 *            The map's key type.
	 * @param value
	 *            The map's value type.
	 * @return A {@link GenMutableMap} object.
	 */
	public static GenMutableMap create(final GenType key, final GenType value) {
		return new GenMutableMap(key, value);
	}
	
	/**
	 * Returns the map's key type.
	 *
	 * @return The map's key type.
	 */
	public GenType getKey() {
		return this.key;
	}
	
	/**
	 * Sets the map's key type.
	 *
	 * @param key
	 *            The map's new key type.
	 */
	public void setKey(final GenType key) {
		this.key = key;
	}
	
	@Override
	public String getFullyQualifiedTypeNameWithGenericArguments() {
		return this.getFullyQualifiedTypeName() + GEN_OPEN
				+ this.getKey().getFullyQualifiedTypeNameWithGenericArguments() + COMMA
				+ this.getType().getFullyQualifiedTypeNameWithGenericArguments() + GEN_CLOSE;
	}
	
	@Override
	public void accept(final GenCollectionTypeVisitor visitor) {
		visitor.handle(this);
	}
	
}
