/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.clipper;

import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.DependencyTask;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.common.task.result.ExceptionalTaskResult;
import de.fhdw.wtf.common.task.result.OKTaskResult;
import de.fhdw.wtf.common.task.result.TaskResult;
import de.fhdw.wtf.file.FileUtils;
import de.fhdw.wtf.generator.transformer.clipper.ClipperConfiguration;
import de.fhdw.wtf.generator.transformer.clipper.ClipperUtils;
import de.fhdw.wtf.generator.transformer.clipper.internal.ClipperJavaFileShadowCopy;
import de.fhdw.wtf.generator.transformer.exception.ClipperImportFormatException;
import de.fhdw.wtf.generator.transformer.util.Tuple;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClipToFileTask
extends DependencyTask {
    private static final String CURLY_BRACKET_CLOSE = "}";
    private static final String CURLY_BRACKET_OPEN = "{";
    private static final String FILESYSTEM_PATH_SEPERATOR = "/";
    private static final String BRACKET_CLOSE = "\\)";
    private static final String BRACKET_OPEN = "\\(";
    private final ClipperConfiguration configuration;

    public ClipToFileTask(TaskExecutor taskmanager, ClipperConfiguration configuration) {
        super(taskmanager);
        this.configuration = configuration;
    }

    public boolean containsTransitive(DependencyTask a) {
        return false;
    }

    public TaskResult doWork() {
        try {
            FileUtils.deleteDirectory(this.configuration.getRepoDirectoryRoot());
            this.walkThroughJava(new File(this.configuration.getJavaDirectoryRoot()));
        }
        catch (TaskException | IOException e) {
            return new ExceptionalTaskResult((Exception)e);
        }
        return new OKTaskResult();
    }

    private void walkThroughJava(File startDir) throws TaskException, IOException {
        File[] directoryListing = startDir.listFiles();
        if (directoryListing != null) {
            for (File child : directoryListing) {
                if (child.isDirectory()) {
                    this.walkThroughJava(child);
                    continue;
                }
                String fullClassName = child.getCanonicalFile().getCanonicalPath();
                fullClassName = fullClassName.substring(new File(this.configuration.getJavaDirectoryRoot()).getCanonicalPath().length() + 1);
                File classDir = this.createDirectoryForClass(fullClassName);
                try {
                    this.scanFileToDirectory(child, classDir);
                }
                catch (TaskException | ClipperImportFormatException e) {
                    System.err.println("ClipperImportFormatException(" + fullClassName + "): " + e.getMessage());
                }
            }
        } else {
            System.err.println("ClipperImportFormatException(" + startDir + "): Java Directory cannot be accessed.");
        }
    }

    private void scanFileToDirectoryInternal(File path, ClipperJavaFileShadowCopy javaFile) throws IOException, ClipperImportFormatException {
        int i;
        File classRepoDir = path;
        if (!classRepoDir.exists() && !classRepoDir.mkdir()) {
            throw new ClipperImportFormatException("Ordner '" + classRepoDir + "' konnte nicht erzeugt werden!");
        }
        for (ClipperJavaFileShadowCopy current : javaFile.getInnerClasses()) {
            String newPath = path + FILESYSTEM_PATH_SEPERATOR + current.getName();
            this.scanFileToDirectoryInternal(new File(newPath), current);
        }
        String file = javaFile.getFullClass();
        file = this.extractNonGenerationPart(classRepoDir, file);
        String withoutcommentFile = ClipperUtils.simplifyJavaCode(file);
        int classStart = this.extractClassComment(classRepoDir, file, withoutcommentFile);
        int classEnd = ClipToFileTask.findCorrespondingClosingCurlyBracket(classStart, withoutcommentFile);
        String cFile = file.substring(classStart + 1, classEnd);
        String cWithoutComments = withoutcommentFile.substring(classStart + 1, classEnd);
        int pos = 0;
        while ((i = cWithoutComments.indexOf(String.valueOf(';'), pos)) != -1) {
            String opOrAttWithout = cWithoutComments.substring(pos, ++i);
            String opOrAttFile = cFile.substring(pos, i);
            opOrAttFile = this.removeLeadingWhiteBreaks(opOrAttFile);
            if (opOrAttWithout.contains("(")) {
                this.parseOperationToFile(opOrAttWithout, opOrAttFile, classRepoDir);
            } else {
                this.parseAttributeToFile(opOrAttWithout, opOrAttFile, classRepoDir);
            }
            pos = i;
        }
        int importsBegin = 0;
        int importsEnd = 0;
        importsBegin = file.indexOf("import ", importsBegin);
        if (importsBegin >= 0) {
            int importBegin = importsBegin;
            while (importBegin >= 0) {
                importsEnd = file.indexOf(59, importBegin);
                importBegin = file.indexOf("import", importsEnd);
            }
            String preCFile = file.substring(0, ++importsEnd);
            String importsBlockWithout = preCFile.substring(importsBegin, importsEnd);
            String importsBlockInFile = preCFile.substring(importsBegin, importsEnd);
            this.parseImportsToFile(importsBlockWithout, importsBlockInFile, classRepoDir);
        }
    }

    private void scanFileToDirectory(File classFile, File classRepoDir) throws IOException, TaskException, ClipperImportFormatException {
        String file = FileUtils.getFileString(classFile.getAbsolutePath());
        ClipperJavaFileShadowCopy clss = new ClipperJavaFileShadowCopy();
        clss.analyze(file);
        this.scanFileToDirectoryInternal(classRepoDir, clss);
    }

    private String removeLeadingWhiteBreaks(String opOrAttFile) {
        String result = opOrAttFile;
        boolean lastRunWithoutChanges = false;
        while (!lastRunWithoutChanges) {
            lastRunWithoutChanges = true;
            if (result.startsWith("\t\n")) {
                result = result.replaceFirst("\t\n", "");
                lastRunWithoutChanges = false;
            }
            if (result.startsWith("\n")) {
                result = result.replaceFirst("\n", "");
                lastRunWithoutChanges = false;
            }
            if (!result.startsWith("\t\t")) continue;
            result = result.replaceFirst("\t\t", "\t");
            lastRunWithoutChanges = false;
        }
        return result;
    }

    private void parseImportsToFile(String withoutcomments, String file, File classRepoDir) throws IOException {
        FileUtils.saveToFile(file, new File(classRepoDir.getAbsolutePath() + FILESYSTEM_PATH_SEPERATOR + "#imports"));
    }

    private void parseAttributeToFile(String withoutcomments, String file, File classRepoDir) throws IOException {
        String opPattern = "\\s*(?<type>.*)?\\s+(?<name>[A-Za-z_$\u20ac][\\.A-Za-z_$\u20ac0-9]*)\\s*;";
        Pattern p = Pattern.compile("\\s*(?<type>.*)?\\s+(?<name>[A-Za-z_$\u20ac][\\.A-Za-z_$\u20ac0-9]*)\\s*;", 32);
        Matcher m = p.matcher(withoutcomments);
        if (m.matches()) {
            String name = m.group("name");
            String type = ClipToFileTask.replaceIllegalChars(m.group("type"));
            String filename = "#attr#" + name + "#" + type;
            FileUtils.saveToFile(file, new File(classRepoDir.getAbsolutePath() + FILESYSTEM_PATH_SEPERATOR + filename));
        }
    }

    private List<String> repairGenerics(String[] params) {
        ArrayList<String> result = new ArrayList<String>();
        int angleBracketsDifference = 0;
        for (String param : params) {
            if (angleBracketsDifference != 0) {
                result.set(result.size() - 1, (String)result.get(result.size() - 1) + "," + param);
            } else {
                result.add(param);
            }
            angleBracketsDifference += param.split("<").length - param.split(">").length;
        }
        return result;
    }

    private void parseOperationToFile(String withoutcomments, String file, File classRepoDir) throws ClipperImportFormatException, IOException {
        String opPattern = "\\s*(?<type>.*\\s+)?(?<name>[A-Za-z_$\u20ac][\\.A-Za-z_$\u20ac0-9]*)\\s*\\((?<params>.*)\\).*\\s*;";
        Pattern p = Pattern.compile("\\s*(?<type>.*\\s+)?(?<name>[A-Za-z_$\u20ac][\\.A-Za-z_$\u20ac0-9]*)\\s*\\((?<params>.*)\\).*\\s*;", 32);
        Matcher m = p.matcher(withoutcomments);
        if (m.matches()) {
            String name = m.group("name");
            String type = m.group("type");
            String params = m.group("params");
            if (type == null) {
                name = "#constructor";
            }
            if (params.trim().length() > 0) {
                params = params + ",";
                String[] paramStrings = params.split(",");
                String nextWordPattern = "\\s*(.*)\\s+([A-Za-z_$\u20ac][\\.A-Za-z_$\u20ac0-9]*)\\s*";
                Pattern p1 = Pattern.compile("\\s*(.*)\\s+([A-Za-z_$\u20ac][\\.A-Za-z_$\u20ac0-9]*)\\s*", 32);
                for (String para : this.repairGenerics(paramStrings)) {
                    String trimmedPara = para.trim();
                    Matcher m1 = p1.matcher(trimmedPara);
                    if (m1.matches()) {
                        String paramType = trimmedPara.substring(m1.start(1), m1.end(1));
                        name = name + "#" + paramType;
                        continue;
                    }
                    throw new ClipperImportFormatException("Parameter seems invalid: " + params);
                }
            }
            if (!name.contains("#constructor") && !(name = ClipToFileTask.replaceIllegalChars(name)).startsWith("$super")) {
                FileUtils.saveToFile(file, new File(classRepoDir.getAbsolutePath() + FILESYSTEM_PATH_SEPERATOR + name));
            }
        } else {
            throw new ClipperImportFormatException("Regex does not match operation signature!");
        }
    }

    private int extractClassComment(File classRepoDir, String file, String withoutcommentFile) throws IOException, ClipperImportFormatException {
        String classKeyword = "\\s(class|interface)\\s";
        Pattern p2 = Pattern.compile("\\s(class|interface)\\s", 32);
        Matcher m2 = p2.matcher(withoutcommentFile);
        if (m2.find()) {
            int commentEnd;
            int start = m2.start();
            Tuple<Integer, Integer> commentBefore = ClipperUtils.getCommentBefore(start, file, withoutcommentFile);
            int commentStart = commentBefore.getA();
            if (commentStart != (commentEnd = commentBefore.getB().intValue())) {
                FileUtils.saveToFile(file.substring(commentStart, commentEnd), new File(classRepoDir.getAbsolutePath() + FILESYSTEM_PATH_SEPERATOR + "#classcomment"));
            }
            return file.indexOf(String.valueOf(CURLY_BRACKET_OPEN), start);
        }
        throw new ClipperImportFormatException("Keyword 'class' or 'interface' not found!");
    }

    private String extractNonGenerationPart(File classRepoDir, String file) throws IOException {
        String fileWithoutNonGenerationPart = file;
        Pattern p2 = Pattern.compile(".*// --> NON-GENERATION-PART <--(.*)}\\s*", 32);
        Matcher m2 = p2.matcher(file);
        if (m2.matches()) {
            String nongenpart = file.substring(m2.start(1), m2.end(1));
            nongenpart = nongenpart.replaceFirst("\\r|\\n", "");
            FileUtils.saveToFile(nongenpart, new File(classRepoDir.getAbsolutePath() + FILESYSTEM_PATH_SEPERATOR + "#protectedArea"));
            fileWithoutNonGenerationPart = file.substring(0, m2.start(1)) + "\r\n" + file.substring(m2.end(1));
        }
        return fileWithoutNonGenerationPart;
    }

    public static Integer findCorrespondingClosingCurlyBracket(int openBracketPos, String file) throws ClipperImportFormatException {
        Integer lastOpenedBracketPos = openBracketPos;
        Integer openBracketMinusClosed = 1;
        while (openBracketMinusClosed != 0) {
            Integer n;
            Integer n2;
            int indexOfOpen;
            int indexOfClose = file.indexOf(String.valueOf(CURLY_BRACKET_CLOSE), lastOpenedBracketPos + 1);
            if (indexOfClose < (indexOfOpen = file.indexOf(String.valueOf(CURLY_BRACKET_OPEN), lastOpenedBracketPos + 1)) || indexOfOpen == -1) {
                n2 = openBracketMinusClosed;
                n = openBracketMinusClosed = Integer.valueOf(openBracketMinusClosed - 1);
                lastOpenedBracketPos = indexOfClose;
            } else {
                n2 = openBracketMinusClosed;
                n = openBracketMinusClosed = Integer.valueOf(openBracketMinusClosed + 1);
                lastOpenedBracketPos = indexOfOpen;
            }
            if (indexOfClose != -1) continue;
            throw new ClipperImportFormatException("Unbalanced Brackets!");
        }
        return lastOpenedBracketPos;
    }

    public static String replaceIllegalChars(String name) {
        return name.replaceAll("<", "%{").replaceAll(">", "%}");
    }

    private File createDirectoryForClass(String fullQualifiedName) throws TaskException {
        String path;
        File result;
        boolean success;
        String directoryName = fullQualifiedName;
        if (directoryName.toLowerCase().endsWith(".java")) {
            directoryName = directoryName.substring(0, fullQualifiedName.length() - ".java".length());
        }
        if (!(success = (result = new File(path = this.configuration.getRepoDirectoryRoot() + FILESYSTEM_PATH_SEPERATOR + directoryName.replace(".", FILESYSTEM_PATH_SEPERATOR))).mkdirs())) {
            throw new TaskException("Directory creation failed: " + path);
        }
        return result;
    }
}

