/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.writer.writer;

import de.fhdw.wtf.generator.java.generatorModel.GenAspectAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenAttributeModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;
import de.fhdw.wtf.generator.java.visitor.GenAttributeVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitor;
import de.fhdw.wtf.generator.writer.writer.ClassFileWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import org.apache.velocity.context.Context;

public abstract class ClassClassFileWriter
extends ClassFileWriter {
    private static final String CONSTRUCTOR_KEY = "constructors";
    private static final String CONSTRUCTOR_COMMENT_KEY = "constructorComment";
    static final String ATTRIBUTES_KEY = "attributes";

    public ClassClassFileWriter(String template, boolean fullyQualified) {
        super(template, fullyQualified);
    }

    void writeClassClass(GenClassClass c) {
        this.writeClass(c);
        this.setUpContext(c, this.getCurrentContext());
    }

    private void setUpContext(GenClassClass c, Context currentContext) {
        this.setClassModifier(c, currentContext);
        this.setConstructors(c, currentContext);
        this.setExtends(c, currentContext);
    }

    private void setClassModifier(GenClassClass c, Context currentContext) {
        Vector<String> modifiers = new Vector<String>();
        for (GenClassModifier modifier : c.getModifieres()) {
            modifiers.add(modifier.toString());
        }
        currentContext.put("classModifiers", modifiers);
    }

    Vector<HashMap<String, Object>> getAttributes(Collection<? extends GenAttribute> attributes) {
        Vector<HashMap<String, Object>> result = new Vector<HashMap<String, Object>>();
        for (GenAttribute genAttribute : attributes) {
            final HashMap<String, Object> current = new HashMap<String, Object>();
            current.put("visibility", genAttribute.getVisibility().toString());
            current.put("name", genAttribute.getName());
            current.put("typ", this.typeToString(genAttribute.getTyp()));
            Vector<String> modifiers = new Vector<String>();
            for (GenAttributeModifier modifier : genAttribute.getModifiers()) {
                modifiers.add(modifier.toString());
            }
            current.put("modifiers", modifiers);
            genAttribute.accept(new GenAttributeVisitorReturn<GenAttribute>(){

                @Override
                public GenAttribute handleJavaAttribute(GenJavaAttribute attribute) {
                    return attribute;
                }

                @Override
                public GenAttribute handleAspectAttribute(GenAspectAttribute attribute) {
                    current.put("targedClass", ClassClassFileWriter.this.typeToString(attribute.getOwner()) + ".");
                    return attribute;
                }
            });
            result.add(current);
        }
        return result;
    }

    private void setConstructors(GenClass c, final Context currentContext) {
        c.accept(new GenClassVisitor(){

            @Override
            public void handle(GenInterfaceClass interfaceClass) {
            }

            @Override
            public void handle(GenClassClass classClass) {
                final Vector constructors = new Vector();
                for (final GenOperation genOperation : classClass.getConstructors()) {
                    genOperation.getState().accept(new GenOperationStateVisitor(){

                        @Override
                        public void handle(GenFullParsedOperationState s) {
                            HashMap<String, String> current = new HashMap<String, String>();
                            current.put("visibility", s.getVisibility().toString());
                            current.put("parameter", ClassClassFileWriter.this.getParamString(genOperation.getParameters()));
                            current.put("method", s.getMethodBody());
                            current.put(ClassClassFileWriter.CONSTRUCTOR_COMMENT_KEY, s.getComment().getText());
                            current.put("exceptions", ClassClassFileWriter.this.getExceptionString(s.getExceptions()));
                            constructors.add(current);
                        }

                        @Override
                        public void handle(GenSimpleOperationState s) {
                        }
                    });
                }
                currentContext.put(ClassClassFileWriter.CONSTRUCTOR_KEY, constructors);
            }

            @Override
            public void handle(GenPrimitiveClass primitiveClass) {
            }
        });
    }

    private void setExtends(GenClassClass c, Context currentContext) {
        if (c.getExtend() != null) {
            currentContext.put("extends", (Object)("extends " + this.typeToString(c.getExtend())));
        } else {
            currentContext.put("extends", (Object)"");
        }
    }
}

